/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.helper.Sides;
import net.minecraft.core.world.World;

public class BlockAxisAligned
extends Block {
    public BlockAxisAligned(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        Axis axis = entity.getPlacementDirection(side, PlacementMode.SIDE).getAxis();
        world.setBlockMetadataWithNotify(x, y, z, BlockAxisAligned.axisToMeta(axis));
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (6 * (data & 3) + side.getId() >= Sides.orientationLookUpXYZAligned.length) {
            return 0;
        }
        return this.atlasIndices[Sides.orientationLookUpXYZAligned[6 * (data & 3) + side.getId()]];
    }

    public static int axisToMeta(Axis axis) {
        if (axis == Axis.X) {
            return 2;
        }
        if (axis == Axis.Z) {
            return 1;
        }
        return 0;
    }

    public static Axis metaToAxis(int meta) {
        if (meta == 2) {
            return Axis.X;
        }
        if (meta == 1) {
            return Axis.Z;
        }
        return Axis.Y;
    }
}

