/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntityRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityArrowGolden;
import net.minecraft.core.entity.projectile.EntityCannonball;
import net.minecraft.core.entity.projectile.EntityEgg;
import net.minecraft.core.entity.projectile.EntityPebble;
import net.minecraft.core.entity.projectile.EntitySnowball;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class BlockDispenser
extends BlockTileEntityRotatable {
    private Random random = new Random();

    public BlockDispenser(String key, int id) {
        super(key, id, Material.stone);
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        super.onBlockAdded(world, x, y, z);
        this.setDispenserDefaultDirection(world, x, y, z);
    }

    private void setDispenserDefaultDirection(World world, int i, int j, int k) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int byte0 = 3;
        if (Block.solid[l] && !Block.solid[i1]) {
            byte0 = 3;
        }
        if (Block.solid[i1] && !Block.solid[l]) {
            byte0 = 2;
        }
        if (Block.solid[j1] && !Block.solid[k1]) {
            byte0 = 5;
        }
        if (Block.solid[k1] && !Block.solid[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i, j, k, byte0);
    }

    @Override
    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isClientSide) {
            return true;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(x, y, z);
        player.displayGUIDispenser(tileentitydispenser);
        return true;
    }

    private void dispenseItem(World world, int i, int j, int k, Random random) {
        int l = world.getBlockMetadata(i, j, k);
        int i1 = 0;
        int j1 = 0;
        if (l == 3) {
            j1 = 1;
        } else if (l == 2) {
            j1 = -1;
        } else {
            i1 = l == 5 ? 1 : -1;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(i, j, k);
        ItemStack itemstack = tileentitydispenser.getRandomStackFromInventory();
        double d = (double)i + (double)i1 * 0.6 + 0.5;
        double d1 = (double)j + 0.5;
        double d2 = (double)k + (double)j1 * 0.6 + 0.5;
        if (itemstack == null) {
            world.playSoundEffect(1001, i, j, k, 0);
        } else {
            if (itemstack.itemID == Item.ammoArrow.id || itemstack.itemID == Item.ammoArrowGold.id) {
                EntityArrow entityarrow = itemstack.itemID == Item.ammoArrow.id ? new EntityArrow(world, d, d1, d2, 0) : new EntityArrowGolden(world, d, d1, d2);
                entityarrow.setHeading(i1, 0.1f, j1, 1.1f, 6.0f);
                entityarrow.doesArrowBelongToPlayer = true;
                world.entityJoinedWorld(entityarrow);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.ammoChargeExplosive.id) {
                EntityCannonball entitycannonball = new EntityCannonball(world, d, d1, d2);
                entitycannonball.setHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entitycannonball);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.eggChicken.id) {
                EntityEgg entityegg = new EntityEgg(world, d, d1, d2);
                entityegg.setHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entityegg);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.ammoSnowball.id) {
                EntitySnowball entitysnowball = new EntitySnowball(world, d, d1, d2);
                entitysnowball.setHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(entitysnowball);
                world.playSoundEffect(1002, i, j, k, 0);
            } else if (itemstack.itemID == Item.ammoPebble.id) {
                EntityPebble pebble = new EntityPebble(world, d, d1, d2);
                pebble.setHeading(i1, 0.1, j1, 1.1f, 6.0f);
                world.entityJoinedWorld(pebble);
                world.playSoundEffect(1002, i, j, k, 0);
            } else {
                EntityItem entityitem = new EntityItem(world, d, d1 - 0.3, d2, itemstack);
                double d3 = random.nextDouble() * 0.1 + 0.2;
                entityitem.xd = (double)i1 * d3;
                entityitem.yd = 0.2f;
                entityitem.zd = (double)j1 * d3;
                entityitem.xd += random.nextGaussian() * (double)0.0075f * 6.0;
                entityitem.yd += random.nextGaussian() * (double)0.0075f * 6.0;
                entityitem.zd += random.nextGaussian() * (double)0.0075f * 6.0;
                world.entityJoinedWorld(entityitem);
                world.playSoundEffect(1000, i, j, k, 0);
            }
            world.playSoundEffect(2000, i, j, k, i1 + 1 + (j1 + 1) * 3);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (blockId > 0 && Block.blocksList[blockId].canProvidePower()) {
            boolean flag;
            boolean bl = flag = world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z);
            if (flag) {
                world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
            }
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z)) {
            this.dispenseItem(world, x, y, z, rand);
        }
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityDispenser();
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (world.getBlockTileEntity(x, y, z) != null) {
            TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(x, y, z);
            for (int l = 0; l < tileentitydispenser.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentitydispenser.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)this.random.nextGaussian() * f3;
                    entityitem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }
}

