/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.DoubleTag;
import com.mojang.nbt.FloatTag;
import com.mojang.nbt.ListTag;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightningBolt;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.data.SynchedEntityData;

public abstract class Entity
implements IVehicle {
    private static int entityCounter = 0;
    public int id = entityCounter++;
    public double viewScale = 1.0;
    public boolean blocksBuilding = false;
    public Entity passenger;
    public IVehicle vehicle;
    public World world;
    public double xo;
    public double yo;
    public double zo;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public float yRot;
    public float xRot;
    public float yRotO;
    public float xRotO;
    public final AABB bb = AABB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean collision = false;
    public boolean hurtMarked = false;
    public boolean hadNicknameSet;
    public boolean stuck;
    public boolean slide = true;
    public boolean removed = false;
    public float heightOffset = 0.0f;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.825f;
    public float walkDistO = 0.0f;
    public float walkDist = 0.0f;
    public float fallDistance = 0.0f;
    private int nextStep = 1;
    public float ySlideOffset = 0.0f;
    public float footSize = 0.0f;
    public boolean noPhysics = false;
    public float pushthrough = 0.0f;
    protected Random random = new Random();
    public int tickCount;
    public int fireImmuneTicks = 1;
    public int remainingFireTicks = 0;
    public int maxFireTicks;
    private int soundCooldown;
    protected int airMaxSupply = 300;
    protected boolean wasInWater = false;
    public int heartsFlashTime = 0;
    public int airSupply = 300;
    private boolean firstTick = true;
    protected boolean fireImmune;
    protected SynchedEntityData entityData = new SynchedEntityData();
    public float entityBrightness = 0.0f;
    private double entityRiderPitchDelta;
    private double entityRiderYawDelta;
    public boolean addedToChunk = false;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public int serverPosX;
    public int serverPosY;
    public int serverPosZ;
    public boolean ignoreFrustumCheck;
    public boolean isWalking = false;
    protected boolean muteStepSounds = false;
    public float speed;
    public float flySpeed;
    public boolean sendAdditionalData = false;
    public boolean turnWithVehicle = true;

    public Entity(World world) {
        this.world = world;
        this.setPos(0.0, 0.0, 0.0);
        this.entityData.define(0, (byte)0);
        this.init();
    }

    protected abstract void init();

    public void spawnInit() {
    }

    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public boolean equals(Object that) {
        if (that instanceof Entity) {
            return ((Entity)that).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    protected void resetPos() {
        if (this.world == null) {
            return;
        }
        while (!(this.y <= 0.0)) {
            this.setPos(this.x, this.y, this.z);
            if (this.world.getCubes(this, this.bb).size() == 0) break;
            this.y += 1.0;
        }
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.xRot = 0.0f;
    }

    public void remove() {
        this.removed = true;
    }

    public boolean showBoundingBoxOnHover() {
        return false;
    }

    protected void setSize(float width, float height) {
        this.bbWidth = width;
        this.bbHeight = height;
    }

    public void setRot(float yRot, float xRot) {
        this.yRot = yRot % 360.0f;
        this.xRot = xRot % 360.0f;
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        float center = this.bbWidth / 2.0f;
        float heightOfMob = this.bbHeight;
        this.bb.setBounds(x - (double)center, y - (double)this.heightOffset + (double)this.ySlideOffset, z - (double)center, x + (double)center, y - (double)this.heightOffset + (double)this.ySlideOffset + (double)heightOfMob, z + (double)center);
    }

    public void interpolateTurn(float yRot, float xRot) {
        float xRotCurrent = this.xRot;
        float yRotCurrent = this.yRot;
        this.yRot = (float)((double)this.yRot + (double)yRot * 0.15);
        this.xRot = (float)((double)this.xRot - (double)xRot * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
        this.xRotO += this.xRot - xRotCurrent;
        this.yRotO += this.yRot - yRotCurrent;
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        int z;
        int y;
        int x;
        int floorBlock;
        if (this.vehicle != null && this.vehicle.isRemoved()) {
            this.vehicle = null;
        }
        ++this.tickCount;
        this.walkDistO = this.walkDist;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xRotO = this.xRot;
        this.yRotO = this.yRot;
        if (this.isSprinting() && (floorBlock = this.world.getBlockId(x = MathHelper.floor_double(this.x), y = MathHelper.floor_double(this.y - 0.2 - (double)this.heightOffset), z = MathHelper.floor_double(this.z))) > 0) {
            this.world.spawnParticle("tilecrack_" + floorBlock, this.x + ((double)this.random.nextFloat() - 0.5) * (double)this.bbWidth, this.bb.minY + 0.1, this.z + ((double)this.random.nextFloat() - 0.5) * (double)this.bbWidth, -this.xd * 4.0, 1.5, -this.zd * 4.0);
        }
        this.checkOnWater(true);
        if (this.world.isClientSide) {
            this.remainingFireTicks = 0;
        } else if (this.remainingFireTicks > 0) {
            if (this.fireImmune) {
                this.remainingFireTicks -= 4;
                if (this.remainingFireTicks < 0) {
                    this.remainingFireTicks = 0;
                }
            } else {
                if (this.remainingFireTicks % 20 == 0) {
                    this.hurt(null, 1, DamageType.FIRE);
                }
                --this.remainingFireTicks;
            }
        }
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        if (this.isInLava()) {
            this.lavaHurt();
        }
        if (this.y < -64.0) {
            this.outOfWorld();
        }
        if (!this.world.isClientSide) {
            this.setSharedFlag(0, this.remainingFireTicks > 0);
            this.setSharedFlag(2, this.vehicle != null);
        }
        this.firstTick = false;
    }

    protected void checkOnWater(boolean addVelocity) {
        if (this.checkAndHandleWater(addVelocity)) {
            if (!this.wasInWater && !this.firstTick) {
                double offZ;
                double offX;
                float f = MathHelper.sqrt_double(this.xd * this.xd * 0.2 + this.yd * this.yd + this.zd * this.zd * 0.2) * 0.2f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                if (!Global.isServer) {
                    this.world.playSoundAtEntity(null, this, "random.splash", f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                } else if (!this.world.isClientSide && this.soundCooldown == 0) {
                    this.soundCooldown = 2;
                    this.world.playSoundAtEntity(this, this, "random.splash", f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                }
                float f1 = MathHelper.floor_double(this.bb.minY);
                int i = 0;
                while ((float)i < 1.0f + this.bbWidth * 20.0f) {
                    offX = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    offZ = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.world.spawnParticle("bubble", this.x + offX, f1 + 1.0f, this.z + offZ, this.xd, this.yd - (double)(this.random.nextFloat() * 0.2f), this.zd);
                    ++i;
                }
                int j = 0;
                while ((float)j < 1.0f + this.bbWidth * 20.0f) {
                    offX = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    offZ = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.world.spawnParticle("splash", this.x + offX, f1 + 1.0f, this.z + offZ, this.xd, this.yd, this.zd);
                    ++j;
                }
            }
            this.fallDistance = 0.0f;
            this.wasInWater = true;
            this.remainingFireTicks = 0;
        } else {
            this.wasInWater = false;
        }
    }

    public void lavaHurt() {
        if (!this.fireImmune) {
            this.hurt(null, 4, DamageType.FIRE);
            this.maxFireTicks = this.remainingFireTicks = 600;
        }
    }

    public void fireHurt() {
        if (!this.fireImmune) {
            this.hurt(null, 1, DamageType.FIRE);
            this.maxFireTicks = this.remainingFireTicks = 300;
        }
    }

    public void outOfWorld() {
        this.remove();
    }

    public boolean isFree(double x, double y, double z) {
        AABB offsetBb = this.bb.getOffsetBoundingBox(x, y, z).expand(-0.01, -0.01, -0.01);
        List<AABB> list = this.world.getCubes(this, offsetBb);
        if (list.size() > 0) {
            return false;
        }
        return !this.world.getIsAnyLiquid(offsetBb);
    }

    public void move(double xd, double yd, double zd) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        boolean sneakingOnGround;
        if (this.noPhysics) {
            this.onGround = false;
            this.bb.offset(xd, yd, zd);
            this.x = (this.bb.minX + this.bb.maxX) / 2.0;
            this.y = this.bb.minY + (double)this.heightOffset - (double)this.ySlideOffset;
            this.z = (this.bb.minZ + this.bb.maxZ) / 2.0;
            return;
        }
        this.ySlideOffset *= 0.4f;
        double d3 = this.x;
        double d4 = this.z;
        if (this.stuck) {
            this.stuck = false;
            xd *= 0.25;
            yd *= 0.05;
            zd *= 0.25;
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
        }
        double oldXd = xd;
        double oldYd = yd;
        double oldZd = zd;
        AABB bbCopy = this.bb.copy();
        boolean bl = sneakingOnGround = this.onGround && this.isSneaking();
        if (sneakingOnGround) {
            double maxSneakOverhang = 0.05;
            while (xd != 0.0 && this.world.getCubes(this, this.bb.getOffsetBoundingBox(xd, -1.0, 0.0)).size() == 0) {
                xd = xd < maxSneakOverhang && xd >= -maxSneakOverhang ? 0.0 : (xd > 0.0 ? (xd -= maxSneakOverhang) : (xd += maxSneakOverhang));
                oldXd = xd;
            }
            while (zd != 0.0 && this.world.getCubes(this, this.bb.getOffsetBoundingBox(0.0, -1.0, zd)).size() == 0) {
                zd = zd < maxSneakOverhang && zd >= -maxSneakOverhang ? 0.0 : (zd > 0.0 ? (zd -= maxSneakOverhang) : (zd += maxSneakOverhang));
                oldZd = zd;
            }
        }
        List<AABB> cubes = this.world.getCubes(this, this.bb.addCoord(xd, yd, zd));
        for (AABB aABB : cubes) {
            yd = aABB.calculateYOffset(this.bb, yd);
        }
        this.bb.offset(0.0, yd, 0.0);
        if (!this.slide && oldYd != yd) {
            zd = 0.0;
            yd = 0.0;
            xd = 0.0;
        }
        boolean flag1 = this.onGround || oldYd != yd && oldYd < 0.0;
        for (AABB aabb : cubes) {
            xd = aabb.calculateXOffset(this.bb, xd);
        }
        this.bb.offset(xd, 0.0, 0.0);
        if (!this.slide && oldXd != xd) {
            zd = 0.0;
            yd = 0.0;
            xd = 0.0;
        }
        for (AABB aabb : cubes) {
            zd = aabb.calculateZOffset(this.bb, zd);
        }
        this.bb.offset(0.0, 0.0, zd);
        if (!this.slide && oldZd != zd) {
            zd = 0.0;
            yd = 0.0;
            xd = 0.0;
        }
        if (this.footSize > 0.0f && flag1 && (sneakingOnGround || this.ySlideOffset < 0.05f) && (oldXd != xd || oldZd != zd)) {
            double d = xd;
            double oldY = yd;
            double oldZ = zd;
            xd = oldXd;
            yd = this.footSize;
            zd = oldZd;
            AABB axisalignedbb1 = this.bb.copy();
            this.bb.setBB(bbCopy);
            List<AABB> list1 = this.world.getCubes(this, this.bb.addCoord(xd, yd, zd));
            for (AABB aabb : list1) {
                yd = aabb.calculateYOffset(this.bb, yd);
            }
            this.bb.offset(0.0, yd, 0.0);
            if (!this.slide && oldYd != yd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            }
            for (AABB aabb : list1) {
                xd = aabb.calculateXOffset(this.bb, xd);
            }
            this.bb.offset(xd, 0.0, 0.0);
            if (!this.slide && oldXd != xd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            }
            for (AABB aabb : list1) {
                zd = aabb.calculateZOffset(this.bb, zd);
            }
            this.bb.offset(0.0, 0.0, zd);
            if (!this.slide && oldZd != zd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            }
            if (!this.slide && oldYd != yd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            } else {
                yd = -this.footSize;
                for (AABB aabb : list1) {
                    yd = aabb.calculateYOffset(this.bb, yd);
                }
                this.bb.offset(0.0, yd, 0.0);
            }
            if (d * d + oldZ * oldZ >= xd * xd + zd * zd) {
                xd = d;
                yd = oldY;
                zd = oldZ;
                this.bb.setBB(axisalignedbb1);
            }
        }
        if (!this.world.isClientSide || this instanceof EntityPlayer || !(this instanceof EntityLiving)) {
            this.x = (this.bb.minX + this.bb.maxX) / 2.0;
            this.y = this.bb.minY + (double)this.heightOffset - (double)this.ySlideOffset;
            this.z = (this.bb.minZ + this.bb.maxZ) / 2.0;
        }
        this.horizontalCollision = oldXd != xd || oldZd != zd;
        this.verticalCollision = oldYd != yd;
        this.onGround = oldYd != yd && oldYd < 0.0;
        this.collision = this.horizontalCollision || this.verticalCollision;
        this.checkOnWater(false);
        this.checkFallDamage(yd, this.onGround);
        if (oldXd != xd) {
            this.xd = 0.0;
        }
        if (oldYd != yd) {
            this.yd = 0.0;
        }
        if (oldZd != zd) {
            this.zd = 0.0;
        }
        double d = this.x - d3;
        double d12 = this.z - d4;
        if (this.makeStepSound() && !sneakingOnGround && this.vehicle == null) {
            int blockYUp;
            Block blockAbove;
            this.walkDist = (float)((double)this.walkDist + (double)MathHelper.sqrt_double(d * d + d12 * d12) * 0.6);
            AABB boundingBox = AABB.getBoundingBox(this.x - 0.01, this.bb.minY - 0.01, this.z - 0.01, this.x + 0.01, this.bb.minY + 0.01, this.z + 0.01);
            int blockX = MathHelper.floor_double(this.x);
            int blockY = MathHelper.floor_double(boundingBox.minY);
            int blockZ = MathHelper.floor_double(this.z);
            Block blockWalkedOn = null;
            block9: for (int x = blockX - 1; x <= blockX + 1; ++x) {
                for (int z = blockZ - 1; z <= blockZ + 1; ++z) {
                    for (int y = blockY - 1; y < blockY + 1; ++y) {
                        Block block = this.world.getBlock(x, y, z);
                        if (block == null) continue;
                        this.world.collidingBoundingBoxes.clear();
                        block.getCollidingBoundingBoxes(this.world, x, y, z, boundingBox, this.world.collidingBoundingBoxes);
                        if (this.world.collidingBoundingBoxes.isEmpty()) continue;
                        blockWalkedOn = block;
                        blockX = x;
                        blockY = y;
                        blockZ = z;
                        break block9;
                    }
                }
            }
            if ((blockAbove = this.world.getBlock(blockX, blockYUp = MathHelper.floor_double(boundingBox.maxY), blockZ)) != null && blockAbove.hasTag(BlockTags.OVERRIDE_STEPSOUND)) {
                blockWalkedOn = blockAbove;
                blockY = blockYUp;
            }
            this.isWalking = this.walkDistO != this.walkDist;
            int walkedSteps = (int)(this.walkDist - (float)this.nextStep);
            if (walkedSteps > 0 && blockWalkedOn != null) {
                this.nextStep += walkedSteps;
                if (!this.muteStepSounds) {
                    this.world.playBlockSoundEffect(this, this.x, this.bb.minY, this.z, blockWalkedOn, EnumBlockSoundEffectType.STEP);
                    blockWalkedOn.onEntityWalking(this.world, blockX, blockY, blockZ, this);
                }
            }
        }
        if (this.world.areBlocksLoaded(minX = MathHelper.floor_double(this.bb.minX + 0.001), minY = MathHelper.floor_double(this.bb.minY + 0.001), minZ = MathHelper.floor_double(this.bb.minZ + 0.001), maxX = MathHelper.floor_double(this.bb.maxX - 0.001), maxY = MathHelper.floor_double(this.bb.maxY - 0.001), maxZ = MathHelper.floor_double(this.bb.maxZ - 0.001))) {
            for (int _x = minX; _x <= maxX; ++_x) {
                for (int _y = minY; _y <= maxY; ++_y) {
                    for (int _z = minZ; _z <= maxZ; ++_z) {
                        int blockId = this.world.getBlockId(_x, _y, _z);
                        if (blockId <= 0) continue;
                        Block.blocksList[blockId].onEntityCollidedWithBlock(this.world, _x, _y, _z, this);
                    }
                }
            }
        }
        boolean inWaterOrRain = this.isInWaterOrRain();
        if (this.world.isBoundingBoxBurning(this.bb.getInsetBoundingBox(0.001, 0.001, 0.001))) {
            this.burn(1);
            if (!inWaterOrRain) {
                ++this.remainingFireTicks;
                if (this.remainingFireTicks == 0) {
                    this.remainingFireTicks = 300;
                }
                this.maxFireTicks = this.remainingFireTicks;
            }
        } else if (this.remainingFireTicks <= 0) {
            this.remainingFireTicks = -this.fireImmuneTicks;
        }
        if (inWaterOrRain && this.remainingFireTicks > 0) {
            this.world.playSoundAtEntity(null, this, "random.fizz", 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            this.remainingFireTicks = -this.fireImmuneTicks;
        }
    }

    protected boolean makeStepSound() {
        return true;
    }

    protected void checkFallDamage(double d, boolean flag) {
        if (flag) {
            if (this.fallDistance > 0.0f) {
                this.causeFallDamage(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (d < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - d);
        }
    }

    public AABB getBb() {
        return null;
    }

    protected void burn(int damage) {
        if (!this.fireImmune) {
            this.hurt(null, damage, DamageType.FIRE);
        }
    }

    protected void causeFallDamage(float f) {
        if (this.passenger != null) {
            this.passenger.causeFallDamage(f);
        }
    }

    public boolean isInWaterOrRain() {
        return this.wasInWater || this.world.canBlockBeRainedOn(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z));
    }

    public boolean isInWater() {
        return this.wasInWater;
    }

    public boolean checkAndHandleWater(boolean addVelocity) {
        return this.world.handleMaterialAcceleration(this.bb.expand(0.0, -0.4f, 0.0).getInsetBoundingBox(0.001, 0.001, 0.001), Material.water, this, addVelocity);
    }

    public boolean isUnderLiquid(Material material) {
        int k;
        int j;
        double d = this.y + (double)this.getHeadHeight();
        int i = MathHelper.floor_double(this.x);
        int l = this.world.getBlockId(i, j = MathHelper.floor_float(MathHelper.floor_double(d)), k = MathHelper.floor_double(this.z));
        if (l != 0 && Block.blocksList[l].blockMaterial == material) {
            float f = BlockFluid.getWaterVolume(this.world.getBlockMetadata(i, j, k)) - 0.2f;
            float f1 = (float)(j + 1) - f;
            return d < (double)f1;
        }
        return false;
    }

    public float getHeadHeight() {
        return 0.0f;
    }

    public boolean isInLava() {
        return this.world.isMaterialInBB(this.bb.expand(-0.1, -0.4, -0.1), Material.lava);
    }

    public void moveRelative(float f, float f1, float f2) {
        float f3 = MathHelper.sqrt_float(f * f + f1 * f1);
        if (f3 < 0.01f) {
            return;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        f3 = f2 / f3;
        float sinYaw = MathHelper.sin(this.yRot * 3.141593f / 180.0f);
        float cosYaw = MathHelper.cos(this.yRot * 3.141593f / 180.0f);
        this.xd += (double)((f *= f3) * cosYaw - (f1 *= f3) * sinYaw);
        this.zd += (double)(f1 * cosYaw + f * sinYaw);
    }

    public float getBrightness(float partialTick) {
        if (Global.accessor.isFullbrightEnabled()) {
            return 1.0f;
        }
        int i = MathHelper.floor_double(this.x);
        double d = (this.bb.maxY - this.bb.minY) * 0.66;
        int j = MathHelper.floor_double(this.y - (double)this.heightOffset + d);
        int k = MathHelper.floor_double(this.z);
        if (this.world != null && this.world.areBlocksLoaded(MathHelper.floor_double(this.bb.minX), MathHelper.floor_double(this.bb.minY), MathHelper.floor_double(this.bb.minZ), MathHelper.floor_double(this.bb.maxX), MathHelper.floor_double(this.bb.maxY), MathHelper.floor_double(this.bb.maxZ))) {
            float f1 = this.world.getLightBrightness(i, j, k);
            if (f1 < this.entityBrightness) {
                f1 = this.entityBrightness;
            }
            return f1;
        }
        return this.entityBrightness;
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void absMoveTo(double x, double y, double z, float yRot, float xRot) {
        this.xo = this.x = x;
        this.yo = this.y = y;
        this.zo = this.z = z;
        this.yRotO = this.yRot = yRot;
        this.xRotO = this.xRot = xRot;
        this.ySlideOffset = 0.0f;
        double d3 = this.yRotO - yRot;
        if (d3 < -180.0) {
            this.yRotO += 360.0f;
        }
        if (d3 >= 180.0) {
            this.yRotO -= 360.0f;
        }
        this.setPos(this.x, this.y, this.z);
        this.setRot(yRot, xRot);
    }

    public void moveTo(double x, double y, double z, float yRot, float xRot) {
        this.xo = this.x = x;
        this.yo = this.y = y + (double)this.heightOffset;
        this.zo = this.z = z;
        this.yRot = yRot;
        this.xRot = xRot;
        this.setPos(this.x, this.y, this.z);
    }

    public float distanceTo(Entity entity) {
        float f = (float)(this.x - entity.x);
        float f1 = (float)(this.y - entity.y);
        float f2 = (float)(this.z - entity.z);
        return MathHelper.sqrt_float(f * f + f1 * f1 + f2 * f2);
    }

    public double distanceToSqr(double d, double d1, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d1;
        double d5 = this.z - d2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double distanceTo(double d, double d1, double d2) {
        double d3 = this.x - d;
        double d4 = this.y - d1;
        double d5 = this.z - d2;
        return MathHelper.sqrt_double(d3 * d3 + d4 * d4 + d5 * d5);
    }

    public double distanceToSqr(Entity entity) {
        double d = this.x - entity.x;
        double d1 = this.y - entity.y;
        double d2 = this.z - entity.z;
        return d * d + d1 * d1 + d2 * d2;
    }

    public void playerTouch(EntityPlayer player) {
    }

    public boolean collidesWith(Entity entity) {
        return true;
    }

    public boolean collidesWithBlock(Block block, int metadata) {
        return true;
    }

    public void push(Entity entity) {
        if (entity.passenger == this || entity.vehicle == this || entity.noPhysics || !entity.isPickable() || !this.collidesWith(entity) || !entity.collidesWith(this)) {
            return;
        }
        double d = entity.x - this.x;
        double d1 = entity.z - this.z;
        double d2 = MathHelper.abs_max(d, d1);
        if (d2 >= 0.01) {
            d2 = MathHelper.sqrt_double(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= 0.05;
            d1 *= 0.05;
            this.push(-(d *= (double)(1.0f - this.pushthrough)), 0.0, -(d1 *= (double)(1.0f - this.pushthrough)));
            entity.push(d, 0.0, d1);
        }
    }

    public void push(double x, double y, double z) {
        this.xd += x;
        this.yd += y;
        this.zd += z;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(Entity attacker, int baseDamage, DamageType type) {
        this.markHurt();
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isSelectable() {
        return this.isPickable();
    }

    public boolean isPushable() {
        return false;
    }

    public void awardKillScore(Entity entity, int i) {
    }

    public boolean shouldRender(Vec3d vec3d) {
        double d = this.x - vec3d.xCoord;
        double d1 = this.y - vec3d.yCoord;
        double d2 = this.z - vec3d.zCoord;
        double d3 = d * d + d1 * d1 + d2 * d2;
        return this.shouldRenderAtSqrDistance(d3);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.bb.getAverageEdgeLength();
        return distance < (d1 *= 64.0 * this.viewScale) * d1;
    }

    public String getEntityTexture() {
        return null;
    }

    public boolean save(CompoundTag tag) {
        String s = this.getEntityString();
        if (this.removed || s == null) {
            return false;
        }
        tag.putString("id", s);
        this.saveWithoutId(tag);
        return true;
    }

    public void saveWithoutId(CompoundTag tag) {
        tag.put("Pos", this.newDoubleList(new double[]{this.x, this.y + (double)this.ySlideOffset, this.z}));
        tag.put("Motion", this.newDoubleList(new double[]{this.xd, this.yd, this.zd}));
        tag.put("Rotation", this.newFloatNBTList(new float[]{this.yRot, this.xRot}));
        tag.putFloat("FallDistance", this.fallDistance);
        tag.putShort("Fire", (short)this.remainingFireTicks);
        tag.putShort("Air", (short)this.airSupply);
        tag.putBoolean("OnGround", this.onGround);
        this.addAdditionalSaveData(tag);
    }

    public void load(CompoundTag tag) {
        ListTag posTag = tag.getList("Pos");
        ListTag motionTag = tag.getList("Motion");
        ListTag rotationTag = tag.getList("Rotation");
        this.xd = (Double)((DoubleTag)motionTag.tagAt(0)).getValue();
        this.yd = (Double)((DoubleTag)motionTag.tagAt(1)).getValue();
        this.zd = (Double)((DoubleTag)motionTag.tagAt(2)).getValue();
        if ((double)MathHelper.abs((float)this.xd) > 10.0) {
            this.xd = 0.0;
        }
        if ((double)MathHelper.abs((float)this.yd) > 10.0) {
            this.yd = 0.0;
        }
        if ((double)MathHelper.abs((float)this.zd) > 10.0) {
            this.zd = 0.0;
        }
        this.xo = this.x = ((Double)((DoubleTag)posTag.tagAt(0)).getValue()).doubleValue();
        this.yo = this.y = ((Double)((DoubleTag)posTag.tagAt(1)).getValue()).doubleValue();
        this.zo = this.z = ((Double)((DoubleTag)posTag.tagAt(2)).getValue()).doubleValue();
        this.yRotO = this.yRot = ((Float)((FloatTag)rotationTag.tagAt(0)).getValue()).floatValue();
        this.xRotO = this.xRot = ((Float)((FloatTag)rotationTag.tagAt(1)).getValue()).floatValue();
        this.fallDistance = tag.getFloat("FallDistance");
        this.maxFireTicks = this.remainingFireTicks = (int)tag.getShort("Fire");
        this.airSupply = tag.getShort("Air");
        this.onGround = tag.getBoolean("OnGround");
        this.setPos(this.x, this.y, this.z);
        this.setRot(this.yRot, this.xRot);
        this.readAdditionalSaveData(tag);
    }

    protected final String getEntityString() {
        return EntityDispatcher.getEntityString(this);
    }

    public abstract void readAdditionalSaveData(CompoundTag var1);

    public abstract void addAdditionalSaveData(CompoundTag var1);

    protected ListTag newDoubleList(double[] array) {
        ListTag list = new ListTag();
        for (double d : array) {
            list.addTag(new DoubleTag(d));
        }
        return list;
    }

    protected ListTag newFloatNBTList(float[] array) {
        ListTag list = new ListTag();
        for (float f : array) {
            list.addTag(new FloatTag(f));
        }
        return list;
    }

    public float getShadowHeightOffs() {
        return this.bbHeight / 2.0f;
    }

    public EntityItem spawnAtLocation(int itemId, int stackSize) {
        return this.spawnAtLocation(itemId, stackSize, 0.0f);
    }

    public EntityItem spawnAtLocation(int itemId, int stackSize, float verticalOffset) {
        return this.spawnAtLocation(new ItemStack(itemId, stackSize, 0), verticalOffset);
    }

    public EntityItem spawnAtLocation(ItemStack itemStack, float verticalOffset) {
        EntityItem entityitem = new EntityItem(this.world, this.x, this.y + (double)verticalOffset, this.z, itemStack);
        entityitem.delayBeforeCanPickup = 10;
        this.world.entityJoinedWorld(entityitem);
        return entityitem;
    }

    public boolean isAlive() {
        return !this.removed;
    }

    public boolean isInWall() {
        for (int i = 0; i < 8; ++i) {
            int l;
            int k;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.bbWidth * 0.9f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.bbWidth * 0.9f;
            int j = MathHelper.floor_double(this.x + (double)f);
            if (!this.world.isBlockNormalCube(j, k = MathHelper.floor_double(this.y + (double)this.getHeadHeight() + (double)f1), l = MathHelper.floor_double(this.z + (double)f2))) continue;
            return true;
        }
        return false;
    }

    public boolean interact(EntityPlayer entityplayer) {
        return false;
    }

    public void rideTick() {
        if (this.vehicle.isRemoved() || this.isSneaking()) {
            this.vehicle.ejectRider();
            return;
        }
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.tick();
        if (this.vehicle == null) {
            return;
        }
        this.vehicle.positionRider();
        this.entityRiderYawDelta += (double)this.vehicle.getYRotDelta();
        this.entityRiderPitchDelta += (double)this.vehicle.getXRotDelta();
        while (this.entityRiderYawDelta >= 180.0) {
            this.entityRiderYawDelta -= 360.0;
        }
        while (this.entityRiderYawDelta < -180.0) {
            this.entityRiderYawDelta += 360.0;
        }
        while (this.entityRiderPitchDelta >= 180.0) {
            this.entityRiderPitchDelta -= 360.0;
        }
        while (this.entityRiderPitchDelta < -180.0) {
            this.entityRiderPitchDelta += 360.0;
        }
        double d = this.entityRiderYawDelta * 0.5;
        double d1 = this.entityRiderPitchDelta * 0.5;
        float f = 10.0f;
        if (d > (double)f) {
            d = f;
        }
        if (d < (double)(-f)) {
            d = -f;
        }
        if (d1 > (double)f) {
            d1 = f;
        }
        if (d1 < (double)(-f)) {
            d1 = -f;
        }
        this.entityRiderYawDelta -= d;
        if (this.turnWithVehicle) {
            this.yRot = (float)((double)this.yRot + d);
        }
    }

    @Override
    public void positionRider() {
        this.passenger.setPos(this.x, this.y + this.getRideHeight() + this.passenger.getRidingHeight(), this.z);
    }

    public double getRidingHeight() {
        return this.heightOffset;
    }

    public double getRideHeight() {
        return (double)this.bbHeight * 0.75;
    }

    public void startRiding(IVehicle vehicle) {
        if (!this.canRide()) {
            return;
        }
        if (this.vehicle == vehicle) {
            return;
        }
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (vehicle == null) {
            if (this.vehicle != null) {
                this.vehicle.moveExitingEntity(this);
                this.vehicle.setPassenger(null);
            }
            this.vehicle = null;
            return;
        }
        if (this.vehicle != null) {
            this.vehicle.setPassenger(null);
        }
        if (vehicle.getPassenger() != null) {
            vehicle.getPassenger().vehicle = null;
        }
        this.vehicle = vehicle;
        vehicle.setPassenger(this);
    }

    @Override
    public Entity ejectRider() {
        Entity entity = this.passenger;
        if (entity == null) {
            return null;
        }
        this.passenger = null;
        entity.vehicle = null;
        entity.moveTo(this.x, this.bb.minY, this.z, entity.yRot, entity.xRot);
        return entity;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.setPos(x, y, z);
        this.setRot(yRot, xRot);
        List<AABB> cubes = this.world.getCubes(this, this.bb.getInsetBoundingBox(0.03125, 0.0, 0.03125));
        if (cubes.size() > 0) {
            double d3 = 0.0;
            for (AABB cube : cubes) {
                if (!(cube.maxY > d3)) continue;
                d3 = cube.maxY;
            }
            this.setPos(x, y += d3 - this.bb.minY, z);
        }
    }

    public float getPickRadius() {
        return 0.1f;
    }

    public Vec3d getLookAngle() {
        return null;
    }

    public void handlePortal(int portalTileId) {
    }

    public ItemStack[] getInventory() {
        return null;
    }

    public void lerpMotion(double xd, double yd, double zd) {
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
    }

    public void handleEntityEvent(byte byte0, float attackedAtYaw) {
    }

    public void animateHurt() {
    }

    public void setEquippedSlot(int i, int j, int k, CompoundTag tag) {
    }

    public boolean isOnFire() {
        return !this.fireImmune && this.remainingFireTicks > 0 || this.getSharedFlag(0);
    }

    public boolean isPassenger() {
        return this.vehicle != null || this.getSharedFlag(2);
    }

    public boolean isSneaking() {
        return this.getSharedFlag(1);
    }

    public void setSneaking(boolean flag) {
        this.setSharedFlag(1, flag);
    }

    protected boolean getSharedFlag(int i) {
        return (this.entityData.getByte(0) & 1 << i) != 0;
    }

    protected void setSharedFlag(int i, boolean flag) {
        byte byte0 = this.entityData.getByte(0);
        if (flag) {
            this.entityData.set(0, (byte)(byte0 | 1 << i));
        } else {
            this.entityData.set(0, (byte)(byte0 & ~(1 << i)));
        }
    }

    public void thunderHit(EntityLightningBolt bolt) {
        this.burn(5);
        ++this.remainingFireTicks;
        if (this.remainingFireTicks == 0) {
            this.remainingFireTicks = 300;
        }
        this.maxFireTicks = this.remainingFireTicks;
    }

    public void killed(EntityLiving entityliving) {
    }

    protected boolean checkInTile(double d, double d1, double d2) {
        int i = MathHelper.floor_double(d);
        int j = MathHelper.floor_double(d1);
        int k = MathHelper.floor_double(d2);
        double d3 = d - (double)i;
        double d4 = d1 - (double)j;
        double d5 = d2 - (double)k;
        if (this.world.isBlockNormalCube(i, j, k)) {
            boolean flag = !this.world.isBlockNormalCube(i - 1, j, k);
            boolean flag1 = !this.world.isBlockNormalCube(i + 1, j, k);
            boolean flag2 = !this.world.isBlockNormalCube(i, j - 1, k);
            boolean flag3 = !this.world.isBlockNormalCube(i, j + 1, k);
            boolean flag4 = !this.world.isBlockNormalCube(i, j, k - 1);
            boolean flag5 = !this.world.isBlockNormalCube(i, j, k + 1);
            int byte0 = -1;
            double d6 = 9999.0;
            if (flag && d3 < d6) {
                d6 = d3;
                byte0 = 0;
            }
            if (flag1 && 1.0 - d3 < d6) {
                d6 = 1.0 - d3;
                byte0 = 1;
            }
            if (flag2 && d4 < d6) {
                d6 = d4;
                byte0 = 2;
            }
            if (flag3 && 1.0 - d4 < d6) {
                d6 = 1.0 - d4;
                byte0 = 3;
            }
            if (flag4 && d5 < d6) {
                d6 = d5;
                byte0 = 4;
            }
            if (flag5 && 1.0 - d5 < d6) {
                double d7 = 1.0 - d5;
                byte0 = 5;
            }
            float f = this.random.nextFloat() * 0.2f + 0.1f;
            if (byte0 == 0) {
                this.xd = -f;
            }
            if (byte0 == 1) {
                this.xd = f;
            }
            if (byte0 == 2) {
                this.yd = -f;
            }
            if (byte0 == 3) {
                this.yd = f;
            }
            if (byte0 == 4) {
                this.zd = -f;
            }
            if (byte0 == 5) {
                this.zd = f;
            }
        }
        return false;
    }

    public boolean canRide() {
        return true;
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean sprinting) {
        this.setSharedFlag(3, sprinting);
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public void setPassenger(Entity passenger) {
        this.passenger = passenger;
    }

    @Override
    public Entity getPassenger() {
        return this.passenger;
    }

    @Override
    public void moveExitingEntity(Entity entity) {
        entity.moveTo(this.x, this.bb.minY + (double)this.bbHeight, this.z, entity.yRot, entity.xRot);
    }

    @Override
    public float getYRotDelta() {
        return this.yRot - this.yRotO;
    }

    @Override
    public float getXRotDelta() {
        return this.xRot - this.xRotO;
    }
}

