/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFlying;
import net.minecraft.core.entity.animal.IAnimal;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;

public class EntityFireflyCluster
extends EntityFlying
implements IAnimal {
    public final int maxLifetime = 12000;
    public final int maxClusterSize = 6;
    public final int slowUpdateCooldownMax = 500;
    public final int maxFireflyCountPerCluster = 64;
    public int courseChangeCooldown;
    public int fireflyAge = 0;
    private int syncedClusterSize = -1;
    private int slowUpdateCooldown;

    public EntityFireflyCluster(World world) {
        super(world);
        if (world == null || world.isClientSide) {
            this.setClusterSize(0);
            this.setFireflyCount(0);
        } else {
            this.setClusterSize(this.random.nextInt(6));
            this.setFireflyCount(this.random.nextInt(5) + 3);
        }
        this.setSizeBasedOnClusterSize(this.getClusterSize());
        this.courseChangeCooldown = 0;
        this.moveSpeed = 0.05f;
        this.fireImmune = true;
        if (world != null) {
            this.slowUpdateCooldown = world.rand.nextInt(500);
        }
    }

    @Override
    public void spawnInit() {
        super.init();
        Biome currentBiome = this.world.getBlockBiome((int)this.x, (int)this.y, (int)this.z);
        FireflyColor color = null;
        Collection<FireflyColor> colors = FireflyColor.fireFlyColors.values();
        for (FireflyColor fireFlyColor : colors) {
            Biome[] spawnBiomes = fireFlyColor.getSpawnBiomes();
            if (spawnBiomes == null) continue;
            for (Biome spawnBiome : spawnBiomes) {
                if (spawnBiome != currentBiome) continue;
                color = fireFlyColor;
                break;
            }
            if (color == null) continue;
            break;
        }
        if (color == null) {
            color = FireflyColor.GREEN;
        }
        this.setColor(color);
    }

    protected FireflyColor getColourForBiome(Biome currentBiome) {
        for (FireflyColor c : FireflyColor.fireFlyColors.values()) {
            if (c.getSpawnBiomes() == null) continue;
            for (Biome b : c.getSpawnBiomes()) {
                if (b != currentBiome) continue;
                return c;
            }
        }
        return FireflyColor.GREEN;
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("colour", this.entityData.getByte(16));
        tag.putInt("FireflyAge", this.fireflyAge);
        tag.putInt("FireflyCount", this.getFireflyCount());
        tag.putInt("ClusterSize", this.getClusterSize());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(16, tag.getByte("colour"));
        this.fireflyAge = tag.getInteger("FireflyAge");
        this.setFireflyCount(tag.getInteger("FireflyCount"));
        this.setClusterSize(tag.getInteger("ClusterSize"));
        this.setPos(this.x, this.y, this.z);
    }

    @Override
    protected void init() {
        super.init();
        this.entityData.define(16, (byte)0);
        this.entityData.define(17, (byte)0);
        this.entityData.define(18, (byte)0);
    }

    public void setColor(FireflyColor colour) {
        this.entityData.set(16, (byte)colour.getId());
    }

    public FireflyColor getColor() {
        byte id = this.entityData.getByte(16);
        return FireflyColor.fireFlyColors.get(id);
    }

    public void setClusterSize(int clusterSize) {
        this.entityData.set(17, (byte)clusterSize);
        this.setSizeBasedOnClusterSize(clusterSize);
    }

    public int getClusterSize() {
        return this.entityData.getByte(17) & 0xFF;
    }

    public void setFireflyCount(int fireflyCount) {
        this.entityData.set(18, (byte)fireflyCount);
    }

    public int getFireflyCount() {
        return this.entityData.getByte(18) & 0xFF;
    }

    @Override
    protected void updatePlayerActionState() {
    }

    @Override
    public boolean getCanSpawnHere() {
        int x = MathHelper.floor_double(this.x);
        int y = MathHelper.floor_double(this.bb.minY);
        int z = MathHelper.floor_double(this.z);
        int id = this.world.getBlockId(x, y - 1, z);
        if (this.shouldRemove()) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Block, x, y, z) > 0) {
            return false;
        }
        if (this.world.getSavedLightValue(LightLayer.Sky, x, y, z) > this.random.nextInt(32)) {
            return false;
        }
        int blockLight = this.world.getBlockLightValue(x, y, z);
        if (this.world.getCurrentWeather() != null && this.world.getCurrentWeather().doMobsSpawnInDaylight) {
            blockLight /= 2;
        }
        return blockLight <= 4 && Block.blocksList[id] != null && Block.blocksList[id].hasTag(BlockTags.FIREFLIES_CAN_SPAWN) && this.world.checkIfAABBIsClear(this.bb.expand(-2.0, 0.0, -2.0));
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void push(Entity entity) {
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        return false;
    }

    @Override
    public String getLivingSound() {
        return "";
    }

    @Override
    protected String getHurtSound() {
        return "";
    }

    @Override
    protected String getDeathSound() {
        return "";
    }

    @Override
    public void tick() {
        int clusterSize;
        super.tick();
        ++this.fireflyAge;
        double dy = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbHeight;
        double dx = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
        double dz = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
        if (this.random.nextInt(Math.max(1, 10 - this.getFireflyCount())) == 0) {
            this.world.spawnParticle(this.getColor().getParticleName(), this.x + dx, this.y + dy, this.z + dz, this.xd, this.yd, this.zd, 256.0);
        }
        if (this.world.isClientSide && this.syncedClusterSize != (clusterSize = this.getClusterSize())) {
            this.setSizeBasedOnClusterSize(clusterSize);
            this.syncedClusterSize = clusterSize;
            this.setPos(this.x, this.y, this.z);
        }
        this.slowUpdates();
        if (!this.world.isClientSide && this.shouldRemove()) {
            this.remove();
        }
    }

    private boolean shouldRemove() {
        if (this.getFireflyCount() <= 0) {
            return true;
        }
        if (!this.world.getWorldType().hasCeiling() && this.world.isDaytime()) {
            return true;
        }
        return this.fireflyAge > 12000;
    }

    private void slowUpdates() {
        int blockZ;
        int blockY;
        int blockX;
        FireflyColor colorForBiome;
        if (--this.slowUpdateCooldown > 0) {
            return;
        }
        this.setPos(this.x, this.y, this.z);
        if (this.world.isClientSide) {
            return;
        }
        this.merge();
        if (this.getClusterSize() < 6) {
            this.expandIfPossible();
        }
        if ((colorForBiome = this.getColourForBiome(this.world.getBlockBiome(blockX = MathHelper.floor_double(this.x), blockY = MathHelper.floor_double(this.y), blockZ = MathHelper.floor_double(this.z)))) != this.getColor()) {
            this.setColor(colorForBiome);
        }
    }

    private void merge() {
        this.slowUpdateCooldown = 500;
        List<Entity> nearbyFireflies = this.world.getEntitiesWithinAABB(this.getClass(), this.bb.expand(2.0, 2.0, 2.0));
        int nearbyCount = nearbyFireflies.size();
        if (nearbyCount == 1) {
            return;
        }
        for (int i = 0; i < nearbyCount; ++i) {
            EntityFireflyCluster fireflyCluster;
            Entity entity = nearbyFireflies.get(i);
            if (entity == this || !(entity instanceof EntityFireflyCluster) || (fireflyCluster = (EntityFireflyCluster)entity).getColor() != this.getColor()) continue;
            if (fireflyCluster.getFireflyCount() > this.getFireflyCount() || fireflyCluster.getFireflyCount() == this.getFireflyCount() && this.world.rand.nextBoolean()) {
                this.merge(this, fireflyCluster);
            } else {
                this.merge(fireflyCluster, this);
            }
            if (this.isAlive()) continue;
            return;
        }
    }

    private void merge(EntityFireflyCluster from, EntityFireflyCluster to) {
        if (from.getFireflyCount() + to.getFireflyCount() < 64) {
            to.setFireflyCount(to.getFireflyCount() + from.getFireflyCount());
            from.remove();
        }
    }

    public void expandIfPossible() {
        int prevSize = this.getClusterSize();
        this.setSizeBasedOnClusterSize(prevSize + 1);
        this.setPos(this.x, this.y, this.z);
        if (this.world.getCollidingSolidBlockBoundingBoxes(this, this.bb).size() == 0) {
            this.setClusterSize(prevSize + 1);
            return;
        }
        this.setSizeBasedOnClusterSize(prevSize);
        this.setPos(this.x, this.y, this.z);
    }

    public void setSizeBasedOnClusterSize(int clusterSize) {
        this.setSize(0.1f + (float)clusterSize, 0.1f + (float)clusterSize * 0.6f);
    }

    @Override
    public int getMaxSpawnedInChunk() {
        return 1;
    }

    @Override
    public boolean canRide() {
        return false;
    }

    public static class FireflyColor {
        public static Map<Integer, FireflyColor> fireFlyColors = new HashMap<Integer, FireflyColor>();
        public static FireflyColor GREEN = FireflyColor.register(new FireflyColor(0, "fireflyGreen", new Biome[]{Biomes.OVERWORLD_RAINFOREST, Biomes.OVERWORLD_SWAMPLAND, Biomes.OVERWORLD_FOREST, Biomes.OVERWORLD_SEASONAL_FOREST}, new float[]{0.7f, 0.95f, 0.35f}));
        public static FireflyColor ORANGE = FireflyColor.register(new FireflyColor(1, "fireflyOrange", new Biome[]{Biomes.OVERWORLD_DESERT, Biomes.OVERWORLD_OUTBACK, Biomes.OVERWORLD_OUTBACK_GRASSY}, new float[]{1.0f, 0.9f, 0.58f}));
        public static FireflyColor BLUE = FireflyColor.register(new FireflyColor(2, "fireflyBlue", new Biome[]{Biomes.OVERWORLD_TAIGA, Biomes.OVERWORLD_TUNDRA, Biomes.OVERWORLD_BOREAL_FOREST, Biomes.OVERWORLD_GLACIER, Biomes.PARADISE_PARADISE}, new float[]{0.67f, 1.0f, 0.99f}));
        public static FireflyColor RED = FireflyColor.register(new FireflyColor(3, "fireflyRed", new Biome[]{Biomes.NETHER_NETHER}, new float[]{1.0f, 0.25f, 0.25f}));
        private final int id;
        private final String particleName;
        private Biome[] spawnBiomes;
        private float[] midColor;

        public static FireflyColor register(FireflyColor color) {
            fireFlyColors.put(color.getId(), color);
            return color;
        }

        public int getId() {
            return this.id;
        }

        public String getParticleName() {
            return this.particleName;
        }

        public Biome[] getSpawnBiomes() {
            return this.spawnBiomes;
        }

        public float[] getMidColor() {
            return this.midColor;
        }

        public void setSpawnBiomes(Biome[] biomes) {
            this.spawnBiomes = biomes;
        }

        public FireflyColor(int id, String particleName, Biome[] spawnBiomes, float[] midColor) {
            this.id = id;
            this.particleName = particleName;
            this.spawnBiomes = spawnBiomes;
            this.midColor = midColor;
        }
    }
}

