/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemPainting
extends Item {
    public ItemPainting(String name, int id) {
        super(name, id);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.isClientSide && !entityplayer.isSneaking()) {
            entityplayer.displayGUIPaintingPicker();
        }
        return itemstack;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        EntityPainting entity;
        int sideHit = side.getId();
        if (sideHit == 0) {
            return false;
        }
        if (sideHit == 1) {
            return false;
        }
        int direction = 0;
        if (sideHit == 4) {
            direction = 1;
        }
        if (sideHit == 3) {
            direction = 2;
        }
        if (sideHit == 5) {
            direction = 3;
        }
        if ((entity = new EntityPainting(world, blockX, blockY, blockZ, direction, entityplayer.getSelectedArt().key)).canFitPainting()) {
            if (!world.isClientSide) {
                world.entityJoinedWorld(entity);
            }
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, Block.planksOak, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(entityplayer);
        }
        return true;
    }
}

