/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;

public class ItemBlockSlab
extends ItemBlock {
    public ItemBlockSlab(Block block) {
        super(block);
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int id = world.getBlockId(blockX, blockY, blockZ);
        int meta = world.getBlockMetadata(blockX, blockY, blockZ) & 3;
        int otherMeta = world.getBlockMetadata(blockX, blockY, blockZ) & 0xFFFFFFFC;
        if (Block.blocksList[world.getBlockId(blockX, blockY, blockZ)] != null && Block.blocksList[world.getBlockId(blockX, blockY, blockZ)].hasTag(BlockTags.PLACE_OVERWRITES)) {
            id = 0;
            meta = 0;
        }
        if (itemstack.stackSize <= 0) {
            return false;
        }
        if (blockY == world.getHeightBlocks() - 1 && Block.blocksList[this.blockID].blockMaterial.isSolid()) {
            return false;
        }
        if (id == this.blockID && otherMeta == itemstack.getMetadata() && (side == Side.TOP || side == Side.BOTTOM) && (side == Side.TOP && meta == 0 || side == Side.BOTTOM && meta == 2)) {
            AABB bbBox = AABB.getBoundingBoxFromPool(blockX, blockY, blockZ, (float)blockX + 1.0f, (float)blockY + 1.0f, (float)blockZ + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            Block blockSlab = Block.blocksList[this.blockID];
            world.setBlockMetadataWithNotify(blockX, blockY, blockZ, 1 | itemstack.getMetadata());
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, blockSlab, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (id != 0) {
            id = world.getBlockId(blockX += side.getOffsetX(), blockY += side.getOffsetY(), blockZ += side.getOffsetZ());
            meta = world.getBlockMetadata(blockX, blockY, blockZ) & 3;
            otherMeta = world.getBlockMetadata(blockX, blockY, blockZ) & 0xFFFFFFFC;
        }
        if (id == this.blockID && otherMeta == itemstack.getMetadata() && (yPlaced > 0.5 && meta == 0 || yPlaced <= 0.5 && meta == 2 || side == Side.BOTTOM && meta == 0 || side == Side.TOP && meta == 2)) {
            AABB bbBox = AABB.getBoundingBoxFromPool(blockX, blockY, blockZ, (float)blockX + 1.0f, (float)blockY + 1.0f, (float)blockZ + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            Block blockSlab = Block.blocksList[this.blockID];
            world.setBlockMetadataWithNotify(blockX, blockY, blockZ, 1 | itemstack.getMetadata());
            world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, blockSlab, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(entityplayer);
            return true;
        }
        if (world.canBlockBePlacedAt(this.blockID, blockX, blockY, blockZ, false, side)) {
            Block block = Block.blocksList[this.blockID];
            if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.blockID, this.getPlacedBlockMetadata(itemstack.getMetadata()))) {
                Block.blocksList[this.blockID].onBlockPlaced(world, blockX, blockY, blockZ, side, entityplayer, yPlaced);
                world.playBlockSoundEffect(entityplayer, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, block, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(entityplayer);
            }
            return true;
        }
        return false;
    }
}

