/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.crafting.legacy.recipe.IRecipe;
import net.minecraft.core.crafting.legacy.type.RecipeShaped;
import net.minecraft.core.crafting.legacy.type.RecipeShapeless;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.ContainerGuidebookRecipeBase;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotGuidebook;

public class ContainerGuidebookRecipeCrafting
extends ContainerGuidebookRecipeBase {
    public IRecipe recipe;

    public ContainerGuidebookRecipeCrafting(IRecipe recipe) {
        this.recipe = recipe;
        if (recipe instanceof RecipeShaped) {
            RecipeShaped r = (RecipeShaped)recipe;
            if (r.recipeHeight > 2 || r.recipeWidth > 2) {
                int slots = 10;
                for (int i = 0; i < slots - 1; ++i) {
                    int slotX = i % 3;
                    int slotY = i / 3;
                    if (slotX >= r.recipeWidth || slotY >= r.recipeHeight) {
                        this.addSlot(new SlotGuidebook(i, 1 + 18 * (i % 3), 1 + 18 * (i / 3), null, false));
                        continue;
                    }
                    ItemStack stack = r.recipeItems[slotX + slotY * r.recipeWidth];
                    if (stack == null) continue;
                    stack = stack.copy();
                    stack.stackSize = 1;
                }
            } else {
                int slots = 5;
                for (int i = 0; i < slots - 1; ++i) {
                    int slotX = i % 2;
                    int slotY = i / 2;
                    if (slotX >= r.recipeWidth || slotY >= r.recipeHeight) {
                        this.addSlot(new SlotGuidebook(i, 13 + 18 * (i % 2), 10 + 18 * (i / 2), null, false));
                        continue;
                    }
                    ItemStack stack = r.recipeItems[slotX + slotY * r.recipeWidth];
                    if (stack == null) continue;
                    stack = stack.copy();
                    stack.stackSize = 1;
                }
            }
        } else if (recipe instanceof RecipeShapeless) {
            RecipeShapeless r = (RecipeShapeless)recipe;
            int slots = 0;
            if (r.recipeItems.size() > 4) {
                slots = 10;
                for (int i = 0; i < r.recipeItems.size(); ++i) {
                    ItemStack stack = (ItemStack)r.recipeItems.get(i);
                    if (stack == null) continue;
                    stack = stack.copy();
                    stack.stackSize = 1;
                }
            } else {
                slots = 5;
                for (int i = 0; i < r.recipeItems.size(); ++i) {
                    ItemStack stack = (ItemStack)r.recipeItems.get(i);
                    if (stack == null) continue;
                    stack = stack.copy();
                    stack.stackSize = 1;
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported recipe type!!");
        }
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        return null;
    }
}

