/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListTag
extends Tag<List<Tag<?>>>
implements Iterable<Tag<?>> {
    private byte tagType;

    public ListTag() {
        this.setValue(new ArrayList());
    }

    public ListTag(List<Tag<?>> array) {
        super(array);
    }

    @Override
    void write(DataOutput dos) throws IOException {
        this.tagType = ((List)this.getValue()).size() > 0 ? ((Tag)((List)this.getValue()).get(0)).getId() : (byte)1;
        dos.writeByte(this.tagType);
        dos.writeInt(((List)this.getValue()).size());
        for (int i = 0; i < ((List)this.getValue()).size(); ++i) {
            ((Tag)((List)this.getValue()).get(i)).write(dos);
        }
    }

    @Override
    void read(DataInput dis) throws IOException {
        this.tagType = dis.readByte();
        int length = dis.readInt();
        this.setValue(new ArrayList());
        for (int i = 0; i < length; ++i) {
            Tag<?> tag = Tag.newTag(this.tagType);
            if (tag == null) continue;
            tag.read(dis);
            ((List)this.getValue()).add(tag);
        }
    }

    @Override
    public byte getId() {
        return 9;
    }

    public String toString() {
        if (((List)this.getValue()).size() > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((List)this.getValue()).size() + " elements ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (Tag d : (List)this.getValue()) {
            sb.append(d).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void addTag(Tag<?> tag) {
        this.tagType = tag.getId();
        ((List)this.getValue()).add(tag);
    }

    public Tag<?> tagAt(int index) {
        return (Tag)((List)this.getValue()).get(index);
    }

    public int tagCount() {
        return ((List)this.getValue()).size();
    }

    @Override
    public Iterator<Tag<?>> iterator() {
        return ((List)this.getValue()).iterator();
    }
}

