/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class EntityDiggingFX
extends EntityFX {
    private Block block;

    public EntityDiggingFX(World world, double d, double d1, double d2, double d3, double d4, double d5, Block block, int meta) {
        super(world, d, d1, d2, d3, d4, d5);
        this.block = block;
        this.particleTextureIndex = block != null ? block.getBlockTextureFromSideAndMetadata(Side.BOTTOM, meta) : 0;
        this.particleGravity = block.blockParticleGravity;
        this.particleBlue = 0.6f;
        this.particleGreen = 0.6f;
        this.particleRed = 0.6f;
        this.particleScale /= 2.0f;
    }

    public EntityDiggingFX func_4041_a(int i, int j, int k) {
        if (this.block != Block.grass) {
            int l = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(this.world, i, j, k);
            this.particleRed *= (float)(l >> 16 & 0xFF) / 255.0f;
            this.particleGreen *= (float)(l >> 8 & 0xFF) / 255.0f;
            this.particleBlue *= (float)(l & 0xFF) / 255.0f;
        }
        return this;
    }

    @Override
    public int getFXLayer() {
        return 1;
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)(this.particleTextureIndex % Global.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterX / 4.0f) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f7 = f6 + 0.25f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f8 = ((float)(this.particleTextureIndex / Global.TEXTURE_ATLAS_WIDTH_TILES) + this.particleTextureJitterY / 4.0f) / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f9 = f8 + 0.25f / (float)Global.TEXTURE_ATLAS_WIDTH_TILES;
        float f10 = 0.1f * this.particleScale;
        float f11 = (float)(this.xo + (this.x - this.xo) * (double)partialTick - lerpPosX);
        float f12 = (float)(this.yo + (this.y - this.yo) * (double)partialTick - lerpPosY);
        float f13 = (float)(this.zo + (this.z - this.zo) * (double)partialTick - lerpPosZ);
        float f14 = this.getBrightness(partialTick);
        t.setColorOpaque_F(f14 * this.particleRed, f14 * this.particleGreen, f14 * this.particleBlue);
        t.addVertexWithUV(f11 - rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 - rotationZ * f10 - rotationXY * f10, f6, f9);
        t.addVertexWithUV(f11 - rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 - rotationZ * f10 + rotationXY * f10, f6, f8);
        t.addVertexWithUV(f11 + rotationX * f10 + rotationYZ * f10, f12 + rotationXZ * f10, f13 + rotationZ * f10 + rotationXY * f10, f7, f8);
        t.addVertexWithUV(f11 + rotationX * f10 - rotationYZ * f10, f12 - rotationXZ * f10, f13 + rotationZ * f10 - rotationXY * f10, f7, f9);
    }
}

