/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.block.BlockFluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class EntityRainFX
extends EntityFX {
    public EntityRainFX(World world, double d, double d1, double d2) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.xd *= (double)0.3f;
        this.yd = (float)Math.random() * 0.2f + 0.1f;
        this.zd *= (double)0.3f;
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleTextureIndex = 19 + this.random.nextInt(4);
        this.setSize(0.01f, 0.01f);
        this.particleGravity = 0.06f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        super.renderParticle(t, partialTick, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public void tick() {
        double d;
        Material material;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= (double)this.particleGravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.remove();
        }
        if (this.onGround) {
            if (Math.random() < 0.5) {
                this.remove();
            }
            this.xd *= (double)0.7f;
            this.zd *= (double)0.7f;
        }
        if (((material = this.world.getBlockMaterial(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z))).isLiquid() || material.isSolid()) && this.y < (d = (double)((float)(MathHelper.floor_double(this.y) + 1) - BlockFluid.getWaterVolume(this.world.getBlockMetadata(MathHelper.floor_double(this.x), MathHelper.floor_double(this.y), MathHelper.floor_double(this.z)))))) {
            this.remove();
        }
    }
}

