/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiTexturedButton;
import net.minecraft.client.gui.popup.GuiPopup;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.player.controller.PlayerControllerSP;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import org.lwjgl.input.Keyboard;

public class GuiCreateWorld
extends GuiScreen {
    private int overrideSpawnX;
    private int overrideSpawnY;
    private int overrideSpawnZ;
    private GuiScreen field_22131_a;
    private GuiTextField textboxWorldName;
    private GuiTextField textboxSeed;
    private GuiButton createWorldButton;
    private GuiButton gamemodeButton;
    private GuiButton cheatsButton;
    private GuiButton worldTypeButton;
    private GuiTexturedButton buttonRandomWorldName;
    private GuiTexturedButton buttonRandomSeed;
    private String folderName;
    private boolean createClicked;
    private Gamemode selectedGamemode = Gamemode.survival;
    private boolean cheatsEnabled = false;
    private int worldType = 0;
    private final List<WorldType> worldTypes;
    private long seed = new Random().nextLong();

    public GuiCreateWorld(GuiScreen guiscreen) {
        this.field_22131_a = guiscreen;
        this.worldTypes = new ArrayList<WorldType>();
        this.worldTypes.addAll(Arrays.asList(WorldTypes.OVERWORLD_EXTENDED, WorldTypes.OVERWORLD_DEFAULT, WorldTypes.OVERWORLD_WINTER, WorldTypes.OVERWORLD_FLOATING, WorldTypes.OVERWORLD_AMPLIFIED, WorldTypes.OVERWORLD_ISLANDS, WorldTypes.OVERWORLD_INLAND, WorldTypes.FLAT, WorldTypes.OVERWORLD_HELL, WorldTypes.OVERWORLD_WOODS, WorldTypes.OVERWORLD_PARADISE, WorldTypes.OVERWORLD_CLASSIC, WorldTypes.OVERWORLD_INDEV, WorldTypes.OVERWORLD_RETRO, WorldTypes.EMPTY, WorldTypes.DEBUG));
        for (WorldType worldType : Registries.WORLD_TYPES) {
            if (this.worldTypes.contains(worldType)) continue;
            this.worldTypes.add(worldType);
        }
        this.worldTypes.remove(WorldTypes.NETHER_DEFAULT);
        this.worldTypes.remove(WorldTypes.PARADISE_DEFAULT);
    }

    @Override
    public void tick() {
        this.textboxWorldName.updateCursorCounter();
        this.textboxSeed.updateCursorCounter();
    }

    @Override
    public void init() {
        I18n i18n = I18n.getInstance();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.clear();
        this.createWorldButton = new GuiButton(0, this.width / 2 - 100, this.height / 4 + 104 + 12, i18n.translateKey("gui.create_world.button.create_new_world"));
        this.controlList.add(this.createWorldButton);
        this.controlList.add(new GuiButton(1, this.width / 2 - 100, this.height / 4 + 128 + 12, i18n.translateKey("gui.create_world.button.cancel")));
        this.textboxWorldName = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, 60, 176, 20, "", i18n.translateKey("gui.create_world.label.new_world"));
        this.textboxWorldName.setMaxStringLength(32);
        this.textboxSeed = new GuiTextField(this, this.fontRenderer, this.width / 2 - 100, 100, 176, 20, "", Long.toString(this.seed));
        this.gamemodeButton = new GuiButton(2, this.width / 2 - 100, 124, 98, 20, "");
        this.controlList.add(this.gamemodeButton);
        this.cheatsButton = new GuiButton(3, this.width / 2 - 100 + 102, 124, 98, 20, "");
        this.controlList.add(this.cheatsButton);
        this.worldTypeButton = new GuiButton(4, this.width / 2 - 100, 148, "");
        this.controlList.add(this.worldTypeButton);
        this.buttonRandomWorldName = new GuiTexturedButton(5, "/gui/gui.png", this.width / 2 + 100 - 20, 60, 60, 86, 20, 20);
        this.controlList.add(this.buttonRandomWorldName);
        this.buttonRandomSeed = new GuiTexturedButton(6, "/gui/gui.png", this.width / 2 + 100 - 20, 100, 60, 86, 20, 20);
        this.controlList.add(this.buttonRandomSeed);
        this.updateButtons();
        this.updateFolderName();
    }

    private void updateFolderName() {
        char[] ac;
        this.folderName = this.textboxWorldName.getText().trim();
        for (char c : ac = ChatAllowedCharacters.ALLOWED_CHARACTERS_ARRAY) {
            this.folderName = this.folderName.replace(c, '_');
        }
        if (MathHelper.stringNullOrLengthZero(this.folderName)) {
            this.folderName = "New World";
        }
        this.folderName = GuiCreateWorld.generateUnusedFolderName(this.mc.getSaveFormat(), this.folderName);
    }

    public static String generateUnusedFolderName(ISaveFormat isaveformat, String s) {
        int count = 1;
        String newString = s;
        while (isaveformat.getLevelData(newString) != null) {
            newString = s + " (" + count + ")";
            ++count;
        }
        return newString;
    }

    @Override
    public void onClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 1) {
            this.mc.displayGuiScreen(this.field_22131_a);
        } else if (button.id == 0) {
            this.mc.displayGuiScreen(null);
            if (this.createClicked) {
                return;
            }
            this.createClicked = true;
            long seed = this.seed;
            String seedText = this.textboxSeed.getText();
            if (!MathHelper.stringNullOrLengthZero(seedText)) {
                try {
                    long parsedSeed = Long.parseLong(seedText);
                    if (parsedSeed != 0L) {
                        seed = parsedSeed;
                    }
                }
                catch (NumberFormatException e) {
                    seed = seedText.hashCode();
                }
            }
            Dimension.overworld.setDefaultWorldType(this.worldTypes.get(this.worldType));
            this.mc.playerController = new PlayerControllerSP(this.mc);
            String worldName = this.textboxWorldName.getText();
            if (worldName.isEmpty()) {
                worldName = I18n.getInstance().translateKey("gui.create_world.label.new_world");
            }
            this.mc.startWorld(this.folderName, worldName, seed);
            this.mc.thePlayer.setGamemode(this.selectedGamemode);
            if (this.mc.worldPresetName != null) {
                this.mc.thePlayer.setPos(this.overrideSpawnX, this.overrideSpawnY, this.overrideSpawnZ);
            }
            this.mc.theWorld.getLevelData().setCheatsEnabled(this.cheatsEnabled);
            this.mc.displayGuiScreen(null);
        } else if (button == this.gamemodeButton) {
            I18n i18n = I18n.getInstance();
            this.selectedGamemode = Gamemode.gamemodesList[(this.selectedGamemode.getId() + 1) % Gamemode.gamemodesList.length];
            this.cheatsEnabled = this.selectedGamemode == Gamemode.creative;
            this.updateButtons();
        } else if (button == this.cheatsButton) {
            I18n i18n = I18n.getInstance();
            this.cheatsEnabled = !this.cheatsEnabled;
            this.updateButtons();
        } else if (button == this.worldTypeButton) {
            I18n i18n = I18n.getInstance();
            String[] keys = new String[this.worldTypes.size()];
            String[] descs = new String[this.worldTypes.size()];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = i18n.translateKey(this.worldTypes.get(i).getLanguageKey() + ".name");
                descs[i] = i18n.translateKey(this.worldTypes.get(i).getLanguageKey() + ".desc") + "\n" + TextFormatting.GRAY + Registries.WORLD_TYPES.getKey(this.worldTypes.get(i));
            }
            GuiPopup popup = new PopupBuilder(this, 150).closeOnEsc(0).closeOnClickOut(0).withLabel("gui.create_world.label.select_world_type").withList("worldTypeList", 140, keys, descs, this.worldType, true).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    this.worldType = (Integer)results.get("worldTypeList");
                    this.updateButtons();
                }
            }).build();
            this.mc.displayGuiScreen(popup);
        } else if (button == this.buttonRandomWorldName) {
            this.textboxWorldName.setText(I18n.getInstance().getCurrentLanguage().getRandomWorldName());
            this.updateFolderName();
        } else if (button == this.buttonRandomSeed) {
            this.seed = new Random().nextLong();
            this.textboxSeed.setPlaceholder(Long.toString(this.seed));
            this.textboxSeed.setText("");
        }
    }

    private void updateButtons() {
        I18n i18n = I18n.getInstance();
        this.gamemodeButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.gamemode", i18n.translateNameKey(this.selectedGamemode.getLanguageKey()));
        this.cheatsButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.cheats", i18n.translateKey(this.cheatsEnabled ? "gui.create_world.button.cheats.on" : "gui.create_world.button.cheats.off"));
        this.worldTypeButton.displayString = i18n.translateKeyAndFormat("gui.create_world.button.world_type", i18n.translateNameKey(this.worldTypes.get(this.worldType).getLanguageKey()));
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (i != 14) {
            super.keyTyped(c, i, mouseX, mouseY);
        }
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.textboxKeyTyped(c, i);
        } else if (this.textboxSeed.isFocused) {
            this.textboxSeed.textboxKeyTyped(c, i);
        }
        if (c == '\r') {
            this.buttonPressed((GuiButton)this.controlList.get(0));
        }
        this.updateFolderName();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.textboxWorldName.mouseClicked(mouseX, mouseY, mouseButton);
        this.textboxSeed.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        I18n stringtranslate = I18n.getInstance();
        this.drawDefaultBackground();
        this.drawStringCentered(this.fontRenderer, stringtranslate.translateKey("gui.create_world.label.title"), this.width / 2, 20, 0xFFFFFF);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("gui.create_world.label.world_name"), this.width / 2 - 100, 47, 0xA0A0A0);
        this.drawString(this.fontRenderer, stringtranslate.translateKey("gui.create_world.label.seed"), this.width / 2 - 100, 88, 0xA0A0A0);
        this.textboxWorldName.drawTextBox();
        this.textboxSeed.drawTextBox();
        super.drawScreen(mouseX, mouseY, partialTick);
    }

    @Override
    public void selectNextField() {
        if (this.textboxWorldName.isFocused) {
            this.textboxWorldName.setFocused(false);
            this.textboxSeed.setFocused(true);
        } else {
            this.textboxWorldName.setFocused(true);
            this.textboxSeed.setFocused(false);
        }
    }

    public void runPreset(String name, String seed, int spawnX, int spawnY, int spawnZ) {
        this.overrideSpawnX = spawnX;
        this.overrideSpawnY = spawnY;
        this.overrideSpawnZ = spawnZ;
        this.textboxWorldName.setText(name);
        this.textboxSeed.setText(seed);
        this.updateFolderName();
        this.selectedGamemode = Gamemode.creative;
        this.buttonPressed(this.createWorldButton);
    }
}

