/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiRenderItem;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPageRegistry;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.Tessellator;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiOptions
extends GuiScreen {
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    private static final int SEPARATOR_WIDTH = 8;
    private static final int PADDING = 8;
    private static final int PAGE_BUTTON_HEIGHT = 20;
    public static KeyBinding pickingKeyBinding = null;
    public static KeyBindingComponent pickingKeyBindingComponent = null;
    private float optionsScrollAmount = 0.0f;
    private float pagesListScrollAmount = 0.0f;
    private int top;
    private int bottom;
    private int optionsScrollRegionHeight;
    private int pagesListScrollRegionHeight;
    private int pageWidth;
    private int pagesListWidth;
    private Float oldOptionsScrollAmount;
    private Float oldPagesListScrollAmount;
    private Integer clickX;
    private Integer clickY;
    private OptionsPage selectedPage;
    private OptionsComponent clickedComponent;
    private int clickedComponentY;
    private GuiRenderItem renderItem = null;
    private boolean doOptionsScroll = true;
    private boolean doPagesListScroll = true;

    public GuiOptions(GuiScreen parent) {
        this(parent, OptionsPages.GENERAL);
    }

    public GuiOptions(GuiScreen parent, OptionsPage selectedPage) {
        super(parent);
        this.selectedPage = selectedPage;
    }

    @Override
    public void init() {
        super.init();
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height - 24, 200, 20, I18n.getInstance().translateKey("gui.options.button.done")));
        this.top = 24;
        this.bottom = this.height - 28;
        this.optionsScrollRegionHeight = this.bottom - this.top;
        this.pagesListScrollRegionHeight = this.bottom - this.top;
        this.renderItem = new GuiRenderItem(this.mc);
        this.selectedPage.initComponents(this.mc);
    }

    @Override
    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            if (key == 1) {
                pickingKeyBinding = null;
                pickingKeyBindingComponent = null;
                return;
            }
            pickingKeyBinding.bindKeyboard(key);
            pickingKeyBindingComponent.update();
            pickingKeyBinding = null;
            pickingKeyBindingComponent = null;
            return;
        }
        if (key == 1) {
            this.mc.displayGuiScreen(this.getParentScreen());
        } else {
            for (OptionsComponent component : this.selectedPage.getComponents()) {
                component.onKeyPress(key, c);
            }
        }
    }

    private void drawPageItems(int x, int y, int width, int mouseX, int mouseY) {
        int y2 = y;
        for (OptionsComponent component : this.selectedPage.getComponents()) {
            component.render(x, y2, width, mouseX - x, mouseY - y2);
            y2 += component.getHeight();
        }
    }

    private void drawPagesListItems(int x, int y, int width, int mouseX, int mouseY) {
        int y2 = y;
        for (OptionsPage page : OptionsPageRegistry.getInstance().getPages()) {
            String translated = I18n.getInstance().translateKey(page.getTranslationKey());
            int textColor = -8421505;
            if (page == this.selectedPage) {
                textColor = -1;
            }
            if (mouseX >= x && mouseX < x + width && mouseY >= y2 && mouseY < y2 + 20) {
                textColor = -96;
            }
            this.renderItem.render(page.getIcon(), x, y2 + 10 - 9);
            this.mc.fontRenderer.drawStringWithShadow(translated, x + 19, y2 + 10 - 4, textColor);
            y2 += 20;
        }
    }

    @Override
    public void tick() {
        for (OptionsComponent component : this.selectedPage.getComponents()) {
            component.tick();
        }
    }

    @Override
    protected void buttonPressed(GuiButton guibutton) {
        super.buttonPressed(guibutton);
        if (guibutton.id == 0) {
            this.mc.displayGuiScreen(this.getParentScreen());
        }
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.mc.gameSettings.saveOptions();
    }

    private void scrollOptions(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.optionsScrollAmount += amount;
        this.onScrollOptions();
    }

    private void onScrollOptions() {
        int totalPageHeight = this.getTotalPageHeight();
        if (this.optionsScrollAmount < 0.0f || this.optionsScrollRegionHeight > totalPageHeight) {
            this.optionsScrollAmount = 0.0f;
        } else if (this.optionsScrollAmount > (float)(totalPageHeight - this.optionsScrollRegionHeight)) {
            this.optionsScrollAmount = totalPageHeight - this.optionsScrollRegionHeight;
        }
    }

    private void scrollPagesList(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.pagesListScrollAmount += amount;
        this.onScrollPagesList();
    }

    private void onScrollPagesList() {
        int totalPagesListHeight = this.getTotalPagesListHeight();
        if (this.pagesListScrollAmount < 0.0f || this.pagesListScrollRegionHeight > totalPagesListHeight) {
            this.pagesListScrollAmount = 0.0f;
        } else if (this.pagesListScrollAmount > (float)(totalPagesListHeight - this.pagesListScrollRegionHeight)) {
            this.pagesListScrollAmount = totalPagesListHeight - this.pagesListScrollRegionHeight;
        }
    }

    private int getTotalPageHeight() {
        int totalPageHeight = 0;
        for (OptionsComponent component : this.selectedPage.getComponents()) {
            totalPageHeight += component.getHeight();
        }
        return totalPageHeight;
    }

    private int getTotalPagesListHeight() {
        return 20 * OptionsPageRegistry.getInstance().getPages().size();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float renderPartialTicks) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            mouseX = -1;
            mouseY = -1;
        } else if (this.doOptionsScroll && mouseX > this.pagesListWidth + 8 + 8 && mouseX < this.width) {
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                this.scrollOptions((float)Mouse.getDWheel() * -1.0f);
            } else {
                this.scrollOptions((float)Mouse.getDWheel() / -5.0f);
            }
            this.onScrollOptions();
        } else if (this.doPagesListScroll && mouseX >= 0 && mouseX <= this.pagesListWidth) {
            if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
                this.scrollPagesList((float)Mouse.getDWheel() * -1.0f);
            } else {
                this.scrollPagesList((float)Mouse.getDWheel() / -5.0f);
            }
            this.onScrollPagesList();
        }
        this.pagesListWidth = (int)((float)this.width * 0.25f);
        this.pageWidth = this.width - (this.pagesListWidth + 8 + 16);
        I18n i18n = I18n.getInstance();
        this.drawDefaultBackground();
        this.overlayBackground(0, this.width, 0, this.top);
        this.overlayBackground(0, this.width, this.bottom, this.height);
        Scissor.enable(0, this.top, this.width, this.bottom - this.top);
        if (mouseY >= this.top && mouseY <= this.bottom) {
            this.drawPageItems(this.pagesListWidth + 8 + 8, this.top - (int)this.optionsScrollAmount, this.pageWidth - 8, mouseX, mouseY);
        } else {
            this.drawPageItems(this.pagesListWidth + 8 + 8, this.top - (int)this.optionsScrollAmount, this.pageWidth - 8, -1, -1);
        }
        Scissor.disable();
        Scissor.enable(0, this.top, this.pagesListWidth, this.bottom - this.top);
        int pagesListHeight = this.getTotalPagesListHeight();
        int pagesListY = this.top - (int)this.pagesListScrollAmount;
        if (pagesListHeight < this.bottom - this.top) {
            pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
        }
        if (mouseY >= this.top && mouseY <= this.bottom) {
            this.drawPagesListItems(4, pagesListY, this.pagesListWidth - 8, mouseX, mouseY);
        } else {
            this.drawPagesListItems(4, pagesListY, this.pagesListWidth - 8, -1, -1);
        }
        Scissor.disable();
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            GL11.glDisable((int)2929);
            int shadowSize = 4;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3008);
            GL11.glShadeModel((int)7425);
            GL11.glDisable((int)3553);
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 0);
            tessellator.addVertexWithUV(0.0, this.top + shadowSize, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.top + shadowSize, 0.0, 1.0, 1.0);
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_I(0, 255);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, 1.0, 1.0);
            tessellator.setColorRGBA_I(0, 0);
            tessellator.addVertexWithUV(this.width, this.bottom - shadowSize, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.bottom - shadowSize, 0.0, 0.0, 0.0);
            tessellator.draw();
            GL11.glEnable((int)3553);
            GL11.glShadeModel((int)7424);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)3042);
        }
        this.overlayBackground(this.pagesListWidth, this.pagesListWidth + 8, this.top, this.bottom);
        String titleLanguageKey = "gui.options.title";
        this.drawStringCentered(this.fontRenderer, i18n.translateKey(titleLanguageKey), this.width / 2, 5, 0xFFFFFF);
        this.drawOptionsScrollBar(mouseX, mouseY);
        this.drawPagesListScrollBar(mouseX, mouseY);
        super.drawScreen(mouseX, mouseY, renderPartialTicks);
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            this.drawRect(0, 0, this.width, this.height, -1610612736);
            this.drawStringCenteredNoShadow(this.fontRenderer, i18n.translateKeyAndFormat("gui.options.label.picking_keybinding", i18n.translateKey(pickingKeyBinding.getId())), this.width / 2, this.height / 2 - 4, 0xFFFFFF);
        }
    }

    protected void drawOptionsScrollBar(int mouseX, int mouseY) {
        float totalPageHeight = this.getTotalPageHeight();
        float scrollBarHeightPercent = (float)this.optionsScrollRegionHeight / totalPageHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        GL11.glDisable((int)3553);
        int scrollBarX = this.width - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.optionsScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.optionsScrollAmount / (totalPageHeight - (float)this.optionsScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.optionsScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorOpaque(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.optionsScrollRegionHeight);
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GL11.glEnable((int)3553);
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldOptionsScrollAmount == null) {
                    this.oldOptionsScrollAmount = Float.valueOf(this.optionsScrollAmount);
                }
                this.optionsScrollAmount = this.oldOptionsScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollOptions();
            }
        } else {
            this.oldOptionsScrollAmount = null;
        }
    }

    protected void drawPagesListScrollBar(int mouseX, int mouseY) {
        float totalPagesListHeight = this.getTotalPagesListHeight();
        float scrollBarHeightPercent = (float)this.pagesListScrollRegionHeight / totalPagesListHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        GL11.glDisable((int)3553);
        int scrollBarX = this.pagesListWidth - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.pagesListScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.pagesListScrollAmount / (totalPagesListHeight - (float)this.pagesListScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.pagesListScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.setColorOpaque(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.pagesListScrollRegionHeight);
        t.setColorRGBA_I(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColorRGBA_I(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GL11.glEnable((int)3553);
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldPagesListScrollAmount == null) {
                    this.oldPagesListScrollAmount = Float.valueOf(this.pagesListScrollAmount);
                }
                this.pagesListScrollAmount = this.oldPagesListScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollOptions();
            }
        } else {
            this.oldPagesListScrollAmount = null;
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            pickingKeyBinding.bindMouse(mouseButton);
            pickingKeyBindingComponent.update();
            pickingKeyBinding = null;
            pickingKeyBindingComponent = null;
            return;
        }
        super.mouseClicked(mouseX, mouseY, mouseButton);
        int left = this.pagesListWidth + 8 + 8;
        if (mouseX >= this.pagesListWidth + 8 && mouseY >= this.top && mouseY <= this.bottom) {
            int componentY = this.top - (int)this.optionsScrollAmount;
            for (OptionsComponent component : this.selectedPage.getComponents()) {
                if (mouseX >= left && mouseX <= left + this.pageWidth - 8 && mouseY >= componentY && mouseY <= componentY + component.getHeight()) {
                    component.onMouseClick(mouseButton, left, componentY, this.pageWidth - 8, mouseX - left, mouseY - componentY);
                    this.clickedComponent = component;
                    this.clickedComponentY = componentY;
                    break;
                }
                componentY += component.getHeight();
            }
        } else if (mouseX >= 0 && mouseX <= this.pagesListWidth && mouseY >= this.top && mouseY <= this.bottom) {
            int pagesListHeight = this.getTotalPagesListHeight();
            int pagesListY = this.top - (int)this.pagesListScrollAmount;
            if (pagesListHeight < this.bottom - this.top) {
                pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
            }
            for (OptionsPage page : OptionsPageRegistry.getInstance().getPages()) {
                if (mouseX >= 0 && mouseX <= this.pagesListWidth && mouseY >= pagesListY && mouseY <= pagesListY + 20) {
                    this.optionsScrollAmount = 0.0f;
                    this.selectedPage = page;
                    this.selectedPage.initComponents(this.mc);
                    this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                    break;
                }
                pagesListY += 20;
            }
        }
        this.clickX = mouseX;
        this.clickY = mouseY;
    }

    @Override
    public void mouseMovedOrButtonReleased(int mouseX, int mouseY, int mouseButton) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            return;
        }
        super.mouseMovedOrButtonReleased(mouseX, mouseY, mouseButton);
        int left = this.pagesListWidth + 8 + 8;
        if (mouseY >= this.top && mouseY <= this.bottom && this.clickedComponent != null) {
            if (mouseButton >= 0) {
                this.clickedComponent.onMouseRelease(mouseButton, left, this.clickedComponentY, this.pageWidth, mouseX - left, mouseY - this.clickedComponentY);
                this.clickedComponent = null;
            } else {
                this.clickedComponent.onMouseMove(left, this.clickedComponentY, this.pageWidth, mouseX - left, mouseY - this.clickedComponentY);
            }
        }
        if (mouseButton >= 0) {
            this.clickX = null;
            this.clickY = null;
        }
    }

    @Override
    public void drawDefaultBackground() {
        super.drawDefaultBackground();
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / scale, (float)(this.bottom + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / scale, (float)(this.top + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.pagesListScrollAmount) / scale);
            tessellator.addVertexWithUV(this.pagesListWidth, this.bottom, 0.0, (float)this.pagesListWidth / scale, (float)(this.bottom + (int)this.pagesListScrollAmount) / scale);
            tessellator.addVertexWithUV(this.pagesListWidth, this.top, 0.0, (float)this.pagesListWidth / scale, (float)(this.top + (int)this.pagesListScrollAmount) / scale);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.pagesListScrollAmount) / scale);
            tessellator.draw();
        } else {
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
            this.drawRect(this.pagesListWidth, this.top, this.pagesListWidth + 8, this.bottom, 0x5F000000);
        }
    }

    private void overlayBackground(int minX, int maxX, int minY, int maxY) {
        if (this.mc.theWorld == null) {
            Tessellator tessellator = Tessellator.instance;
            GL11.glBindTexture((int)3553, (int)this.mc.renderEngine.getTexture("/gui/background.png"));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(minX, maxY, 0.0, (float)minX / scale, (float)maxY / scale);
            tessellator.addVertexWithUV(maxX, maxY, 0.0, (float)maxX / scale, (float)maxY / scale);
            tessellator.setColorOpaque_I(0x404040);
            tessellator.addVertexWithUV(maxX, minY, 0.0, (float)maxX / scale, (float)minY / scale);
            tessellator.addVertexWithUV(minX, minY, 0.0, (float)minX / scale, (float)minY / scale);
            tessellator.draw();
        }
    }
}

