/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;

public class ShortcutComponent
implements OptionsComponent {
    private static final Minecraft mc = Minecraft.getMinecraft(ShortcutComponent.class);
    private static final int COMPONENT_SPACING = 2;
    private static final int BUTTON_WIDTH = 200;
    private final String translationKey;
    private final GuiButton button;
    private final Runnable action;

    public ShortcutComponent(String translationKey, Runnable action) {
        this.translationKey = translationKey;
        this.action = action;
        this.button = new GuiButton(0, 0, 0, 200, 20, "");
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public void render(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        this.button.xPosition = x + width / 2 - 100;
        this.button.yPosition = y + 2;
        this.button.displayString = I18n.getInstance().translateKey(this.translationKey);
        this.button.drawButton(mc, x + relativeMouseX, y + relativeMouseY);
    }

    @Override
    public void onMouseClick(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
        if (this.button.mouseClicked(mc, x + relativeMouseX, y + relativeMouseY)) {
            ShortcutComponent.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            this.action.run();
        }
    }

    @Override
    public void onMouseMove(int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onMouseRelease(int mouseButton, int x, int y, int width, int relativeMouseX, int relativeMouseY) {
    }

    @Override
    public void onKeyPress(int keyCode, char character) {
    }

    @Override
    public boolean matchesSearchTerm(String term) {
        return false;
    }
}

