/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.Tessellator;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelRenderBlocks;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import org.lwjgl.opengl.GL11;

public class ChunkRenderer {
    public static final int MAX_RENDER_PASSES = 2;
    public World worldObj;
    private final int glRenderList;
    private static final Tessellator tessellator;
    public static int chunksUpdated;
    public int posX;
    public int posY;
    public int posZ;
    public int sizeWidth;
    public int sizeHeight;
    public int sizeDepth;
    public int posXMinus;
    public int posYMinus;
    public int posZMinus;
    public int posXClip;
    public int posYClip;
    public int posZClip;
    public boolean isInFrustum = false;
    public boolean[] skipRenderPass = new boolean[2];
    public int posXPlus;
    public int posYPlus;
    public int posZPlus;
    public float rendererRadius;
    public boolean needsUpdate;
    public AABB rendererBoundingBox;
    public int chunkIndex;
    public boolean isVisible = true;
    public boolean isWaitingOnOcclusionQuery;
    public int glOcclusionQuery;
    public boolean isChunkLit;
    private boolean isInitialized = false;
    public List<TileEntity> specialTileEntities = new ArrayList<TileEntity>();
    private final List<TileEntity> tileEntities;

    public ChunkRenderer(RenderEngine renderEngine, World world, List<TileEntity> list, int posX, int posY, int posZ, int size, int renderList) {
        this.worldObj = world;
        this.tileEntities = list;
        this.sizeHeight = this.sizeDepth = size;
        this.sizeWidth = this.sizeDepth;
        this.rendererRadius = MathHelper.sqrt_float(this.sizeWidth * this.sizeWidth + this.sizeHeight * this.sizeHeight + this.sizeDepth * this.sizeDepth) / 2.0f;
        this.glRenderList = renderList;
        this.posX = -999;
        this.setPosition(posX, posY, posZ);
        this.needsUpdate = false;
    }

    public void setPosition(int x, int y, int z) {
        if (x != this.posX || y != this.posY || z != this.posZ) {
            this.setDontDraw();
            this.posX = x;
            this.posY = y;
            this.posZ = z;
            this.posXPlus = x + this.sizeWidth / 2;
            this.posYPlus = y + this.sizeHeight / 2;
            this.posZPlus = z + this.sizeDepth / 2;
            this.posXClip = x & 0x3FF;
            this.posYClip = y;
            this.posZClip = z & 0x3FF;
            this.posXMinus = x - this.posXClip;
            this.posYMinus = y - this.posYClip;
            this.posZMinus = z - this.posZClip;
            float f = 6.0f;
            this.rendererBoundingBox = AABB.getBoundingBox((float)x - f, (float)y - f, (float)z - f, (float)(x + this.sizeWidth) + f, (float)(y + this.sizeHeight) + f, (float)(z + this.sizeDepth) + f);
            GL11.glNewList((int)(this.glRenderList + 2), (int)4864);
            ItemEntityRenderer.renderAABB(AABB.getBoundingBoxFromPool((float)this.posXClip - f, (float)this.posYClip - f, (float)this.posZClip - f, (float)(this.posXClip + this.sizeWidth) + f, (float)(this.posYClip + this.sizeHeight) + f, (float)(this.posZClip + this.sizeDepth) + f));
            GL11.glEndList();
            this.markDirty();
        }
    }

    private void setupGLTranslation() {
        GL11.glTranslatef((float)this.posXClip, (float)this.posYClip, (float)this.posZClip);
    }

    public void updateRenderer() {
        if (!this.needsUpdate) {
            return;
        }
        ++chunksUpdated;
        int minX = this.posX;
        int minY = this.posY;
        int minZ = this.posZ;
        int maxX = this.posX + this.sizeWidth;
        int maxY = this.posY + this.sizeHeight;
        int maxZ = this.posZ + this.sizeDepth;
        for (int i = 0; i < 2; ++i) {
            this.skipRenderPass[i] = true;
        }
        Chunk.isLit = false;
        HashSet<TileEntity> lastSpecialTileEntities = new HashSet<TileEntity>(this.specialTileEntities);
        this.specialTileEntities.clear();
        int cacheRadius = 1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, minX - cacheRadius, minY - cacheRadius, minZ - cacheRadius, maxX + cacheRadius, maxY + cacheRadius, maxZ + cacheRadius);
        RenderBlocks renderblocks = new RenderBlocks(this.worldObj, chunkcache);
        BlockModelRenderBlocks.setRenderBlocks(renderblocks);
        for (int renderPass = 0; renderPass < 2; ++renderPass) {
            boolean needsMoreRenderPasses = false;
            boolean hasRenderedBlock = false;
            boolean hasStartedDrawing = false;
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        Block block;
                        int blockRenderPass;
                        TileEntity tileentity;
                        int blockId = chunkcache.getBlockId(x, y, z);
                        if (blockId <= 0) continue;
                        if (!hasStartedDrawing) {
                            hasStartedDrawing = true;
                            GL11.glNewList((int)(this.glRenderList + renderPass), (int)4864);
                            GL11.glPushMatrix();
                            this.setupGLTranslation();
                            float scale = 1.000001f;
                            GL11.glTranslatef((float)((float)(-this.sizeDepth) / 2.0f), (float)((float)(-this.sizeHeight) / 2.0f), (float)((float)(-this.sizeDepth) / 2.0f));
                            GL11.glScalef((float)scale, (float)scale, (float)scale);
                            GL11.glTranslatef((float)((float)this.sizeDepth / 2.0f), (float)((float)this.sizeHeight / 2.0f), (float)((float)this.sizeDepth / 2.0f));
                            tessellator.startDrawingQuads();
                            tessellator.setTranslation(-this.posX, -this.posY, -this.posZ);
                        }
                        if (renderPass == 0 && Block.isEntityTile[blockId] && TileEntityRenderDispatcher.instance.hasRenderer(tileentity = chunkcache.getBlockTileEntity(x, y, z))) {
                            this.specialTileEntities.add(tileentity);
                        }
                        if ((blockRenderPass = (block = Block.blocksList[blockId]).getRenderBlockPass()) != renderPass) {
                            needsMoreRenderPasses = true;
                            continue;
                        }
                        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
                        hasRenderedBlock |= model.render(block, x, y, z);
                        if (!block.hasOverbright) continue;
                        renderblocks.overbright = true;
                        hasRenderedBlock |= model.render(block, x, y, z);
                        renderblocks.overbright = false;
                    }
                }
            }
            if (hasStartedDrawing) {
                tessellator.draw();
                GL11.glPopMatrix();
                GL11.glEndList();
                tessellator.setTranslation(0.0, 0.0, 0.0);
            } else {
                hasRenderedBlock = false;
            }
            if (hasRenderedBlock) {
                this.skipRenderPass[renderPass] = false;
            }
            if (!needsMoreRenderPasses) break;
        }
        HashSet<TileEntity> newSpecialTileEntities = new HashSet<TileEntity>(this.specialTileEntities);
        newSpecialTileEntities.removeAll(lastSpecialTileEntities);
        this.tileEntities.addAll(newSpecialTileEntities);
        this.specialTileEntities.forEach(lastSpecialTileEntities::remove);
        this.tileEntities.removeAll(lastSpecialTileEntities);
        this.isChunkLit = Chunk.isLit;
        this.isInitialized = true;
    }

    public float distanceToEntitySquared(Entity entity) {
        float dx = (float)(entity.x - (double)this.posXPlus);
        float dy = (float)(entity.y - (double)this.posYPlus);
        float dz = (float)(entity.z - (double)this.posZPlus);
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceToCameraSquared(ICamera camera) {
        float dx = (float)(camera.getX(1.0f) - (double)this.posXPlus);
        float dy = (float)(camera.getY(1.0f) - (double)this.posYPlus);
        float dz = (float)(camera.getZ(1.0f) - (double)this.posZPlus);
        return dx * dx + dy * dy + dz * dz;
    }

    public void setDontDraw() {
        for (int i = 0; i < 2; ++i) {
            this.skipRenderPass[i] = true;
        }
        this.isInFrustum = false;
        this.isInitialized = false;
    }

    public void reset() {
        this.setDontDraw();
        this.worldObj = null;
    }

    public int getGLCallListForPass(int i) {
        if (!this.isInFrustum) {
            return -1;
        }
        if (!this.skipRenderPass[i]) {
            return this.glRenderList + i;
        }
        return -1;
    }

    public void updateInFrustum(CameraFrustum frustum, float partialTick) {
        this.isInFrustum = frustum.isVisible(this.rendererBoundingBox, partialTick);
    }

    public void callOcclusionQueryList() {
        GL11.glCallList((int)(this.glRenderList + 2));
    }

    public boolean skipAllRenderPasses() {
        if (!this.isInitialized) {
            return false;
        }
        return this.skipRenderPass[0] && this.skipRenderPass[1];
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    static {
        chunksUpdated = 0;
        tessellator = Tessellator.instance;
    }
}

