/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLeavesBase;
import net.minecraft.core.world.WorldSource;

public final class RenderBlockCache {
    private final Minecraft mc = Minecraft.getMinecraft(this);
    private static final int CACHE_RANGE = 1;
    private static final int CACHE_SIZE = 3;
    private final boolean[] brightnessCached = new boolean[27];
    private final float[] brightnessValue = new float[27];
    private final boolean[] opacityCached = new boolean[27];
    private final boolean[] opacityValue = new boolean[27];
    private int offsetX = Integer.MAX_VALUE;
    private int offsetY = Integer.MAX_VALUE;
    private int offsetZ = Integer.MAX_VALUE;
    private Block block;
    private WorldSource access;

    public void setupCache(Block block, WorldSource access, int x, int y, int z) {
        if (x != this.offsetX || y != this.offsetY || z != this.offsetZ || this.block != block || this.access != access) {
            this.block = block;
            this.access = access;
            Arrays.fill(this.brightnessCached, false);
            Arrays.fill(this.opacityCached, false);
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
        }
    }

    public float getBrightness(int relX, int relY, int relZ) {
        if (this.mc.fullbright && (this.access.getBlock(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ) == null || !this.access.isBlockOpaqueCube(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ))) {
            return 1.0f;
        }
        if (this.mc.isTreeShadingEnabled() && this.mc.isAmbientOcclusionEnabled() && this.access.getBlock(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ) instanceof BlockLeavesBase) {
            float brightness = this.access.getBrightness(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ, Block.lightEmission[this.access.getBlockId(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ)]);
            if (brightness > 0.2f) {
                brightness = 0.2f;
            }
            return brightness;
        }
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.brightnessCached[index]) {
            this.brightnessValue[index] = this.block.getBlockBrightness(this.access, relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ);
            this.brightnessCached[index] = true;
        }
        return this.brightnessValue[index];
    }

    public boolean getOpacity(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.opacityCached[index]) {
            this.opacityValue[index] = Block.solid[this.access.getBlockId(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ)];
            this.opacityCached[index] = true;
        }
        return this.opacityValue[index];
    }
}

