/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.dynamictexture;

import java.awt.image.BufferedImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.dynamictexture.DynamicTexture;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.Global;
import net.minecraft.core.item.Item;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkCoordinates;

public class DynamicTextureCompass
extends DynamicTexture {
    private Minecraft mc;
    private byte[] compassImageData;
    private double angleFinal;
    private double delta;
    private double scaleFactor;

    public DynamicTextureCompass(Minecraft minecraft, int resolution) {
        super(Item.toolCompass.getIconFromDamage(0), resolution, 1);
        this.mc = minecraft;
        BufferedImage compassImage = Textures.readImage(minecraft.texturePackList.selectedTexturePack.getResourceAsStream("/gui/items.png"));
        this.compassImageData = new byte[resolution * resolution * 4];
        int tileX = this.textureIndex % Global.TEXTURE_ATLAS_WIDTH_TILES;
        int tileY = this.textureIndex / Global.TEXTURE_ATLAS_WIDTH_TILES;
        for (int x = 0; x < resolution; ++x) {
            for (int y = 0; y < resolution; ++y) {
                DynamicTextureCompass.putPixel(this.compassImageData, y * resolution + x, compassImage.getRGB(tileX * resolution + x, tileY * resolution + y));
            }
        }
        this.scaleFactor = (double)resolution / 16.0;
    }

    @Override
    public void update() {
        int b2;
        int g2;
        int r2;
        int a;
        int b;
        int g;
        int r;
        int j;
        int y2;
        int x2;
        int i;
        double angleSmooth;
        for (int i2 = 0; i2 < this.resolution * this.resolution; ++i2) {
            int a2 = this.compassImageData[i2 * 4 + 3] & 0xFF;
            int r3 = this.compassImageData[i2 * 4 + 0] & 0xFF;
            int g3 = this.compassImageData[i2 * 4 + 1] & 0xFF;
            int b3 = this.compassImageData[i2 * 4 + 2] & 0xFF;
            if (this.anaglyphEnabled) {
                int var6 = (r3 * 30 + g3 * 59 + b3 * 11) / 100;
                int var7 = (r3 * 30 + g3 * 70) / 100;
                int var8 = (r3 * 30 + b3 * 70) / 100;
                r3 = var6;
                g3 = var7;
                b3 = var8;
            }
            this.imageData[i2 * 4 + 0] = (byte)r3;
            this.imageData[i2 * 4 + 1] = (byte)g3;
            this.imageData[i2 * 4 + 2] = (byte)b3;
            this.imageData[i2 * 4 + 3] = (byte)a2;
        }
        double angle = 0.0;
        if (this.mc.theWorld != null && this.mc.thePlayer != null) {
            ChunkCoordinates var21 = this.mc.theWorld.getSpawnPoint();
            double var23 = (double)var21.x - this.mc.thePlayer.x;
            double var25 = (double)var21.z - this.mc.thePlayer.z;
            angle = (double)(this.mc.thePlayer.yRot - 90.0f) * Math.PI / 180.0 - Math.atan2(var25, var23);
            if (this.mc.theWorld.dimension == Dimension.nether) {
                angle = Math.random() * Math.PI * 2.0;
            }
        }
        for (angleSmooth = angle - this.angleFinal; angleSmooth < -Math.PI; angleSmooth += Math.PI * 2) {
        }
        while (angleSmooth >= Math.PI) {
            angleSmooth -= Math.PI * 2;
        }
        if (angleSmooth < -1.0) {
            angleSmooth = -1.0;
        }
        if (angleSmooth > 1.0) {
            angleSmooth = 1.0;
        }
        this.delta += angleSmooth * 0.1;
        this.delta *= 0.8;
        this.angleFinal += this.delta;
        double x = Math.sin(this.angleFinal);
        double y = Math.cos(this.angleFinal);
        double xs = (double)this.resolution / 2.0 + 0.5;
        double ys = (double)this.resolution / 2.0 - 0.5;
        for (i = (int)(-4.0 * this.scaleFactor); i <= (int)(4.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + y * (double)i * 0.3);
            y2 = (int)(ys - x * (double)i * 0.3 * 0.5);
            j = y2 * this.resolution + x2;
            r = 100;
            g = 100;
            b = 100;
            a = 255;
            if (this.anaglyphEnabled) {
                r2 = (r * 30 + g * 59 + b * 11) / 100;
                g2 = (r * 30 + g * 70) / 100;
                b2 = (r * 30 + b * 70) / 100;
                r = r2;
                g = g2;
                b = b2;
            }
            this.imageData[j * 4 + 0] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
        for (i = (int)(-8.0 * this.scaleFactor); i <= (int)(16.0 * this.scaleFactor); ++i) {
            x2 = (int)(xs + x * (double)i * 0.3);
            y2 = (int)(ys + y * (double)i * 0.3 * 0.5);
            j = y2 * this.resolution + x2;
            r = i >= 0 ? 255 : 100;
            g = i >= 0 ? 20 : 100;
            b = i >= 0 ? 20 : 100;
            a = 255;
            if (this.anaglyphEnabled) {
                r2 = (r * 30 + g * 59 + b * 11) / 100;
                g2 = (r * 30 + g * 70) / 100;
                b2 = (r * 30 + b * 70) / 100;
                r = r2;
                g = g2;
                b = b2;
            }
            this.imageData[j * 4 + 0] = (byte)r;
            this.imageData[j * 4 + 1] = (byte)g;
            this.imageData[j * 4 + 2] = (byte)b;
            this.imageData[j * 4 + 3] = (byte)a;
        }
    }

    @Override
    public String getTextureName() {
        return "/gui/items.png";
    }
}

