/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.List;
import java.util.Random;
import net.minecraft.core.block.BlockRail;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockDetectorRail
extends BlockRail {
    public BlockDetectorRail(String key, int id) {
        super(key, id, true);
        this.setTicking(true);
    }

    @Override
    public int tickRate() {
        return 20;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockMetadata(x, y, z);
        if ((l & 8) == 0) {
            this.setStateIfMinecartInteractsWithRail(world, x, y, z, l);
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if ((meta & 8) != 0) {
            this.setStateIfMinecartInteractsWithRail(world, x, y, z, meta);
        }
    }

    @Override
    public boolean isPoweringTo(WorldSource blockAccess, int x, int y, int z, int side) {
        return (blockAccess.getBlockMetadata(x, y, z) & 8) != 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int x, int y, int z, int side) {
        if ((world.getBlockMetadata(x, y, z) & 8) == 0) {
            return false;
        }
        return side == 1;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int data) {
        return this.atlasIndices[side.getId()];
    }

    private void setStateIfMinecartInteractsWithRail(World world, int x, int y, int z, int meta) {
        boolean isPowered = (meta & 8) != 0;
        boolean isMinecart = false;
        boolean isSlope = (meta & 4) != 0;
        float offset = 0.125f;
        List<Entity> list = world.getEntitiesWithinAABB(EntityMinecart.class, AABB.getBoundingBoxFromPool((float)x + offset, (float)y + offset, (float)z + offset, (float)(x + 1) - offset, (float)(y + 1) - offset, (float)(z + 1) - offset));
        if (!list.isEmpty()) {
            isMinecart = true;
        }
        if (isMinecart && !isPowered) {
            world.setBlockMetadataWithNotify(x, y, z, meta | 8);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.markBlocksDirty(x, y, z, x, y, z);
        }
        if (!isMinecart && isPowered) {
            world.setBlockMetadataWithNotify(x, y, z, meta & 7);
            world.notifyBlocksOfNeighborChange(x, y, z, this.id);
            world.notifyBlocksOfNeighborChange(x, y - 1, z, this.id);
            world.markBlocksDirty(x, y, z, x, y, z);
        }
        if (isMinecart) {
            world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
        }
    }
}

