/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockMoss;
import net.minecraft.core.block.BlockPortal;
import net.minecraft.core.block.BlockTNT;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockFire
extends Block {
    private static final int[] chanceToEncourageFire = new int[Block.blocksList.length];
    private static final int[] abilityToCatchFire = new int[Block.blocksList.length];

    public BlockFire(String key, int id) {
        super(key, id, Material.fire);
        this.setTicking(true);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void initializeBlock() {
        BlockFire.setBurnRate(Block.planksOak.id, 5, 20);
        BlockFire.setBurnRate(Block.planksOakPainted.id, 5, 20);
        BlockFire.setBurnRate(Block.fencePlanksOak.id, 5, 20);
        BlockFire.setBurnRate(Block.fencePlanksOakPainted.id, 5, 20);
        BlockFire.setBurnRate(Block.slabPlanksOak.id, 5, 20);
        BlockFire.setBurnRate(Block.slabPlanksOakPainted.id, 5, 20);
        BlockFire.setBurnRate(Block.stairsPlanksOak.id, 5, 20);
        BlockFire.setBurnRate(Block.logOak.id, 5, 5);
        BlockFire.setBurnRate(Block.logPine.id, 5, 5);
        BlockFire.setBurnRate(Block.logBirch.id, 5, 5);
        BlockFire.setBurnRate(Block.logCherry.id, 5, 5);
        BlockFire.setBurnRate(Block.logOakMossy.id, 5, 5);
        BlockFire.setBurnRate(Block.logEucalyptus.id, 5, 5);
        BlockFire.setBurnRate(Block.leavesOak.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesPine.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesBirch.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesCherry.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesCherryFlowering.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesOakRetro.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesShrub.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesEucalyptus.id, 30, 60);
        BlockFire.setBurnRate(Block.leavesCacao.id, 30, 60);
        BlockFire.setBurnRate(Block.bookshelfPlanksOak.id, 30, 20);
        BlockFire.setBurnRate(Block.tnt.id, 15, 100);
        BlockFire.setBurnRate(Block.wool.id, 30, 60);
        BlockFire.setBurnRate(Block.mossStone.id, 100, 30);
        BlockFire.setBurnRate(Block.mossBasalt.id, 100, 30);
        BlockFire.setBurnRate(Block.mossLimestone.id, 100, 30);
        BlockFire.setBurnRate(Block.mossGranite.id, 100, 30);
    }

    public static void setBurnRate(int id, int chanceToEncourageFire, int abilityToCatchFire) {
        BlockFire.chanceToEncourageFire[id] = chanceToEncourageFire;
        BlockFire.abilityToCatchFire[id] = abilityToCatchFire;
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        for (int i = 0; i < 8; ++i) {
            world.spawnParticle("largesmoke", (double)x + Math.random(), (double)y + 0.5, (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int tickRate() {
        return 40;
    }

    public void setBurnResult(World world, int x, int y, int z) {
        world.setBlockWithNotify(x, y, z, this.getBurnResultId(world, x, y, z));
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        boolean infiniBurn;
        Block blockUnder = world.getBlock(x, y - 1, z);
        boolean bl = infiniBurn = blockUnder != null && blockUnder.hasTag(BlockTags.INFINITE_BURN);
        if (!this.canFirePersist(world, x, y, z)) {
            this.setBurnResult(world, x, y, z);
        }
        if (!infiniBurn && world.getCurrentWeather() != null && world.getCurrentWeather().isPrecipitation && (world.canBlockBeRainedOn(x, y, z) || world.canBlockBeRainedOn(x - 1, y, z) || world.canBlockBeRainedOn(x + 1, y, z) || world.canBlockBeRainedOn(x, y, z - 1) || world.canBlockBeRainedOn(x, y, z + 1))) {
            this.setBurnResult(world, x, y, z);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        if (meta < 15) {
            world.setBlockMetadata(x, y, z, meta + rand.nextInt(3) / 2);
        }
        world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
        if (!infiniBurn && !this.canNeighborCatchFire(world, x, y, z)) {
            if (!world.isBlockNormalCube(x, y - 1, z) || meta > 3) {
                this.setBurnResult(world, x, y, z);
            }
            return;
        }
        if (!infiniBurn && !this.canBlockCatchFire(world, x, y - 1, z) && meta == 15 && rand.nextInt(4) == 0) {
            this.setBurnResult(world, x, y, z);
            return;
        }
        this.tryToCatchBlockOnFire(world, x + 1, y, z, 300, rand, meta);
        this.tryToCatchBlockOnFire(world, x - 1, y, z, 300, rand, meta);
        this.tryToCatchBlockOnFire(world, x, y - 1, z, 250, rand, meta);
        this.tryToCatchBlockOnFire(world, x, y + 1, z, 250, rand, meta);
        this.tryToCatchBlockOnFire(world, x, y, z - 1, 300, rand, meta);
        this.tryToCatchBlockOnFire(world, x, y, z + 1, 300, rand, meta);
        for (int x1 = x - 1; x1 <= x + 1; ++x1) {
            for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                for (int y1 = y - 1; y1 <= y + 4; ++y1) {
                    int c;
                    int b;
                    if (x1 == x && y1 == y && z1 == z) continue;
                    int a = 100;
                    if (y1 > y + 1) {
                        a += (y1 - (y + 1)) * 100;
                    }
                    if ((b = this.getChanceOfNeighborsEncouragingFire(world, x1, y1, z1)) <= 0 || (c = (b + 40) / (meta + 30)) <= 0 || rand.nextInt(a) > c || world.getCurrentWeather() != null && world.getCurrentWeather().isPrecipitation && world.canBlockBeRainedOn(x1, y1, z1) || world.canBlockBeRainedOn(x1 - 1, y1, z) || world.canBlockBeRainedOn(x1 + 1, y1, z1) || world.canBlockBeRainedOn(x1, y1, z1 - 1) || world.canBlockBeRainedOn(x1, y1, z1 + 1) || this.getBurnResultId(world, x1, y1, z1) != 0) continue;
                    world.setBlockAndMetadataWithNotify(x1, y1, z1, this.id, Math.min(meta + rand.nextInt(5) / 4, 15));
                }
            }
        }
    }

    private void tryToCatchBlockOnFire(World world, int x, int y, int z, int chance, Random random, int meta) {
        if (random.nextInt(chance) < abilityToCatchFire[world.getBlockId(x, y, z)]) {
            boolean isTNT;
            boolean bl = isTNT = world.getBlockId(x, y, z) == Block.tnt.id;
            if (random.nextInt(meta + 10) < 5 && !world.canBlockBeRainedOn(x, y, z)) {
                if (this.getBurnResultId(world, x, y, z) == 0) {
                    world.setBlockAndMetadataWithNotify(x, y, z, this.id, Math.min(meta + random.nextInt(5) / 4, 15));
                }
            } else {
                this.setBurnResult(world, x, y, z);
            }
            if (isTNT) {
                BlockTNT blockTNT = (BlockTNT)Block.tnt;
                blockTNT.ignite(world, x, y, z, true);
            }
        }
    }

    private boolean canNeighborCatchFire(World world, int x, int y, int z) {
        if (this.canBlockCatchFire(world, x + 1, y, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x - 1, y, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x, y - 1, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x, y + 1, z)) {
            return true;
        }
        if (this.canBlockCatchFire(world, x, y, z - 1)) {
            return true;
        }
        return this.canBlockCatchFire(world, x, y, z + 1);
    }

    private int getChanceOfNeighborsEncouragingFire(World world, int i, int j, int k) {
        int l = 0;
        if (!world.isAirBlock(i, j, k)) {
            return 0;
        }
        l = this.getChanceToEncourageFire(world, i + 1, j, k, l);
        l = this.getChanceToEncourageFire(world, i - 1, j, k, l);
        l = this.getChanceToEncourageFire(world, i, j - 1, k, l);
        l = this.getChanceToEncourageFire(world, i, j + 1, k, l);
        l = this.getChanceToEncourageFire(world, i, j, k - 1, l);
        l = this.getChanceToEncourageFire(world, i, j, k + 1, l);
        return l;
    }

    public boolean canBlockCatchFire(WorldSource iblockaccess, int i, int j, int k) {
        return chanceToEncourageFire[iblockaccess.getBlockId(i, j, k)] > 0;
    }

    public int getChanceToEncourageFire(World world, int i, int j, int k, int l) {
        int i1 = chanceToEncourageFire[world.getBlockId(i, j, k)];
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    public boolean canFirePersist(World world, int x, int y, int z) {
        return world.isBlockNormalCube(x, y - 1, z) || this.canNeighborCatchFire(world, x, y, z);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return this.canFirePersist(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!world.isBlockNormalCube(x, y - 1, z) && !this.canNeighborCatchFire(world, x, y, z)) {
            world.setBlockWithNotify(x, y, z, this.getBurnResultId(world, x, y, z));
        }
    }

    protected int getBurnResultId(World world, int x, int y, int z) {
        int id = world.getBlockId(x, y, z);
        Block stoneBlock = BlockMoss.getStoneBlock(id);
        if (stoneBlock != null) {
            return stoneBlock.id;
        }
        return 0;
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        if (world.getBlockId(x, y - 1, z) == Block.obsidian.id && ((BlockPortal)Block.portalNether).tryToCreatePortal(world, x, y, z)) {
            return;
        }
        if (!world.isBlockNormalCube(x, y - 1, z) && !this.canNeighborCatchFire(world, x, y, z)) {
            world.setBlockWithNotify(x, y, z, this.getBurnResultId(world, x, y, z));
        } else {
            world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
        }
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        block12: {
            block11: {
                if (rand.nextInt(24) == 0) {
                    world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, "fire.fire", 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f);
                }
                if (!world.isBlockNormalCube(x, y - 1, z) && !((BlockFire)Block.fire).canBlockCatchFire(world, x, y - 1, z)) break block11;
                for (int l = 0; l < 3; ++l) {
                    double f = (double)x + (double)rand.nextFloat();
                    double f6 = (double)y + (double)(rand.nextFloat() * 0.5f) + 0.5;
                    double f12 = (double)z + (double)rand.nextFloat();
                    world.spawnParticle("largesmoke", f, f6, f12, 0.0, 0.0, 0.0);
                }
                break block12;
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, x - 1, y, z)) {
                for (int i1 = 0; i1 < 2; ++i1) {
                    double f1 = (double)x + (double)(rand.nextFloat() * 0.1f);
                    double f7 = (double)y + (double)rand.nextFloat();
                    double f13 = (double)z + (double)rand.nextFloat();
                    world.spawnParticle("largesmoke", f1, f7, f13, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, x + 1, y, z)) {
                for (int j1 = 0; j1 < 2; ++j1) {
                    double f2 = (double)(x + 1) - (double)(rand.nextFloat() * 0.1f);
                    double f8 = (double)y + (double)rand.nextFloat();
                    double f14 = (double)z + (double)rand.nextFloat();
                    world.spawnParticle("largesmoke", f2, f8, f14, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, x, y, z - 1)) {
                for (int k1 = 0; k1 < 2; ++k1) {
                    double f3 = (double)x + (double)rand.nextFloat();
                    double f9 = (double)y + (double)rand.nextFloat();
                    double f15 = (double)z + (double)(rand.nextFloat() * 0.1f);
                    world.spawnParticle("largesmoke", f3, f9, f15, 0.0, 0.0, 0.0);
                }
            }
            if (((BlockFire)Block.fire).canBlockCatchFire(world, x, y, z + 1)) {
                for (int l1 = 0; l1 < 2; ++l1) {
                    double f4 = (double)x + (double)rand.nextFloat();
                    double f10 = (double)y + (double)rand.nextFloat();
                    double f16 = (double)(z + 1) - (double)(rand.nextFloat() * 0.1f);
                    world.spawnParticle("largesmoke", f4, f10, f16, 0.0, 0.0, 0.0);
                }
            }
            if (!((BlockFire)Block.fire).canBlockCatchFire(world, x, y + 1, z)) break block12;
            for (int i2 = 0; i2 < 2; ++i2) {
                double f5 = (double)x + (double)rand.nextFloat();
                double f11 = (double)(y + 1) - (double)(rand.nextFloat() * 0.1f);
                double f17 = (double)z + (double)rand.nextFloat();
                world.spawnParticle("largesmoke", f5, f11, f17, 0.0, 0.0, 0.0);
            }
        }
    }
}

