/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockSlab;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockSlabPainted
extends BlockSlab {
    public static final int[] texCoords = new int[16];
    public static int TEX_COORD_OFFSET = 3;

    public BlockSlabPainted(Block modelBlock, int id) {
        super(modelBlock, id);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(Side side, int meta) {
        return texCoords[(meta >>= 4) & 0xF];
    }

    @Override
    public int getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return this.getBlockTextureFromSideAndMetadata(side, blockAccess.getBlockMetadata(x, y, z));
    }

    public static int getMetadataForColour(int i) {
        return ~i << 4 & 0xF0;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        int meta = entity.getVerticalPlacementDirection(side, sideHeight) == Direction.UP ? 2 : 0;
        world.setBlockMetadataWithNotify(x, y, z, meta | world.getBlockMetadata(x, y, z) & 0xF0);
    }

    static {
        BlockSlabPainted.texCoords[0] = Block.texCoordToIndex(31, 30);
        for (int i = 1; i < 16; ++i) {
            BlockSlabPainted.texCoords[i] = texCoords[0] - (i % 4 * (Global.TEXTURE_ATLAS_WIDTH_TILES * TEX_COORD_OFFSET) + i / 4 * TEX_COORD_OFFSET);
        }
    }
}

