/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.ListTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet140TileEntityData;
import net.minecraft.core.player.inventory.IInventory;

public class TileEntityFlag
extends TileEntity
implements IInventory {
    public final int CANVAS_WIDTH = 24;
    public final int CANVAS_HEIGHT = 16;
    public final byte[] flagColors = new byte[384];
    public ItemStack[] items = new ItemStack[3];
    public String owner = "";

    public byte getColor(int x, int y) {
        int colorIndex;
        int xSample = x;
        int ySample = y;
        if (x < 0) {
            xSample = 0;
        }
        if (x >= 24) {
            xSample = 23;
        }
        if (y < 0) {
            ySample = 0;
        }
        if (y >= 16) {
            ySample = 15;
        }
        if ((colorIndex = this.flagColors[xSample + 24 * ySample] - 1) < 0 || colorIndex >= this.items.length) {
            return 15;
        }
        if (this.items[colorIndex] != null && this.items[colorIndex].itemID == Item.dye.id) {
            return (byte)(this.items[colorIndex].getMetadata() & 0xF);
        }
        return 15;
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        this.writeFlagNBT(tag);
    }

    public void writeFlagNBT(CompoundTag tag) {
        byte[] packedColors = this.packFlagColors(this.flagColors);
        tag.putByteArray("Colors", packedColors);
        tag.putString("Owner", this.owner);
        ListTag list = new ListTag();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            CompoundTag compound = new CompoundTag();
            compound.putByte("Slot", (byte)i);
            this.items[i].writeToNBT(compound);
            list.addTag(compound);
        }
        tag.putList("Items", list);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.readFlagNBT(tag);
    }

    public void readFlagNBT(CompoundTag tag) {
        byte[] packedColors = tag.getByteArrayOrDefault("Colors", null);
        if (packedColors == null) {
            packedColors = new byte[96];
        }
        byte[] unpackedColors = this.unpackFlagColors(packedColors);
        System.arraycopy(unpackedColors, 0, this.flagColors, 0, 384);
        this.owner = tag.getStringOrDefault("Owner", "");
        ListTag list = tag.getList("Items");
        this.items = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < list.tagCount(); ++i) {
            CompoundTag compound = (CompoundTag)list.tagAt(i);
            byte slot = compound.getByte("Slot");
            if (slot >= this.items.length || slot <= -1) continue;
            this.items[slot] = ItemStack.readItemStackFromNbt(compound);
        }
    }

    public void copyFlagNBT(CompoundTag tag) {
        byte[] packedColors = this.packFlagColors(this.flagColors);
        String copyOwner = tag.getStringOrDefault("Owner", "");
        if (copyOwner.isEmpty()) {
            tag.putString("Owner", this.owner);
        }
        tag.putByteArray("Colors", packedColors);
    }

    private byte[] packFlagColors(byte[] unpacked) {
        byte[] packed = new byte[96];
        for (int i = 0; i < 96; ++i) {
            packed[i] = 0;
            int n = i;
            packed[n] = (byte)(packed[n] | (unpacked[i * 4 + 0] & 3) << 0);
            int n2 = i;
            packed[n2] = (byte)(packed[n2] | (unpacked[i * 4 + 1] & 3) << 2);
            int n3 = i;
            packed[n3] = (byte)(packed[n3] | (unpacked[i * 4 + 2] & 3) << 4);
            int n4 = i;
            packed[n4] = (byte)(packed[n4] | (unpacked[i * 4 + 3] & 3) << 6);
        }
        return packed;
    }

    private byte[] unpackFlagColors(byte[] packed) {
        byte[] unpacked = new byte[384];
        for (int i = 0; i < 96; ++i) {
            unpacked[i * 4 + 0] = (byte)((packed[i] & 3) >> 0);
            unpacked[i * 4 + 1] = (byte)((packed[i] & 0xC) >> 2);
            unpacked[i * 4 + 2] = (byte)((packed[i] & 0x30) >> 4);
            unpacked[i * 4 + 3] = (byte)((packed[i] & 0xC0) >> 6);
        }
        return unpacked;
    }

    @Override
    public int getSizeInventory() {
        return 3;
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        if ((i -= 36) < 0 || i >= 3) {
            return null;
        }
        return this.items[i];
    }

    @Override
    public ItemStack decrStackSize(int index, int numToTake) {
        if (this.items[index -= 36] != null) {
            if (this.items[index].stackSize <= numToTake) {
                ItemStack stack = this.items[index];
                this.items[index] = null;
                this.onInventoryChanged();
                return stack;
            }
            ItemStack splitStack = this.items[index].splitStack(numToTake);
            if (this.items[index].stackSize <= 0) {
                this.items[index] = null;
            }
            this.onInventoryChanged();
            return splitStack;
        }
        return null;
    }

    @Override
    public Packet getDescriptionPacket() {
        return new Packet140TileEntityData(this);
    }

    @Override
    public void setInventorySlotContents(int index, ItemStack stack) {
        this.items[index -= 36] = stack;
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return "Flag";
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return entityplayer.distanceToSqr((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) <= 64.0;
    }

    @Override
    public void sortInventory() {
    }
}

