/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.CompoundTag;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFallingSand;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightningBolt;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.entity.EntityTNT;
import net.minecraft.core.entity.animal.EntityChicken;
import net.minecraft.core.entity.animal.EntityCow;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.animal.EntityPig;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.entity.animal.EntitySquid;
import net.minecraft.core.entity.animal.EntityWolf;
import net.minecraft.core.entity.monster.EntityArmoredZombie;
import net.minecraft.core.entity.monster.EntityCreeper;
import net.minecraft.core.entity.monster.EntityGhast;
import net.minecraft.core.entity.monster.EntityGiant;
import net.minecraft.core.entity.monster.EntityHuman;
import net.minecraft.core.entity.monster.EntityPigZombie;
import net.minecraft.core.entity.monster.EntityScorpion;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.monster.EntitySlime;
import net.minecraft.core.entity.monster.EntitySnowman;
import net.minecraft.core.entity.monster.EntitySpider;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityArrowGolden;
import net.minecraft.core.entity.projectile.EntityArrowPurple;
import net.minecraft.core.entity.projectile.EntityCannonball;
import net.minecraft.core.entity.projectile.EntityFireball;
import net.minecraft.core.entity.projectile.EntityPebble;
import net.minecraft.core.entity.projectile.EntitySnowball;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.entity.vehicle.EntityMinecart;
import net.minecraft.core.world.World;

public class EntityDispatcher {
    public static final Map<String, Class<? extends Entity>> keyToClassMap = new HashMap<String, Class<? extends Entity>>();
    public static final Map<Class<? extends Entity>, String> classToKeyMap = new HashMap<Class<? extends Entity>, String>();
    private static final Map<Integer, Class<? extends Entity>> idToClassMap = new HashMap<Integer, Class<? extends Entity>>();
    private static final Map<Class<? extends Entity>, Integer> classToIdMap = new HashMap<Class<? extends Entity>, Integer>();

    public static void addMapping(Class<? extends Entity> clazz, String key, int id) {
        keyToClassMap.put(key, clazz);
        classToKeyMap.put(clazz, key);
        idToClassMap.put(id, clazz);
        classToIdMap.put(clazz, id);
    }

    public static Entity createEntityInWorld(String s, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> entityClass = keyToClassMap.get(s);
            if (entityClass != null) {
                entity = entityClass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(CompoundTag nbttagcompound, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> class1 = keyToClassMap.get(nbttagcompound.getString("id"));
            if (class1 != null) {
                entity = class1.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            entity.load(nbttagcompound);
        } else {
            System.out.println("Skipping Entity with id " + nbttagcompound.getString("id"));
        }
        return entity;
    }

    public static Entity createEntity(int i, World world) {
        Entity entity = null;
        try {
            Class<? extends Entity> class1 = idToClassMap.get(i);
            if (class1 != null) {
                entity = class1.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            System.out.println("Skipping Entity with id " + i);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        return EntityDispatcher.getEntityID(entity.getClass());
    }

    public static int getEntityID(Class<? extends Entity> entityClass) {
        return classToIdMap.get(entityClass);
    }

    public static String getEntityString(Entity entity) {
        return classToKeyMap.get(entity.getClass());
    }

    static {
        EntityDispatcher.addMapping(EntityItem.class, "Item", 1);
        EntityDispatcher.addMapping(EntityLightningBolt.class, "Lightning", 8);
        EntityDispatcher.addMapping(EntityPainting.class, "Painting", 9);
        EntityDispatcher.addMapping(EntityArrow.class, "Arrow", 10);
        EntityDispatcher.addMapping(EntitySnowball.class, "Snowball", 11);
        EntityDispatcher.addMapping(EntityFireball.class, "Fireball", 12);
        EntityDispatcher.addMapping(EntityTNT.class, "PrimedTnt", 20);
        EntityDispatcher.addMapping(EntityFallingSand.class, "FallingSand", 21);
        EntityDispatcher.addMapping(EntityMinecart.class, "Minecart", 40);
        EntityDispatcher.addMapping(EntityBoat.class, "Boat", 41);
        EntityDispatcher.addMapping(EntityArmoredZombie.class, "ArmouredZombie", 42);
        EntityDispatcher.addMapping(EntityArrowGolden.class, "ArrowGolden", 43);
        EntityDispatcher.addMapping(EntityCannonball.class, "Cannonball", 44);
        EntityDispatcher.addMapping(EntityArrowPurple.class, "ArrowPurple", 45);
        EntityDispatcher.addMapping(EntityPebble.class, "Pebble", 46);
        EntityDispatcher.addMapping(EntityFireflyCluster.class, "FireflyCluster", 47);
        EntityDispatcher.addMapping(EntityLiving.class, "Mob", 48);
        EntityDispatcher.addMapping(EntityHuman.class, "Monster", 49);
        EntityDispatcher.addMapping(EntityCreeper.class, "Creeper", 50);
        EntityDispatcher.addMapping(EntitySkeleton.class, "Skeleton", 51);
        EntityDispatcher.addMapping(EntitySpider.class, "Spider", 52);
        EntityDispatcher.addMapping(EntityGiant.class, "Giant", 53);
        EntityDispatcher.addMapping(EntityZombie.class, "Zombie", 54);
        EntityDispatcher.addMapping(EntitySlime.class, "Slime", 55);
        EntityDispatcher.addMapping(EntityGhast.class, "Ghast", 56);
        EntityDispatcher.addMapping(EntityPigZombie.class, "PigZombie", 57);
        EntityDispatcher.addMapping(EntitySnowman.class, "Snowman", 58);
        EntityDispatcher.addMapping(EntityScorpion.class, "Scorpion", 59);
        EntityDispatcher.addMapping(EntityPig.class, "Pig", 90);
        EntityDispatcher.addMapping(EntitySheep.class, "Sheep", 91);
        EntityDispatcher.addMapping(EntityCow.class, "Cow", 92);
        EntityDispatcher.addMapping(EntityChicken.class, "Chicken", 93);
        EntityDispatcher.addMapping(EntitySquid.class, "Squid", 94);
        EntityDispatcher.addMapping(EntityWolf.class, "Wolf", 95);
    }
}

