/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import net.minecraft.core.lang.Language;
import net.minecraft.core.lang.LanguageSeeker;

public class I18n {
    private static I18n INSTANCE;
    private Language currentLanguage;

    public static void initialize(String languageCode) {
        INSTANCE = new I18n(languageCode);
    }

    private I18n(String languageCode) {
        if (!LanguageSeeker.LANGUAGE_DIR.exists()) {
            LanguageSeeker.LANGUAGE_DIR.mkdirs();
        }
        this.reload(languageCode);
    }

    public void reload(String languageCode) {
        this.reload(languageCode, false);
    }

    public void reload(String languageCode, boolean save) {
        if (this.currentLanguage != null) {
            this.currentLanguage.onReload();
        }
        try {
            this.currentLanguage = LanguageSeeker.seek(languageCode);
        }
        catch (IOException e) {
            this.currentLanguage = Language.Default.INSTANCE;
        }
        System.out.println(this.currentLanguage.keySize() + " Translation Keys");
    }

    public static I18n getInstance() {
        return INSTANCE;
    }

    public String translateKey(String s) {
        return this.currentLanguage.translateKey(s);
    }

    public String translateKeyAndFormat(String formatKey, Object ... args) {
        return this.currentLanguage.translateKeyAndFormat(formatKey, args);
    }

    public String translateNameKey(String s) {
        return this.translateKey(s + ".name");
    }

    public String translateDescKey(String s) {
        return this.translateKey(s + ".desc");
    }

    public Language getCurrentLanguage() {
        return this.currentLanguage;
    }

    public static InputStream getResourceAsStream(String path) {
        return I18n.class.getResourceAsStream(path);
    }

    public static String[] getFilesInDirectory(String directory) {
        ArrayList<String> paths = new ArrayList<String>();
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        try {
            Path myPath;
            URI uri = I18n.class.getResource(directory).toURI();
            FileSystem fileSystem = null;
            if (uri.getScheme().equals("jar")) {
                try {
                    fileSystem = FileSystems.getFileSystem(uri);
                }
                catch (Exception e) {
                    fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
                }
                myPath = fileSystem.getPath(directory, new String[0]);
            } else {
                myPath = Paths.get(uri);
            }
            try (Stream<Path> walk = Files.walk(myPath, 1, new FileVisitOption[0]);){
                Iterator it = walk.iterator();
                it.next();
                while (it.hasNext()) {
                    paths.add(directory + ((Path)it.next()).getFileName().toString());
                }
            }
            if (fileSystem != null) {
                fileSystem.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paths.toArray(new String[0]);
    }
}

