/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature.tree;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.generate.feature.tree.WorldFeatureTree;

public class WorldFeatureTreeFancy
extends WorldFeature {
    protected int leavesID;
    protected int logID;
    static final byte[] dimensionLookup = new byte[]{2, 0, 0, 1, 2, 1};
    Random treeRand;
    World worldObj;
    int[] basePos = new int[]{0, 0, 0};
    int height = 0;
    int trunkHeight;
    double trunkHeightScale = 0.6;
    double field_875_h = 1.0;
    double field_874_i = 0.4;
    double field_873_j = 1.0;
    double field_872_k = 1.0;
    int trunkThickness = 1;
    int trunkHeightVariance = 12;
    int leavesHeight = 4;
    int[][] branchPoints;
    int heightMod;

    public WorldFeatureTreeFancy(int leavesID, int logID) {
        this(leavesID, logID, 0);
    }

    public WorldFeatureTreeFancy(int leavesID, int logID, int heightMod) {
        this.treeRand = new Random();
        this.leavesID = leavesID;
        this.logID = logID;
        this.heightMod = heightMod;
    }

    void generateBranchPoints() {
        int numBranchPoints;
        this.trunkHeight = (int)((double)this.height * this.trunkHeightScale);
        if (this.trunkHeight >= this.height) {
            this.trunkHeight = this.height - 1;
        }
        if ((numBranchPoints = (int)(1.4 + Math.pow(this.field_872_k * (double)this.height / 13.0, 2.0))) < 1) {
            numBranchPoints = 1;
        }
        int[][] branchPoints = new int[numBranchPoints * this.height][4];
        int highestBranchY = this.basePos[1] + this.height - this.leavesHeight;
        int branchIndex = 1;
        int trunkTop = this.basePos[1] + this.trunkHeight;
        int dy = highestBranchY - this.basePos[1];
        branchPoints[0][0] = this.basePos[0];
        branchPoints[0][1] = highestBranchY--;
        branchPoints[0][2] = this.basePos[2];
        branchPoints[0][3] = trunkTop;
        while (dy >= 0) {
            float f = this.func_528_a(dy);
            if (f < 0.0f) {
                --highestBranchY;
                --dy;
                continue;
            }
            double d = 0.5;
            for (int j1 = 0; j1 < numBranchPoints; ++j1) {
                int[] branchTopOfTree;
                int branchZ;
                double branchAngle;
                double branchRadius = this.field_873_j * ((double)f * ((double)this.treeRand.nextFloat() + 0.328));
                int branchX = MathHelper.floor_double(branchRadius * Math.sin(branchAngle = (double)this.treeRand.nextFloat() * 2.0 * Math.PI) + (double)this.basePos[0] + d);
                int[] branchEnd = new int[]{branchX, highestBranchY, branchZ = MathHelper.floor_double(branchRadius * Math.cos(branchAngle) + (double)this.basePos[2] + d)};
                if (this.drawLineAndStopIfInterrupted(branchEnd, branchTopOfTree = new int[]{branchX, highestBranchY + this.leavesHeight, branchZ}) != -1) continue;
                int[] branchStart = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
                double branchLength = Math.sqrt(Math.pow(Math.abs(this.basePos[0] - branchEnd[0]), 2.0) + Math.pow(Math.abs(this.basePos[2] - branchEnd[2]), 2.0));
                double d4 = branchLength * this.field_874_i;
                branchStart[1] = (double)branchEnd[1] - d4 > (double)trunkTop ? trunkTop : (int)((double)branchEnd[1] - d4);
                if (this.drawLineAndStopIfInterrupted(branchStart, branchEnd) != -1) continue;
                branchPoints[branchIndex][0] = branchX;
                branchPoints[branchIndex][1] = highestBranchY;
                branchPoints[branchIndex][2] = branchZ;
                branchPoints[branchIndex][3] = branchStart[1];
                ++branchIndex;
            }
            --highestBranchY;
            --dy;
        }
        this.branchPoints = new int[branchIndex][4];
        System.arraycopy(branchPoints, 0, this.branchPoints, 0, branchIndex);
    }

    void placeLeafCircle(int x, int y, int z, float radius, int blockId) {
        int radiusBlocks = (int)((double)radius + 0.6);
        int[] centrePos = new int[]{x, y, z};
        int[] lookupPos = new int[]{0, 0, 0};
        lookupPos[1] = centrePos[1];
        for (int dx = -radiusBlocks; dx <= radiusBlocks; ++dx) {
            lookupPos[0] = centrePos[0] + dx;
            for (int dz = -radiusBlocks; dz <= radiusBlocks; ++dz) {
                int idAtBlock;
                lookupPos[2] = centrePos[2] + dz;
                double distance = Math.sqrt(Math.pow((double)Math.abs(dx) + 0.5, 2.0) + Math.pow((double)Math.abs(dz) + 0.5, 2.0));
                if (!(distance <= (double)radius) || (idAtBlock = this.worldObj.getBlockId(lookupPos[0], lookupPos[1], lookupPos[2])) != 0 && idAtBlock != this.leavesID) continue;
                this.worldObj.setBlockWithNotify(lookupPos[0], lookupPos[1], lookupPos[2], blockId);
            }
        }
    }

    float func_528_a(int i) {
        if ((double)i < (double)this.height * 0.3) {
            return -1.618f;
        }
        float f = (float)this.height / 2.0f;
        float f1 = (float)this.height / 2.0f - (float)i;
        float f2 = f1 == 0.0f ? f : (Math.abs(f1) >= f ? 0.0f : (float)Math.sqrt(Math.pow(Math.abs(f), 2.0) - Math.pow(Math.abs(f1), 2.0)));
        return f2 *= 0.5f;
    }

    float getLeavesRadius(int y) {
        if (y < 0 || y >= this.leavesHeight) {
            return -1.0f;
        }
        if (y == 0 || y == this.leavesHeight - 1) {
            return 2.0f;
        }
        return 3.0f;
    }

    void placeLeafSphere(int x, int y, int z) {
        for (int leavesY = y; leavesY < y + this.leavesHeight; ++leavesY) {
            float leavesRadius = this.getLeavesRadius(leavesY - y);
            this.placeLeafCircle(x, leavesY, z, leavesRadius, this.leavesID);
        }
    }

    void placeLeavesAtPoints() {
        for (int[] branchPoint : this.branchPoints) {
            int x = branchPoint[0];
            int y = branchPoint[1];
            int z = branchPoint[2];
            this.placeLeafSphere(x, y, z);
        }
    }

    void placeBranch(int[] startPos, int[] endPos, int blockId) {
        int[] dimensions = new int[]{0, 0, 0};
        int dim0 = 0;
        for (int i = 0; i < 3; ++i) {
            dimensions[i] = endPos[i] - startPos[i];
            if (Math.abs(dimensions[i]) <= Math.abs(dimensions[dim0])) continue;
            dim0 = i;
        }
        if (dimensions[dim0] == 0) {
            return;
        }
        byte dim1 = dimensionLookup[dim0];
        byte dim2 = dimensionLookup[dim0 + 3];
        int delta = dimensions[dim0] > 0 ? 1 : -1;
        double dim1DeltaScale = (double)dimensions[dim1] / (double)dimensions[dim0];
        double dim2DeltaScale = (double)dimensions[dim2] / (double)dimensions[dim0];
        for (int i = 0; i != dimensions[dim0] + delta; i += delta) {
            int[] pos = new int[]{0, 0, 0};
            pos[dim0] = MathHelper.floor_double((double)startPos[dim0] + (double)i + 0.5);
            pos[dim1] = MathHelper.floor_double((double)startPos[dim1] + (double)i * dim1DeltaScale + 0.5);
            pos[dim2] = MathHelper.floor_double((double)startPos[dim2] + (double)i * dim2DeltaScale + 0.5);
            this.worldObj.setBlockWithNotify(pos[0], pos[1], pos[2], blockId);
        }
    }

    boolean isHighEnoughToBranch(int i) {
        return (double)i >= (double)this.height * 0.2;
    }

    void generateTrunk() {
        int x = this.basePos[0];
        int minY = this.basePos[1];
        int maxY = this.basePos[1] + this.trunkHeight;
        int z = this.basePos[2];
        int[] startPos = new int[]{x, minY, z};
        int[] endPos = new int[]{x, maxY, z};
        this.placeBranch(startPos, endPos, this.logID);
        if (this.trunkThickness == 2) {
            startPos[0] = startPos[0] + 1;
            endPos[0] = endPos[0] + 1;
            this.placeBranch(startPos, endPos, this.logID);
            startPos[2] = startPos[2] + 1;
            endPos[2] = endPos[2] + 1;
            this.placeBranch(startPos, endPos, this.logID);
            startPos[0] = startPos[0] - 1;
            endPos[0] = endPos[0] - 1;
            this.placeBranch(startPos, endPos, this.logID);
        }
    }

    void generateBranches() {
        int[] startPos = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        for (int[] branchPoint : this.branchPoints) {
            int[] endPos = new int[]{branchPoint[0], branchPoint[1], branchPoint[2]};
            startPos[1] = branchPoint[3];
            int dy = startPos[1] - this.basePos[1];
            if (!this.isHighEnoughToBranch(dy)) continue;
            this.placeBranch(startPos, endPos, this.logID);
        }
    }

    int drawLineAndStopIfInterrupted(int[] startPos, int[] endPos) {
        int linePos;
        int[] dimensions = new int[]{0, 0, 0};
        int dim0 = 0;
        for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
            dimensions[i] = endPos[i] - startPos[i];
            if (Math.abs(dimensions[i]) <= Math.abs(dimensions[dim0])) continue;
            dim0 = i;
        }
        if (dimensions[dim0] == 0) {
            return -1;
        }
        byte dim1 = dimensionLookup[dim0];
        byte dim2 = dimensionLookup[dim0 + 3];
        int delta = dimensions[dim0] > 0 ? 1 : -1;
        double dim1DeltaScale = (double)dimensions[dim1] / (double)dimensions[dim0];
        double dim2DeltaScale = (double)dimensions[dim2] / (double)dimensions[dim0];
        int lineLength = dimensions[dim0] + delta;
        for (linePos = 0; linePos != lineLength; linePos += delta) {
            int[] pos = new int[]{0, 0, 0};
            pos[dim0] = startPos[dim0] + linePos;
            pos[dim1] = MathHelper.floor_double((double)startPos[dim1] + (double)linePos * dim1DeltaScale);
            pos[dim2] = MathHelper.floor_double((double)startPos[dim2] + (double)linePos * dim2DeltaScale);
            int idAtPos = this.worldObj.getBlockId(pos[0], pos[1], pos[2]);
            if (idAtPos != 0 && idAtPos != this.leavesID) break;
        }
        if (linePos == lineLength) {
            return -1;
        }
        return Math.abs(linePos);
    }

    boolean canGenerateTree() {
        int[] bottomPos = new int[]{this.basePos[0], this.basePos[1], this.basePos[2]};
        int[] topPos = new int[]{this.basePos[0], this.basePos[1] + this.height - 1, this.basePos[2]};
        int blockIdUnderneath = this.worldObj.getBlockId(this.basePos[0], this.basePos[1] - 1, this.basePos[2]);
        if (!Block.hasTag(blockIdUnderneath, BlockTags.GROWS_TREES)) {
            return false;
        }
        int interruptedTrunkHeight = this.drawLineAndStopIfInterrupted(bottomPos, topPos);
        if (interruptedTrunkHeight == -1) {
            return true;
        }
        if (interruptedTrunkHeight < 6) {
            return false;
        }
        this.height = interruptedTrunkHeight;
        return true;
    }

    @Override
    public void func_517_a(double d, double d1, double d2) {
        this.trunkHeightVariance = (int)(d * (12.0 + (double)this.heightMod));
        if (d > 0.5) {
            this.leavesHeight = 5;
        }
        this.field_873_j = d1;
        this.field_872_k = d2;
    }

    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        this.worldObj = world;
        long seed = random.nextLong();
        this.treeRand.setSeed(seed);
        this.basePos[0] = x;
        this.basePos[1] = y;
        this.basePos[2] = z;
        if (this.height == 0) {
            this.height = 5 + this.treeRand.nextInt(this.trunkHeightVariance);
        }
        if (this.canGenerateTree()) {
            WorldFeatureTree.onTreeGrown(this.worldObj, this.basePos[0], this.basePos[1], this.basePos[2]);
            this.generateBranchPoints();
            this.placeLeavesAtPoints();
            this.generateTrunk();
            this.generateBranches();
            return true;
        }
        return false;
    }
}

