/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManager;

public abstract class WorldType {
    private final String languageKey;
    private final Weather defaultWeather;
    private final WindManager windManager;
    private final boolean hasCeiling;
    private final float[] brightnessRamp;
    private final SeasonConfig defaultSeasonConfig;

    public WorldType(String languageKey, Weather defaultWeather, WindManager windManager, boolean hasCeiling, float[] brightnessRamp, SeasonConfig defaultSeasonConfig) {
        this.languageKey = languageKey;
        this.defaultWeather = defaultWeather;
        this.windManager = windManager;
        this.hasCeiling = hasCeiling;
        this.brightnessRamp = brightnessRamp;
        this.defaultSeasonConfig = defaultSeasonConfig;
    }

    public void onWorldCreation(World world) {
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public Weather getDefaultWeather() {
        return this.defaultWeather;
    }

    public WindManager getWindManager() {
        return this.windManager;
    }

    public boolean hasCeiling() {
        return this.hasCeiling;
    }

    public float[] getBrightnessRamp() {
        return this.brightnessRamp;
    }

    public SeasonConfig getDefaultSeasonConfig() {
        return this.defaultSeasonConfig;
    }

    public abstract int getMinY();

    public abstract int getMaxY();

    public final int getYRange() {
        return this.getMaxY() - this.getMinY();
    }

    public final double getYPercentage(int y) {
        int range = this.getYRange();
        return (double)(y -= this.getMinY()) / (double)range;
    }

    public abstract int getOceanY();

    public abstract int getOceanBlock();

    public abstract int getFillerBlock();

    public abstract BiomeProvider createBiomeProvider(World var1);

    public abstract ChunkGenerator createChunkGenerator(World var1);

    public abstract boolean isValidSpawn(World var1, int var2, int var3, int var4);

    public void getInitialSpawnLocation(World world) {
        int x = 0;
        int y = 0;
        int z = 0;
        block0: while (true) {
            x += world.rand.nextInt(64) - world.rand.nextInt(64);
            z += world.rand.nextInt(64) - world.rand.nextInt(64);
            y = this.getMaxY();
            while (true) {
                if (y < this.getMinY()) continue block0;
                if (world.getBlockId(x, y + 1, z) == 0 && this.isValidSpawn(world, x, y, z)) break block0;
                --y;
            }
            break;
        }
        world.getLevelData().setSpawn(x, y, z);
    }

    public void getRespawnLocation(World world) {
        LevelData levelData = world.getLevelData();
        if (levelData.getSpawnY() <= 0) {
            levelData.setSpawnY(this.getOceanY());
        }
        int x = levelData.getSpawnX();
        int z = levelData.getSpawnZ();
        while (world.getTopBlock(x, z) == 0) {
            x += world.rand.nextInt(8) - world.rand.nextInt(8);
            z += world.rand.nextInt(8) - world.rand.nextInt(8);
        }
        levelData.setSpawnX(x);
        levelData.setSpawnZ(z);
    }

    public abstract int getDayNightCycleLengthTicks();

    protected int getDayLengthTicks(World world) {
        float dayLength;
        float seasonProgress = world.seasonManager.getSeasonProgress();
        if (seasonProgress < 0.5f) {
            float lastSeasonDayLength = world.seasonManager.getPreviousSeason().dayLength;
            float thisSeasonDayLength = world.seasonManager.getCurrentSeason().dayLength;
            float seasonModifier = world.seasonManager.getSeasonModifier() * 0.5f + 0.5f;
            dayLength = lastSeasonDayLength * (1.0f - seasonModifier) + thisSeasonDayLength * seasonModifier;
        } else {
            float thisSeasonDayLength = world.seasonManager.getCurrentSeason().dayLength;
            float nextSeasonDayLength = world.seasonManager.getNextSeason().dayLength;
            float seasonModifier = world.seasonManager.getSeasonModifier() * 0.5f + 0.5f;
            dayLength = thisSeasonDayLength * seasonModifier + nextSeasonDayLength * (1.0f - seasonModifier);
        }
        int cycleTicks = this.getDayNightCycleLengthTicks();
        return (int)(dayLength * (float)cycleTicks);
    }

    public int getSunriseTick(World world) {
        int dayLengthTicks = this.getDayLengthTicks(world);
        int cycleTicks = this.getDayNightCycleLengthTicks();
        return cycleTicks / 4 - dayLengthTicks / 2;
    }

    public float getTimeOfDay(World world, long tick, float partialTick) {
        float time;
        int cycleTicks = this.getDayNightCycleLengthTicks();
        int dayTicks = this.getDayLengthTicks(world);
        int nightTicks = cycleTicks - dayTicks;
        for (time = (cycleTick = (float)((int)((tick += 18000L) % (long)cycleTicks)) + partialTick) < (float)dayTicks / 2.0f ? cycleTick / ((float)dayTicks / 2.0f) * 0.25f : (cycleTick < (float)dayTicks / 2.0f + (float)nightTicks / 2.0f ? 0.25f + (cycleTick - (float)dayTicks / 2.0f) / ((float)nightTicks / 2.0f) * 0.25f : (cycleTick < (float)dayTicks / 2.0f + (float)nightTicks / 2.0f + (float)nightTicks / 2.0f ? 0.5f + (cycleTick - (float)dayTicks / 2.0f - (float)nightTicks / 2.0f) / ((float)nightTicks / 2.0f) * 0.25f : 0.75f + (cycleTick - (float)dayTicks / 2.0f - (float)nightTicks / 2.0f - (float)nightTicks / 2.0f) / ((float)dayTicks / 2.0f) * 0.25f)); time < 0.0f; time += 1.0f) {
        }
        while (time >= 1.0f) {
            time -= 1.0f;
        }
        return time;
    }

    public abstract float getCelestialAngle(World var1, long var2, float var4);

    public abstract float[] getSunriseColor(float var1, float var2);

    public abstract int getSkyDarken(World var1, long var2, float var4);

    public abstract Vec3d getFogColor(float var1, float var2);

    public abstract boolean mayRespawn();

    public abstract float getCloudHeight();

    public abstract boolean hasGround();

    public boolean hasAurora() {
        return false;
    }
}

