/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.block.Block;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.Vec3d;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.paradise.ChunkGeneratorParadise;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManager;

public abstract class WorldTypeParadise
extends WorldType {
    public WorldTypeParadise(String languageKey, Weather defaultWeather, WindManager windManager, SeasonConfig defaultSeasonConfig) {
        super(languageKey, defaultWeather, windManager, false, WorldTypeParadise.createLightRamp(), defaultSeasonConfig);
    }

    private static float[] createLightRamp() {
        float[] brightnessRamp = new float[32];
        float f = 0.05f;
        for (int i = 0; i <= 31; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            if (i > 15) {
                f1 = 0.0f;
            }
            brightnessRamp[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return brightnessRamp;
    }

    @Override
    public void onWorldCreation(World world) {
        super.onWorldCreation(world);
        world.setWorldTime(576000L);
    }

    @Override
    public int getOceanY() {
        return 0;
    }

    @Override
    public int getOceanBlock() {
        return 0;
    }

    @Override
    public int getFillerBlock() {
        return Block.marble.id;
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.PARADISE_PARADISE, 0.5, 0.0, 0.0);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorParadise(world);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public int getDayNightCycleLengthTicks() {
        return 1344000;
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        float dayProgress = this.getTimeOfDay(world, tick, partialTick);
        float f2 = dayProgress -= 0.25f;
        dayProgress = 1.0f - (float)((Math.cos((double)dayProgress * Math.PI) + 1.0) / 2.0);
        dayProgress = f2 + (dayProgress - f2) / 3.0f;
        return dayProgress;
    }

    @Override
    public float[] getSunriseColor(float timeOfDay, float partialTick) {
        float f4;
        float[] sunriseCol = new float[4];
        float f2 = 0.4f;
        float f3 = MathHelper.cos(timeOfDay * 3.141593f * 2.0f) - 0.0f;
        if (f3 >= (f4 = -0.0f) - f2 && f3 <= f4 + f2) {
            float c = (f3 - f4) / f2 * 0.5f + 0.5f;
            float a = 1.0f - (1.0f - MathHelper.sin(c * 3.141593f)) * 0.99f;
            a *= a;
            sunriseCol[0] = c * 0.3f + 0.7f;
            sunriseCol[1] = c * c * 0.7f + 0.2f;
            sunriseCol[2] = c * c * 0.0f + 0.2f;
            sunriseCol[3] = a;
            return sunriseCol;
        }
        return null;
    }

    @Override
    public int getSkyDarken(World world, long tick, float partialTick) {
        int subtracted;
        float f1 = this.getCelestialAngle(world, tick, partialTick);
        float f2 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float weatherOffset = 0.0f;
        if (world.getCurrentWeather() != null) {
            weatherOffset = (float)world.getCurrentWeather().subtractLightLevel * world.weatherManager.getWeatherIntensity() * world.weatherManager.getWeatherPower();
        }
        if ((subtracted = (int)(f2 * (11.0f - weatherOffset) + weatherOffset)) > 8) {
            subtracted = 8;
        }
        return subtracted;
    }

    @Override
    public Vec3d getFogColor(float timeOfDay, float partialTick) {
        int i = 0x8080A0;
        float f2 = MathHelper.cos(timeOfDay * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(i >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(i & 0xFF) / 255.0f;
        return Vec3d.createVector(f3 *= f2 * 0.94f + 0.06f, f4 *= f2 * 0.94f + 0.06f, f5 *= f2 * 0.91f + 0.09f);
    }

    @Override
    public boolean mayRespawn() {
        return false;
    }

    @Override
    public float getCloudHeight() {
        return 8.0f;
    }

    @Override
    public boolean hasGround() {
        return false;
    }
}

