/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.CompoundTag;
import com.mojang.nbt.Tag;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NbtIo {
    public static CompoundTag readCompressed(InputStream inputStream) throws IOException {
        try (DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(inputStream));){
            CompoundTag compoundTag = NbtIo.read(datainputstream);
            return compoundTag;
        }
    }

    public static void writeCompressed(CompoundTag tag, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(outputStream));){
            NbtIo.write(tag, dataoutputstream);
        }
    }

    public static CompoundTag read(DataInput dataInput) throws IOException {
        Tag<?> tag = Tag.readNamedTag(dataInput);
        if (tag instanceof CompoundTag) {
            return (CompoundTag)tag;
        }
        throw new IOException("Root tag must be a named compound tag!");
    }

    public static void write(CompoundTag tag, DataOutput dataOutput) throws IOException {
        Tag.writeNamedTag(tag, dataOutput);
    }
}

