/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.client.render.item.model.ItemModel;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatItem;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.item.Item;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiStats
extends GuiScreen {
    private static ItemEntityRenderer itemEntityRenderer = new ItemEntityRenderer();
    protected GuiScreen screen;
    protected String title = I18n.getInstance().translateKey("gui.statistics.label.title");
    private GeneralStatisticsList generalStatisticsList;
    private ItemStatisticsList itemStatisticsList;
    private BlockStatisticsList blockStatisticsList;
    private StatsCounter statsCounter;
    private ScrolledSelectionList selectionList = null;

    public GuiStats(GuiScreen guiscreen, StatsCounter statfilewriter) {
        this.screen = guiscreen;
        this.statsCounter = statfilewriter;
    }

    @Override
    public void init() {
        this.generalStatisticsList = new GeneralStatisticsList();
        this.itemStatisticsList = new ItemStatisticsList();
        this.blockStatisticsList = new BlockStatisticsList();
        this.selectionList = this.generalStatisticsList;
        this.createButtons();
    }

    public void createButtons() {
        I18n i18n = I18n.getInstance();
        this.controlList.add(new GuiButton(0, this.width / 2 + 4, this.height - 28, 150, 20, i18n.translateKey("gui.statistics.button.done")));
        this.controlList.add(new GuiButton(1, this.width / 2 - 154, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.general")));
        GuiButton guibutton = new GuiButton(2, this.width / 2 - 46, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.blocks"));
        this.controlList.add(guibutton);
        GuiButton guibutton1 = new GuiButton(3, this.width / 2 + 62, this.height - 52, 100, 20, i18n.translateKey("gui.statistics.button.items"));
        this.controlList.add(guibutton1);
        if (this.blockStatisticsList.getItemCount() == 0) {
            guibutton.enabled = false;
        }
        if (this.itemStatisticsList.getItemCount() == 0) {
            guibutton1.enabled = false;
        }
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.mc.displayGuiScreen(this.screen);
        } else if (button.id == 1) {
            this.selectionList = this.generalStatisticsList;
        } else if (button.id == 3) {
            this.selectionList = this.itemStatisticsList;
        } else if (button.id == 2) {
            this.selectionList = this.blockStatisticsList;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.selectionList.render(mouseX, mouseY, partialTick);
        this.drawStringCentered(this.fontRenderer, this.title, this.width / 2, 20, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, partialTick);
    }

    private void func_27138_c(int i, int j, int k) {
        this.func_27147_a(i + 1, j + 1);
        GL11.glEnable((int)32826);
        Lighting.enableInventoryLight();
        Item item = Item.itemsList[k];
        ((ItemModel)ItemModelDispatcher.getInstance().getDispatch(item)).renderItemIntoGui(Tessellator.instance, this.fontRenderer, this.mc.renderEngine, item.getDefaultStack(), i + 2, j + 2, 1.0f);
        Lighting.disable();
        GL11.glDisable((int)32826);
    }

    private void func_27147_a(int i, int j) {
        this.func_27136_c(i, j, 0, 0);
    }

    private void func_27136_c(int i, int j, int k, int l) {
        int i1 = this.mc.renderEngine.getTexture("/assets/minecraft/textures/gui/slot.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.bindTexture(i1);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(i + 0, j + 18, this.zLevel, (float)(k + 0) * 0.0078125f, (float)(l + 18) * 0.0078125f);
        tessellator.addVertexWithUV(i + 18, j + 18, this.zLevel, (float)(k + 18) * 0.0078125f, (float)(l + 18) * 0.0078125f);
        tessellator.addVertexWithUV(i + 18, j + 0, this.zLevel, (float)(k + 18) * 0.0078125f, (float)(l + 0) * 0.0078125f);
        tessellator.addVertexWithUV(i + 0, j + 0, this.zLevel, (float)(k + 0) * 0.0078125f, (float)(l + 0) * 0.0078125f);
        tessellator.draw();
    }

    static Minecraft func_27141_a(GuiStats guistats) {
        return guistats.mc;
    }

    static FontRenderer func_27145_b(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    public static StatsCounter func_27142_c(GuiStats guistats) {
        return guistats.statsCounter;
    }

    static FontRenderer func_27140_d(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static FontRenderer func_27146_e(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static Minecraft func_27143_f(GuiStats guistats) {
        return guistats.mc;
    }

    static void func_27128_a(GuiStats guistats, int i, int j, int k, int l) {
        guistats.func_27136_c(i, j, k, l);
    }

    static Minecraft func_27149_g(GuiStats guistats) {
        return guistats.mc;
    }

    static FontRenderer func_27133_h(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static FontRenderer func_27137_i(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static FontRenderer func_27132_j(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static FontRenderer func_27134_k(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static FontRenderer func_27139_l(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static void func_27129_a(GuiStats guistats, int i, int j, int k, int l, int i1, int j1) {
        guistats.drawGradientRect(i, j, k, l, i1, j1);
    }

    static FontRenderer func_27144_m(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static FontRenderer func_27127_n(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static void func_27135_b(GuiStats guistats, int i, int j, int k, int l, int i1, int j1) {
        guistats.drawGradientRect(i, j, k, l, i1, j1);
    }

    static FontRenderer func_27131_o(GuiStats guistats) {
        return guistats.fontRenderer;
    }

    static void func_27148_a(GuiStats guistats, int i, int j, int k) {
        guistats.func_27138_c(i, j, k);
    }

    public class BlockStatisticsList
    extends StatsSelectionList {
        public BlockStatisticsList() {
            this.field_27273_c = new ArrayList();
            for (StatItem statItem : StatList.statList3) {
                boolean flag = false;
                int i = statItem.getItemID();
                if (GuiStats.this.statsCounter.readStat(statItem) > 0) {
                    flag = true;
                } else if (StatList.usedItemStats[i] != null && GuiStats.this.statsCounter.readStat(StatList.usedItemStats[i]) > 0) {
                    flag = true;
                } else if (StatList.craftedItemStats[i] != null && GuiStats.this.statsCounter.readStat(StatList.craftedItemStats[i]) > 0) {
                    flag = true;
                }
                if (!flag) continue;
                this.field_27273_c.add(statItem);
            }
            this.field_27272_d = (si1, si2) -> {
                int i = si1.getItemID();
                int j = si2.getItemID();
                Stat statbase = null;
                Stat statbase1 = null;
                if (this.field_27271_e == 2) {
                    statbase = StatList.mineBlockStatArray[i];
                    statbase1 = StatList.mineBlockStatArray[j];
                } else if (this.field_27271_e == 0) {
                    statbase = StatList.craftedItemStats[i];
                    statbase1 = StatList.craftedItemStats[j];
                } else if (this.field_27271_e == 1) {
                    statbase = StatList.usedItemStats[i];
                    statbase1 = StatList.usedItemStats[j];
                }
                if (statbase != null || statbase1 != null) {
                    int l;
                    if (statbase == null) {
                        return 1;
                    }
                    if (statbase1 == null) {
                        return -1;
                    }
                    int k = GuiStats.this.statsCounter.readStat(statbase);
                    if (k != (l = GuiStats.this.statsCounter.readStat(statbase1))) {
                        return (k - l) * this.field_27270_f;
                    }
                }
                return i - j;
            };
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            super.renderHeader(x, y, tessellator);
            if (this.field_27268_b == 0) {
                GuiStats.this.func_27136_c(x + 115 - 18 + 1, y + 1 + 1, 18, 18);
            } else {
                GuiStats.this.func_27136_c(x + 115 - 18, y + 1, 18, 18);
            }
            if (this.field_27268_b == 1) {
                GuiStats.this.func_27136_c(x + 165 - 18 + 1, y + 1 + 1, 36, 18);
            } else {
                GuiStats.this.func_27136_c(x + 165 - 18, y + 1, 36, 18);
            }
            if (this.field_27268_b == 2) {
                GuiStats.this.func_27136_c(x + 215 - 18 + 1, y + 1 + 1, 54, 18);
            } else {
                GuiStats.this.func_27136_c(x + 215 - 18, y + 1, 54, 18);
            }
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            StatItem statcrafting = this.func_27264_b(index);
            int i1 = statcrafting.getItemID();
            GuiStats.this.func_27138_c(x + 40, y, i1);
            this.func_27265_a((StatItem)StatList.craftedItemStats[i1], x + 115, y, index % 2 == 0);
            this.func_27265_a((StatItem)StatList.usedItemStats[i1], x + 165, y, index % 2 == 0);
            this.func_27265_a(statcrafting, x + 215, y, index % 2 == 0);
        }

        @Override
        protected String func_27263_a(int i) {
            if (i == 0) {
                return "stat.crafted";
            }
            if (i == 1) {
                return "stat.used";
            }
            return "stat.mined";
        }
    }

    public class ItemStatisticsList
    extends StatsSelectionList {
        public ItemStatisticsList() {
            this.field_27273_c = new ArrayList();
            for (StatItem statItem : StatList.usedItemStatsList) {
                boolean flag = false;
                int i = statItem.getItemID();
                if (GuiStats.this.statsCounter.readStat(statItem) > 0) {
                    flag = true;
                } else if (StatList.breakItemStats[i] != null && GuiStats.this.statsCounter.readStat(StatList.breakItemStats[i]) > 0) {
                    flag = true;
                } else if (StatList.craftedItemStats[i] != null && GuiStats.this.statsCounter.readStat(StatList.craftedItemStats[i]) > 0) {
                    flag = true;
                }
                if (!flag) continue;
                this.field_27273_c.add(statItem);
            }
            this.field_27272_d = (si1, si2) -> {
                int i = si1.getItemID();
                int j = si2.getItemID();
                Stat statbase = null;
                Stat statbase1 = null;
                if (this.field_27271_e == 0) {
                    statbase = StatList.breakItemStats[i];
                    statbase1 = StatList.breakItemStats[j];
                } else if (this.field_27271_e == 1) {
                    statbase = StatList.craftedItemStats[i];
                    statbase1 = StatList.craftedItemStats[j];
                } else if (this.field_27271_e == 2) {
                    statbase = StatList.usedItemStats[i];
                    statbase1 = StatList.usedItemStats[j];
                }
                if (statbase != null || statbase1 != null) {
                    int l;
                    if (statbase == null) {
                        return 1;
                    }
                    if (statbase1 == null) {
                        return -1;
                    }
                    int k = GuiStats.this.statsCounter.readStat(statbase);
                    if (k != (l = GuiStats.this.statsCounter.readStat(statbase1))) {
                        return (k - l) * this.field_27270_f;
                    }
                }
                return i - j;
            };
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            super.renderHeader(x, y, tessellator);
            if (this.field_27268_b == 0) {
                GuiStats.this.func_27136_c(x + 115 - 18 + 1, y + 1 + 1, 72, 18);
            } else {
                GuiStats.this.func_27136_c(x + 115 - 18, y + 1, 72, 18);
            }
            if (this.field_27268_b == 1) {
                GuiStats.this.func_27136_c(x + 165 - 18 + 1, y + 1 + 1, 18, 18);
            } else {
                GuiStats.this.func_27136_c(x + 165 - 18, y + 1, 18, 18);
            }
            if (this.field_27268_b == 2) {
                GuiStats.this.func_27136_c(x + 215 - 18 + 1, y + 1 + 1, 36, 18);
            } else {
                GuiStats.this.func_27136_c(x + 215 - 18, y + 1, 36, 18);
            }
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            StatItem statcrafting = this.func_27264_b(index);
            int i1 = statcrafting.getItemID();
            GuiStats.this.func_27138_c(x + 40, y, i1);
            this.func_27265_a((StatItem)StatList.breakItemStats[i1], x + 115, y, index % 2 == 0);
            this.func_27265_a((StatItem)StatList.craftedItemStats[i1], x + 165, y, index % 2 == 0);
            this.func_27265_a(statcrafting, x + 215, y, index % 2 == 0);
        }

        @Override
        protected String func_27263_a(int i) {
            if (i == 1) {
                return "stat.crafted";
            }
            if (i == 2) {
                return "stat.used";
            }
            return "stat.depleted";
        }
    }

    class GeneralStatisticsList
    extends ScrolledSelectionList {
        public GeneralStatisticsList() {
            super(GuiStats.this.mc, GuiStats.this.width, GuiStats.this.height, 32, GuiStats.this.height - 64, 10);
            this.setRenderSelection(false);
        }

        @Override
        protected int getItemCount() {
            return StatList.statList2.size();
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return false;
        }

        @Override
        protected int getMaxPosition() {
            return this.getItemCount() * 10;
        }

        @Override
        protected void renderHoleBackground() {
            GuiStats.this.drawDefaultBackground();
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            Stat statbase = StatList.statList2.get(index);
            GuiStats.this.drawString(GuiStats.this.fontRenderer, statbase.getStatName(), x + 2, y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
            String s = statbase.makeString(GuiStats.this.statsCounter.readStat(statbase));
            GuiStats.this.drawString(GuiStats.this.fontRenderer, s, x + 2 + 213 - GuiStats.this.fontRenderer.getStringWidth(s), y + 1, index % 2 != 0 ? 0x909090 : 0xFFFFFF);
        }
    }

    abstract class StatsSelectionList
    extends ScrolledSelectionList {
        protected int field_27268_b;
        protected List field_27273_c;
        protected Comparator<StatItem> field_27272_d;
        public int field_27271_e;
        public int field_27270_f;

        protected StatsSelectionList() {
            super(GuiStats.this.mc, GuiStats.this.width, GuiStats.this.height, 32, GuiStats.this.height - 64, 20);
            this.field_27268_b = -1;
            this.field_27271_e = -1;
            this.field_27270_f = 0;
            this.setRenderSelection(false);
            this.setRenderHeader(true, 20);
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return false;
        }

        @Override
        protected void renderHoleBackground() {
            GuiStats.this.drawDefaultBackground();
        }

        @Override
        protected void renderHeader(int x, int y, Tessellator tessellator) {
            if (!Mouse.isButtonDown((int)0)) {
                this.field_27268_b = -1;
            }
            if (this.field_27268_b == 0) {
                GuiStats.this.func_27136_c(x + 115 - 18, y + 1, 0, 0);
            } else {
                GuiStats.this.func_27136_c(x + 115 - 18, y + 1, 0, 18);
            }
            if (this.field_27268_b == 1) {
                GuiStats.this.func_27136_c(x + 165 - 18, y + 1, 0, 0);
            } else {
                GuiStats.this.func_27136_c(x + 165 - 18, y + 1, 0, 18);
            }
            if (this.field_27268_b == 2) {
                GuiStats.this.func_27136_c(x + 215 - 18, y + 1, 0, 0);
            } else {
                GuiStats.this.func_27136_c(x + 215 - 18, y + 1, 0, 18);
            }
            if (this.field_27271_e != -1) {
                int c = 79;
                int byte0 = 18;
                if (this.field_27271_e == 1) {
                    c = 129;
                } else if (this.field_27271_e == 2) {
                    c = 179;
                }
                if (this.field_27270_f == 1) {
                    byte0 = 36;
                }
                GuiStats.this.func_27136_c(x + c, y + 1, byte0, 0);
            }
        }

        @Override
        protected void clickedHeader(int x, int y) {
            this.field_27268_b = -1;
            if (x >= 79 && x < 115) {
                this.field_27268_b = 0;
            } else if (x >= 129 && x < 165) {
                this.field_27268_b = 1;
            } else if (x >= 179 && x < 215) {
                this.field_27268_b = 2;
            }
            if (this.field_27268_b >= 0) {
                this.func_27266_c(this.field_27268_b);
                GuiStats.this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
            }
        }

        @Override
        protected final int getItemCount() {
            return this.field_27273_c.size();
        }

        protected final StatItem func_27264_b(int i) {
            return (StatItem)this.field_27273_c.get(i);
        }

        protected abstract String func_27263_a(int var1);

        protected void func_27265_a(StatItem statcrafting, int i, int j, boolean flag) {
            if (statcrafting != null) {
                String s = statcrafting.makeString(GuiStats.this.statsCounter.readStat(statcrafting));
                GuiStats.this.drawString(GuiStats.this.fontRenderer, s, i - GuiStats.this.fontRenderer.getStringWidth(s), j + 5, flag ? 0xFFFFFF : 0x909090);
            } else {
                String s1 = "-";
                GuiStats.this.drawString(GuiStats.this.fontRenderer, s1, i - GuiStats.this.fontRenderer.getStringWidth(s1), j + 5, flag ? 0xFFFFFF : 0x909090);
            }
        }

        @Override
        protected void renderDecorations(int x, int y) {
            if (y < this.y0 || y > this.y1) {
                return;
            }
            int k = this.getItemAtPosition(x, y);
            int l = GuiStats.this.width / 2 - 92 - 16;
            if (k >= 0) {
                if (x < l + 40 || x > l + 40 + 20) {
                    return;
                }
                StatItem statcrafting = this.func_27264_b(k);
                this.func_27267_a(statcrafting, x, y);
            } else {
                String s = "";
                if (x >= l + 115 - 18 && x <= l + 115) {
                    s = this.func_27263_a(0);
                } else if (x >= l + 165 - 18 && x <= l + 165) {
                    s = this.func_27263_a(1);
                } else if (x >= l + 215 - 18 && x <= l + 215) {
                    s = this.func_27263_a(2);
                } else {
                    return;
                }
                s = ("" + I18n.getInstance().translateKey(s)).trim();
                if (s.length() > 0) {
                    int i1 = x + 12;
                    int j1 = y - 12;
                    int k1 = GuiStats.this.fontRenderer.getStringWidth(s);
                    GuiStats.this.drawGradientRect(i1 - 3, j1 - 3, i1 + k1 + 3, j1 + 8 + 3, -1073741824, -1073741824);
                    GuiStats.this.fontRenderer.drawStringWithShadow(s, i1, j1, -1);
                }
            }
        }

        protected void func_27267_a(StatItem statcrafting, int i, int j) {
            if (statcrafting == null) {
                return;
            }
            Item item = Item.itemsList[statcrafting.getItemID()];
            String s = ("" + I18n.getInstance().translateNameKey(item.getKey())).trim();
            if (s.length() > 0) {
                int k = i + 12;
                int l = j - 12;
                int i1 = GuiStats.this.fontRenderer.getStringWidth(s);
                GuiStats.this.drawGradientRect(k - 3, l - 3, k + i1 + 3, l + 8 + 3, -1073741824, -1073741824);
                GuiStats.this.fontRenderer.drawStringWithShadow(s, k, l, -1);
            }
        }

        protected void func_27266_c(int i) {
            if (i != this.field_27271_e) {
                this.field_27271_e = i;
                this.field_27270_f = -1;
            } else if (this.field_27270_f == -1) {
                this.field_27270_f = 1;
            } else {
                this.field_27271_e = -1;
                this.field_27270_f = 0;
            }
            Collections.sort(this.field_27273_c, this.field_27272_d);
        }
    }
}

