/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTooltip;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.SearchableGuidebookSection;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.gui.guidebook.search.SearchSection;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGuidebook
extends GuiScreen {
    private static final int TABS_PER_SIDE = 8;
    private static PageManager pageManager = null;
    public static boolean allowArrowKeyNavigation = true;
    private final int xSize = 316;
    private final int ySize = 220;
    private final GuiTooltip tooltip = new GuiTooltip(Minecraft.getMinecraft(this));
    private Tab[] tabs = new Tab[16];

    public static PageManager getPageManager() {
        GuidebookSections.init();
        if (pageManager == null) {
            pageManager = new PageManager();
        }
        return pageManager;
    }

    public GuiGuidebook() {
        GuiGuidebook.getPageManager();
    }

    @Override
    public void init() {
        super.init();
        this.initTabList();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private void initTabList() {
        this.tabs = new Tab[16];
        List<GuidebookSection> sections = GuidebookSections.getSectionList();
        int numTabs = sections.size();
        for (int i = 0; i < this.tabs.length && i < numTabs; ++i) {
            this.tabs[i] = new Tab(sections.get(i));
        }
        this.updateTabList();
    }

    private void updateTabList() {
        List<GuidebookPage> pages;
        List<GuidebookPage> search;
        int i;
        boolean hasLeftPage = pageManager.getLeftPage() != null;
        boolean hasRightPage = pageManager.getRightPage() != null;
        int left = this.width / 2 - 316 / (hasLeftPage && hasRightPage ? 2 : 4);
        int right = this.width / 2 + 316 / (hasLeftPage && hasRightPage ? 2 : 4);
        int top = this.height / 2 - 110;
        List<GuidebookSection> sections = GuidebookSections.getSectionList();
        int numTabs = sections.size();
        for (i = 0; i < 8 && i < numTabs; ++i) {
            this.tabs[i].setX(left - 36);
            this.tabs[i].setY(top + i * 26 + 7);
            this.tabs[i].setFlipped(false);
            if (sections.get(i) instanceof SearchableGuidebookSection && PageManager.searchQuery != null) {
                search = ((SearchableGuidebookSection)sections.get(i)).searchPages(PageManager.searchQuery);
                if (search.size() > 0) {
                    this.tabs[i].setActive(search.get(0) == pageManager.getLeftPage() || search.get(0) == pageManager.getRightPage());
                    continue;
                }
                this.tabs[i].setActive(false);
                continue;
            }
            pages = sections.get(i).getPages();
            if (pages.size() > 0) {
                this.tabs[i].setActive(pages.get(0) == pageManager.getLeftPage() || pages.get(0) == pageManager.getRightPage());
                continue;
            }
            this.tabs[i].setActive(false);
        }
        for (i = 8; i < 16 && i < numTabs; ++i) {
            this.tabs[i].setX(right);
            this.tabs[i].setY(top + (i - 8) * 26 + 7);
            this.tabs[i].setFlipped(true);
            if (sections.get(i).getPages().size() <= 0) continue;
            if (sections.get(i) instanceof SearchableGuidebookSection && PageManager.searchQuery != null) {
                search = ((SearchableGuidebookSection)sections.get(i)).searchPages(PageManager.searchQuery);
                if (search.size() > 0) {
                    this.tabs[i].setActive(search.get(0) == pageManager.getLeftPage() || search.get(0) == pageManager.getRightPage());
                    continue;
                }
                this.tabs[i].setActive(false);
                continue;
            }
            pages = sections.get(i).getPages();
            if (pages.size() > 0) {
                this.tabs[i].setActive(pages.get(0) == pageManager.getLeftPage() || pages.get(0) == pageManager.getRightPage());
                continue;
            }
            this.tabs[i].setActive(false);
        }
    }

    @Override
    public boolean pausesGame() {
        return false;
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float renderPartialTicks) {
        this.scroll(Mouse.getDWheel());
        int xOffset = 0;
        if (pageManager.getLeftPage() == null) {
            xOffset = -79;
        }
        if (pageManager.getRightPage() == null) {
            xOffset = 79;
        }
        this.drawDefaultBackground();
        this.drawTabs(mouseX, mouseY);
        this.drawCurrentPages(mouseX, mouseY, xOffset, renderPartialTicks);
        this.drawHeaders(xOffset);
        this.drawCurrentPageOverlays(mouseX, mouseY, xOffset, renderPartialTicks);
        this.drawPageTurnIndicator(mouseX, mouseY, xOffset);
        this.drawTooltip(mouseX, mouseY);
    }

    private void scroll(int direction) {
        if (direction == 0) {
            return;
        }
        int count = 1;
        if (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) {
            count = 10;
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                count = 100;
            }
        }
        pageManager.offsetPage(MathHelper.clamp(-direction, -1, 1) * 2 * count);
        this.updateTabList();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 3) {
            pageManager.goBack();
            this.updateTabList();
            return;
        }
        if (mouseButton == 4) {
            pageManager.goForward();
            this.updateTabList();
            return;
        }
        int xOffset = 0;
        if (pageManager.getLeftPage() == null) {
            xOffset = -79;
        }
        if (pageManager.getRightPage() == null) {
            xOffset = 79;
        }
        int size = 24;
        int top = this.height / 2 - 110;
        int bottom = this.height / 2 + 110;
        int left = this.width / 2 - 158 + xOffset;
        int right = this.width / 2 + 158 + xOffset;
        if (pageManager.getLeftPage() != null && pageManager.hasPreviousPage()) {
            if (mouseX >= left && mouseX <= left + size && mouseY >= top && mouseY <= top + size) {
                pageManager.offsetPage(-2);
                this.updateTabList();
                return;
            }
            if (mouseX >= left && mouseX <= left + size && mouseY >= bottom - size && mouseY <= bottom) {
                pageManager.offsetPage(-2);
                this.updateTabList();
                return;
            }
        }
        if (pageManager.getRightPage() != null && pageManager.hasNextPage()) {
            if (mouseX >= right - size && mouseX <= right && mouseY >= top && mouseY <= top + size) {
                pageManager.offsetPage(2);
                this.updateTabList();
                return;
            }
            if (mouseX >= right - size && mouseX <= right && mouseY >= bottom - size && mouseY <= bottom) {
                pageManager.offsetPage(2);
                this.updateTabList();
                return;
            }
        }
        if (pageManager.getLeftPage() != null && mouseX > left && mouseX < left + 158 && mouseY > top && mouseY < bottom) {
            pageManager.getLeftPage().onMouseDown(left, top, mouseX, mouseY, mouseButton);
            this.updateTabList();
            return;
        }
        if (pageManager.getRightPage() != null && mouseX > left + 158 && mouseX < right && mouseY > top && mouseY < bottom) {
            pageManager.getRightPage().onMouseDown(left + 158, top, mouseX, mouseY, mouseButton);
            this.updateTabList();
            return;
        }
        this.handleTabClicks(mouseX, mouseY);
    }

    @Override
    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (key != 14) {
            super.keyTyped(c, key, mouseX, mouseY);
        }
        int xOffset = 0;
        if (pageManager.getLeftPage() == null) {
            xOffset = -79;
        }
        if (pageManager.getRightPage() == null) {
            xOffset = 79;
        }
        int top = this.height / 2 - 110;
        int left = this.width / 2 - 158 + xOffset;
        if (allowArrowKeyNavigation) {
            if (key == 203) {
                pageManager.offsetPage(-2);
                this.updateTabList();
            }
            if (key == 205) {
                pageManager.offsetPage(2);
                this.updateTabList();
            }
        }
        if (pageManager.getLeftPage() != null) {
            pageManager.getLeftPage().keyTyped(c, key, left, top, mouseX, mouseY);
            this.updateTabList();
        }
        if (pageManager.getRightPage() != null) {
            pageManager.getRightPage().keyTyped(c, key, left + 158, top, mouseX, mouseY);
            this.updateTabList();
        }
    }

    private void handleTabClicks(int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            if (tab == null) {
                return;
            }
            if (!tab.mouseOver(mouseX, mouseY)) continue;
            pageManager.setCurrentPage(pageManager.getSectionIndex(tab.getSection()), true);
            this.updateTabList();
            return;
        }
    }

    @Override
    public void guiSpecificControllerInput(ControllerInput controller) {
        int currentPage;
        Tab t;
        if (controller.digitalPad.left.pressedThisFrame() || controller.digitalPad.left.isPressed() && controller.digitalPad.left.getHoldTime() % 4 == 0) {
            pageManager.offsetPage(-2);
            this.updateTabList();
        }
        if (controller.digitalPad.right.pressedThisFrame() || controller.digitalPad.right.isPressed() && controller.digitalPad.right.getHoldTime() % 4 == 0) {
            pageManager.offsetPage(2);
            this.updateTabList();
        }
        if (controller.buttonR.pressedThisFrame() && (t = this.getTab(pageManager.getCurrentSection(), true)) != null) {
            currentPage = pageManager.getPageIndex(pageManager.getLeftPage());
            pageManager.setCurrentPage(pageManager.getSectionIndex(t.getSection()), true);
            if (currentPage == pageManager.getPageIndex(pageManager.getLeftPage())) {
                pageManager.offsetPage(2);
            }
            this.updateTabList();
        }
        if (controller.buttonL.pressedThisFrame() && (t = this.getTab(pageManager.getCurrentSection(), false)) != null) {
            currentPage = pageManager.getPageIndex(pageManager.getLeftPage());
            pageManager.setCurrentPage(pageManager.getSectionIndex(t.getSection()), true);
            if (currentPage == pageManager.getPageIndex(pageManager.getLeftPage())) {
                pageManager.offsetPage(-2);
            }
            this.updateTabList();
        }
    }

    private Tab getTab(GuidebookSection section, boolean searchForward) {
        int i;
        Tab tab = null;
        int index = -1;
        for (i = 0; i < this.tabs.length; ++i) {
            Tab t = this.tabs[i];
            if (t == null || t.getSection() != section) continue;
            if (section instanceof SearchSection) {
                index = i + 1;
                tab = this.tabs[i + 1];
                break;
            }
            index = i;
            tab = t;
            break;
        }
        if (tab == null) {
            return null;
        }
        for (i = 1; i < this.tabs.length; ++i) {
            int searchDex = (this.tabs.length + index + (searchForward ? i : -i)) % this.tabs.length;
            if (this.tabs[searchDex] == null) continue;
            return this.tabs[searchDex];
        }
        return null;
    }

    @Override
    public void tick() {
        super.tick();
        if (pageManager.getLeftPage() != null) {
            pageManager.getLeftPage().onTick();
        }
        if (pageManager.getRightPage() != null) {
            pageManager.getRightPage().onTick();
        }
        allowArrowKeyNavigation = !(pageManager.getLeftPage() instanceof SearchPage) && !(pageManager.getRightPage() instanceof SearchPage) || !SearchPage.searchField.isFocused || SearchPage.searchField.getText().isEmpty();
    }

    private void drawTabs(int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            if (tab == null) break;
            tab.render(this.mc.renderEngine, this.mc.fontRenderer, mouseX, mouseY);
        }
    }

    private void drawTooltip(int mouseX, int mouseY) {
        for (Tab tab : this.tabs) {
            if (tab == null) break;
            if (!tab.mouseOver(mouseX, mouseY)) continue;
            tab.renderTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    private void drawCurrentPages(int mouseX, int mouseY, int xOffset, float partialTicks) {
        int top = this.height / 2 - 110;
        int bottom = this.height / 2 + 110;
        int left = this.width / 2 - 158 + xOffset;
        int right = this.width / 2 + 158 + xOffset;
        GuidebookPage leftPage = pageManager.getLeftPage();
        GuidebookPage rightPage = pageManager.getRightPage();
        if (leftPage != null) {
            leftPage.render(this.mc.renderEngine, this.mc.fontRenderer, left, top, mouseX, mouseY, partialTicks);
        }
        if (rightPage != null) {
            rightPage.render(this.mc.renderEngine, this.mc.fontRenderer, right - 158, top, mouseX, mouseY, partialTicks);
        }
    }

    private void drawCurrentPageOverlays(int mouseX, int mouseY, int xOffset, float partialTicks) {
        int top = this.height / 2 - 110;
        int bottom = this.height / 2 + 110;
        int left = this.width / 2 - 158 + xOffset;
        int right = this.width / 2 + 158 + xOffset;
        GuidebookPage leftPage = pageManager.getLeftPage();
        GuidebookPage rightPage = pageManager.getRightPage();
        if (leftPage != null) {
            leftPage.renderOverlay(this.mc.renderEngine, this.mc.fontRenderer, left, top, mouseX, mouseY, partialTicks);
        }
        if (rightPage != null) {
            rightPage.renderOverlay(this.mc.renderEngine, this.mc.fontRenderer, right - 158, top, mouseX, mouseY, partialTicks);
        }
    }

    private void drawHeaders(int xOffset) {
        int bottom = this.height / 2 + 110;
        int left = this.width / 2 - 158 + xOffset;
        int right = this.width / 2 + 158 + xOffset;
        GuidebookPage leftPage = pageManager.getLeftPage();
        GuidebookPage rightPage = pageManager.getRightPage();
        if (leftPage != null && leftPage.drawHeaders()) {
            this.drawStringNoShadow(this.fontRenderer, String.valueOf(pageManager.getPageIndex(leftPage)), left + 12, bottom - 20, -16777216);
            this.drawStringCenteredNoShadow(this.fontRenderer, I18n.getInstance().translateKey(pageManager.getLeftPage().getSection().getTranslationKey()), left + 79, bottom - 20, -8355712);
        }
        if (rightPage != null && rightPage.drawHeaders()) {
            String str = String.valueOf(pageManager.getPageIndex(rightPage));
            this.drawStringNoShadow(this.fontRenderer, str, right - 12 - this.fontRenderer.getStringWidth(str), bottom - 20, -16777216);
            this.drawStringCenteredNoShadow(this.fontRenderer, I18n.getInstance().translateKey(pageManager.getRightPage().getSection().getTranslationKey()), right - 79, bottom - 20, -8355712);
        }
    }

    private void drawPageTurnIndicator(int mouseX, int mouseY, int xOffset) {
        int size = 24;
        int top = this.height / 2 - 110;
        int bottom = this.height / 2 + 110;
        int left = this.width / 2 - 158 + xOffset;
        int right = this.width / 2 + 158 + xOffset;
        this.mc.renderEngine.bindTexture(this.mc.renderEngine.getTexture("/assets/minecraft/textures/gui/guidebook/guidebook.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (pageManager.getLeftPage() != null && pageManager.hasPreviousPage()) {
            if (mouseX >= left && mouseX <= left + size && mouseY >= top && mouseY <= top + size) {
                this.drawTexturedModalRect(left, top, 0, 220, 24, 24);
            }
            if (mouseX >= left && mouseX <= left + size && mouseY >= bottom - size && mouseY <= bottom) {
                this.drawTexturedModalRect(left, bottom - size, 48, 220, 24, 24);
            }
        }
        if (pageManager.getRightPage() != null && pageManager.hasNextPage()) {
            if (mouseX >= right - size && mouseX <= right && mouseY >= top && mouseY <= top + size) {
                this.drawTexturedModalRect(right - size, top, 24, 220, 24, 24);
            }
            if (mouseX >= right - size && mouseX <= right && mouseY >= bottom - size && mouseY <= bottom) {
                this.drawTexturedModalRect(right - size, bottom - size, 72, 220, 24, 24);
            }
        }
    }

    private static class Tab
    extends Gui {
        private static ItemEntityRenderer itemRenderer = new ItemEntityRenderer();
        private static final int WIDTH = 36;
        private static final int HEIGHT = 24;
        private final GuidebookSection section;
        private int x = 0;
        private int y = 0;
        private boolean flipped = false;
        private boolean active = false;

        public Tab(GuidebookSection section) {
            this.section = section;
        }

        public GuidebookSection getSection() {
            return this.section;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void setFlipped(boolean flipped) {
            this.flipped = flipped;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void render(RenderEngine re, FontRenderer fr, int mouseX, int mouseY) {
            boolean mouseOver = this.mouseOver(mouseX, mouseY);
            re.bindTexture(re.getTexture("/assets/minecraft/textures/gui/guidebook/guidebook.png"));
            int xo = 16;
            if (mouseOver || this.active) {
                xo = 0;
            }
            if (this.flipped) {
                xo = -xo;
            }
            int u = 158;
            int v = 0;
            if (this.flipped) {
                v = 48;
            }
            int bgColor = this.section.getBackgroundColor();
            int fgColor = this.section.getForegroundColor();
            ItemStack icon = this.section.getTabIcon();
            OpenGLHelper.glColor1i(bgColor);
            this.drawTexturedModalRect(this.x + xo, this.y, u, v, 36, 24);
            OpenGLHelper.glColor1i(fgColor);
            this.drawTexturedModalRect(this.x + xo, this.y, u, v + 24, 36, 24);
            if (icon != null) {
                int iconOffset = this.flipped ? 4 : 16;
                GL11.glDepthMask((boolean)true);
                Lighting.enableInventoryLight();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2929);
                ItemModelDispatcher.getInstance().getDispatch(icon).renderItemIntoGui(Tessellator.instance, fr, re, icon, this.x + iconOffset + xo, this.y + 4, 1.0f);
                GL11.glDisable((int)2929);
                GL11.glDisable((int)32826);
                Lighting.disable();
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
            }
        }

        public void renderTooltip(GuiTooltip tooltip, int mouseX, int mouseY) {
            if (this.mouseOver(mouseX, mouseY)) {
                tooltip.render(I18n.getInstance().translateKey(this.section.getTranslationKey()), mouseX, mouseY, 8, -8);
            }
        }

        public boolean mouseOver(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseX <= this.x + 36 && mouseY >= this.y && mouseY <= this.y + 24;
        }
    }
}

