/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.cover.CoverSection;
import net.minecraft.client.gui.guidebook.crafting.CraftingSection;
import net.minecraft.client.gui.guidebook.index.IndexSection;
import net.minecraft.client.gui.guidebook.mobs.MobSection;
import net.minecraft.client.gui.guidebook.search.SearchSection;
import net.minecraft.client.gui.guidebook.smelting.BlastSmeltingSection;
import net.minecraft.client.gui.guidebook.smelting.SmeltingSection;
import net.minecraft.client.gui.guidebook.trommeling.TrommelSection;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;

public abstract class GuidebookSections {
    private static boolean initialized = false;
    private static List<GuidebookSection> sectionList = new ArrayList<GuidebookSection>();
    public static GuidebookSection COVER;
    public static GuidebookSection INDEX;
    public static GuidebookSection SEARCH;
    public static GuidebookSection MOB;
    public static GuidebookSection CRAFTING;
    public static GuidebookSection FURNACE;
    public static GuidebookSection BLAST_FURNACE;
    public static GuidebookSection TROMMEL;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        COVER = GuidebookSections.register(new CoverSection());
        INDEX = GuidebookSections.register(new IndexSection());
        SEARCH = GuidebookSections.register(new SearchSection());
        CRAFTING = GuidebookSections.register(new CraftingSection());
        FURNACE = GuidebookSections.register(new SmeltingSection("guidebook.section.furnace", new ItemStack(Block.furnaceStoneActive), 0x606060, 0x404040));
        BLAST_FURNACE = GuidebookSections.register(new BlastSmeltingSection("guidebook.section.blast_furnace", new ItemStack(Block.furnaceBlastActive), 0xA0A0A0, 0x808080));
        TROMMEL = GuidebookSections.register(new TrommelSection("guidebook.section.trommel", new ItemStack(Block.trommelActive), 0x202020, 0x404040));
        MOB = GuidebookSections.register(new MobSection());
    }

    public static GuidebookSection register(GuidebookSection section) {
        sectionList.add(section);
        return section;
    }

    public static List<GuidebookSection> getSectionList() {
        return Collections.unmodifiableList(sectionList);
    }
}

