/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.mobs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.render.EntityRenderDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.EntityChicken;
import net.minecraft.core.entity.animal.EntityCow;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.animal.EntityPig;
import net.minecraft.core.entity.animal.EntitySheep;
import net.minecraft.core.entity.animal.EntitySquid;
import net.minecraft.core.entity.animal.EntityWolf;
import net.minecraft.core.entity.monster.EntityArmoredZombie;
import net.minecraft.core.entity.monster.EntityCreeper;
import net.minecraft.core.entity.monster.EntityGhast;
import net.minecraft.core.entity.monster.EntityPigZombie;
import net.minecraft.core.entity.monster.EntitySkeleton;
import net.minecraft.core.entity.monster.EntitySlime;
import net.minecraft.core.entity.monster.EntitySnowman;
import net.minecraft.core.entity.monster.EntitySpider;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;

public abstract class MobInfoRegistry {
    private static final Map<Class<? extends Entity>, MobInfo> mobInfoMap = new HashMap<Class<? extends Entity>, MobInfo>();
    private static final List<Class<? extends Entity>> mobClassList = new ArrayList<Class<? extends Entity>>();

    public static void register(Class<? extends Entity> entityClass, String nameTranslationKey, String descriptionTranslationKey, int health, int score, MobDrop[] drops) {
        mobClassList.add(entityClass);
        mobInfoMap.put(entityClass, new MobInfo(entityClass, nameTranslationKey, descriptionTranslationKey, health, score, drops));
    }

    public static List<Class<? extends Entity>> getMobClassList() {
        return Collections.unmodifiableList(mobClassList);
    }

    public static MobInfo getMobInfo(Class<? extends Entity> entityClass) {
        return mobInfoMap.get(entityClass);
    }

    static {
        MobInfoRegistry.register(EntityPig.class, "guidebook.section.mob.pig.name", "guidebook.section.mob.pig.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Item.foodPorkchopRaw), 1.0f, 1, 2)});
        MobInfoRegistry.register(EntitySheep.class, "guidebook.section.mob.sheep.name", "guidebook.section.mob.sheep.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Block.wool), 1.0f, 1, 1)});
        MobInfoRegistry.register(EntityCow.class, "guidebook.section.mob.cow.name", "guidebook.section.mob.cow.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Item.leather), 1.0f, 1, 5)});
        MobInfoRegistry.register(EntityChicken.class, "guidebook.section.mob.chicken.name", "guidebook.section.mob.chicken.desc", 4, 10, new MobDrop[]{new MobDrop(new ItemStack(Item.featherChicken), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntitySquid.class, "guidebook.section.mob.squid.name", "guidebook.section.mob.squid.desc", 10, 10, new MobDrop[]{new MobDrop(new ItemStack(Item.dye, 1, 0), 1.0f, 1, 3)});
        MobInfoRegistry.register(EntityWolf.class, "guidebook.section.mob.wolf.name", "guidebook.section.mob.wolf.desc", 8, 500, null);
        MobInfoRegistry.register(EntityFireflyCluster.class, "guidebook.section.mob.firefly_cluster.name", "guidebook.section.mob.firefly_cluster.desc", -1, -1, null);
        MobInfoRegistry.register(EntityZombie.class, "guidebook.section.mob.zombie.name", "guidebook.section.mob.zombie.desc", 20, 300, new MobDrop[]{new MobDrop(new ItemStack(Item.cloth), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntityArmoredZombie.class, "guidebook.section.mob.armored_zombie.name", "guidebook.section.mob.armored_zombie.desc", 40, 1000, new MobDrop[]{new MobDrop(new ItemStack(Item.cloth), 1.0f, 1, 2), new MobDrop(new ItemStack(Item.chainlink), 0.8f, 1, 4)});
        MobInfoRegistry.register(EntitySnowman.class, "guidebook.section.mob.snowman.name", "guidebook.section.mob.snowman.desc", 20, 300, new MobDrop[]{new MobDrop(new ItemStack(Item.ammoSnowball), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntityCreeper.class, "guidebook.section.mob.creeper.name", "guidebook.section.mob.creeper.desc", 20, 800, new MobDrop[]{new MobDrop(new ItemStack(Item.sulphur), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntitySkeleton.class, "guidebook.section.mob.skeleton.name", "guidebook.section.mob.skeleton.desc", 20, 500, new MobDrop[]{new MobDrop(new ItemStack(Item.bone), 0.66f, 1, 2), new MobDrop(new ItemStack(Item.ammoArrow), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntitySpider.class, "guidebook.section.mob.spider.name", "guidebook.section.mob.spider.desc", 20, 200, new MobDrop[]{new MobDrop(new ItemStack(Item.string), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntitySlime.class, "guidebook.section.mob.slime.name", "guidebook.section.mob.slime.desc", -1, 100, new MobDrop[]{new MobDrop(new ItemStack(Item.slimeball), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntityGhast.class, "guidebook.section.mob.ghast.name", "guidebook.section.mob.ghast.desc", 20, 1000, new MobDrop[]{new MobDrop(new ItemStack(Item.sulphur), 0.66f, 1, 2)});
        MobInfoRegistry.register(EntityPigZombie.class, "guidebook.section.mob.zombie_pigman.name", "guidebook.section.mob.zombie_pigman.desc", 20, 500, new MobDrop[]{new MobDrop(new ItemStack(Item.foodPorkchopRaw), 0.297f, 1, 2), new MobDrop(new ItemStack(Item.oreRawGold), 0.0264f, 1, 2), new MobDrop(new ItemStack(Item.toolSwordGold), 0.0066f, 1, 1)});
    }

    public static class MobDrop {
        private final ItemStack dropStack;
        private final float dropChance;
        private final int minAmount;
        private final int maxAmount;

        public MobDrop(ItemStack dropStack, float dropChance, int minAmount, int maxAmount) {
            this.dropStack = dropStack;
            this.dropChance = dropChance;
            this.minAmount = minAmount;
            this.maxAmount = maxAmount;
        }

        public ItemStack getStack() {
            return this.dropStack;
        }

        public float getChance() {
            return this.dropChance;
        }

        public int getMinAmount() {
            return this.minAmount;
        }

        public int getMaxAmount() {
            return this.maxAmount;
        }
    }

    public static class MobInfo {
        private final Class<? extends Entity> entityClass;
        private final String nameTranslationKey;
        private final String descriptionTranslationKey;
        private final int health;
        private final int score;
        private final MobDrop[] drops;

        public MobInfo(Class<? extends Entity> entityClass, String nameTranslationKey, String descriptionTranslationKey, int health, int score, MobDrop[] drops) {
            this.entityClass = entityClass;
            this.nameTranslationKey = nameTranslationKey;
            this.descriptionTranslationKey = descriptionTranslationKey;
            this.health = health;
            this.score = score;
            this.drops = drops;
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public EntityRenderer<?> getRenderer() {
            return EntityRenderDispatcher.instance.getRenderer(this.entityClass);
        }

        public String getNameTranslationKey() {
            return this.nameTranslationKey;
        }

        public String getDescriptionTranslationKey() {
            return this.descriptionTranslationKey;
        }

        public int getHealth() {
            return this.health;
        }

        public int getScore() {
            return this.score;
        }

        public MobDrop[] getDrops() {
            return this.drops;
        }
    }
}

