/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.hud.Layout;
import net.minecraft.client.gui.hud.MovableHudComponent;
import net.minecraft.core.util.helper.Direction;
import org.lwjgl.opengl.GL11;

public class RotationLockComponent
extends MovableHudComponent {
    public RotationLockComponent(String key, Layout layout) {
        super(key, 24, 16, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.thePlayer.rotationLock != null && mc.thePlayer.rotationLock != Direction.NONE && mc.gameSettings.immersiveMode.drawOverlays();
    }

    @Override
    public void render(Minecraft mc, GuiIngame gui, int xSizeScreen, int ySizeScreen, float partialTick) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/icons.png"));
        GL11.glDisable((int)3042);
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        int u = (Integer)mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? 16 : 0;
        int v = 160;
        EntityPlayerSP player = mc.thePlayer;
        boolean facingUp = player.xRot < -45.0f;
        boolean facingDown = player.xRot > 45.0f;
        Direction dir = Direction.getDirection(player);
        if (dir.isHorizontal()) {
            dir = dir.rotate(-Direction.getHorizontalDirection((double)((double)player.yRot)).rotate((int)2).index);
            if (facingUp) {
                if (dir == Direction.SOUTH) {
                    dir = Direction.UP;
                }
                if (dir == Direction.NORTH) {
                    dir = Direction.DOWN;
                }
            }
            if (facingDown) {
                if (dir == Direction.SOUTH) {
                    dir = Direction.DOWN;
                }
                if (dir == Direction.NORTH) {
                    dir = Direction.UP;
                }
            }
        } else if (dir == Direction.UP) {
            dir = Direction.DOWN;
            if (facingUp) {
                dir = Direction.SOUTH;
            } else if (facingDown) {
                dir = Direction.NORTH;
            }
        } else if (dir == Direction.DOWN) {
            dir = Direction.UP;
            if (facingDown) {
                dir = Direction.SOUTH;
            } else if (facingUp) {
                dir = Direction.NORTH;
            }
        }
        gui.drawTexturedModalRect(x, y, u, v + dir.index * 16, 16, 16);
        dir = Direction.getVerticalDirection(player);
        gui.drawTexturedModalRect(x + 16, y + 4, u + (dir.index - 4) * 8, v - 8, 8, 8);
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBindTexture((int)3553, (int)mc.renderEngine.getTexture("/assets/minecraft/textures/gui/icons.png"));
        GL11.glDisable((int)3042);
        int u = (Integer)mc.gameSettings.rotationOverlayMode.value % 2 == 1 ? 16 : 0;
        int v = 160;
        gui.drawTexturedModalRect(x, y, u, v, 16, 16);
        gui.drawTexturedModalRect(x + 16, y + 4, u, v - 8, 8, 8);
    }
}

