/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.BlockTileEntity;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockMeshGold
extends BlockTileEntity {
    public BlockMeshGold(String key, int id) {
        super(key, id, Material.metal);
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityMeshGold();
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean canPlaceOnSurface() {
        return true;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, EntityPlayer player, Side side, double xPlaced, double yPlaced) {
        TileEntityMeshGold meshGold = (TileEntityMeshGold)world.getBlockTileEntity(x, y, z);
        ItemStack heldItem = player.getHeldItem();
        boolean flag = meshGold.setFilterItem(player, heldItem);
        if (heldItem != null && heldItem.stackSize <= 0) {
            player.inventory.setInventorySlotContents(player.inventory.currentItem, null);
        }
        return flag;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        TileEntityMeshGold mesh = (TileEntityMeshGold)world.getBlockTileEntity(x, y, z);
        if (mesh.filterItem != null) {
            EntityItem item = world.dropItem(x, y, z, mesh.filterItem);
            item.xd *= 0.5;
            item.yd *= 0.5;
            item.zd *= 0.5;
            item.delayBeforeCanPickup = 0;
        }
        super.onBlockRemoved(world, x, y, z, data);
    }

    @Override
    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        if (entity instanceof EntityItem) {
            TileEntityMeshGold mesh = (TileEntityMeshGold)world.getBlockTileEntity(x, y, z);
            if (mesh.filterItem == null) {
                return true;
            }
            ItemStack entityStack = ((EntityItem)entity).item;
            return !entityStack.isItemEqual(mesh.filterItem);
        }
        return true;
    }
}

