/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.List;
import net.minecraft.core.block.Block;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemPlaceable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class ItemJar
extends ItemPlaceable {
    protected ItemJar(String name, int id) {
        super(name, id, Block.jarGlass);
        this.setMaxStackSize(64);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack stack, EntityPlayer player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (player.isSneaking()) {
            return super.onUseItemOnBlock(stack, player, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
        }
        int count = stack.stackSize;
        ItemStack used = this.onUseItem(stack, world, player);
        if (used != null && used.stackSize != count) {
            return true;
        }
        return super.onUseItemOnBlock(stack, player, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.isSneaking()) {
            return itemstack;
        }
        List<Entity> list = world.getEntitiesWithinAABBExcludingEntity(entityplayer, entityplayer.bb.expand(2.0, 2.0, 2.0));
        for (Entity entity : list) {
            if (!(entity instanceof EntityFireflyCluster)) continue;
            EntityFireflyCluster fireflyCluster = (EntityFireflyCluster)entity;
            EntityFireflyCluster.FireflyColor colour = fireflyCluster.getColor();
            boolean didFillJar = colour == EntityFireflyCluster.FireflyColor.BLUE ? ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyBlue, 1)) : (colour == EntityFireflyCluster.FireflyColor.ORANGE ? ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyOrange, 1)) : (colour == EntityFireflyCluster.FireflyColor.RED ? ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyRed, 1)) : ItemJar.fillJar(entityplayer, new ItemStack(Item.lanternFireflyGreen, 1))));
            if (!world.isClientSide && didFillJar) {
                fireflyCluster.setFireflyCount(fireflyCluster.getFireflyCount() - 1);
                if (fireflyCluster.getFireflyCount() <= 0) {
                    fireflyCluster.remove();
                }
            }
            return itemstack;
        }
        return itemstack;
    }

    public static boolean fillJar(EntityPlayer player, ItemStack itemToGive) {
        if (player.inventory.getCurrentItem().stackSize <= 1) {
            player.inventory.setInventorySlotContents(player.inventory.currentItem, itemToGive);
        } else {
            player.inventory.insertItem(itemToGive, true);
        }
        if (itemToGive.stackSize < 1) {
            player.swingItem();
            player.inventory.getCurrentItem().consumeItem(player);
            return true;
        }
        return false;
    }
}

