/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.lang.WorldNameGenerator;

public class Language {
    protected List<String> reportedMissingTranslations = new ArrayList<String>();
    protected final Properties entries;
    private final String id;
    private final String name;
    private final String region;
    private final List<String> credits;
    protected List<String> tips = null;
    protected WorldNameGenerator worldNameGenerator = null;

    Language(String id, String name, String region, List<String> credits, ZipFile zipFile) {
        this.id = id;
        this.name = name;
        this.region = region;
        this.credits = credits;
        this.entries = new Properties();
        if (zipFile != null) {
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                Throwable throwable;
                InputStreamReader reader2;
                Throwable throwable2;
                InputStream in;
                ZipEntry entry = zipEntries.nextElement();
                if (entry.getName().endsWith(".lang")) {
                    try {
                        in = zipFile.getInputStream(entry);
                        throwable2 = null;
                        try {
                            reader2 = new InputStreamReader(in, StandardCharsets.UTF_8);
                            throwable = null;
                            try {
                                this.entries.load(reader2);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (reader2 == null) continue;
                                if (throwable != null) {
                                    try {
                                        reader2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                reader2.close();
                            }
                        }
                        catch (Throwable reader2) {
                            throwable2 = reader2;
                            throw reader2;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable reader2) {
                                    throwable2.addSuppressed(reader2);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (this.tips == null && entry.getName().equalsIgnoreCase("tips.txt")) {
                    try {
                        in = zipFile.getInputStream(entry);
                        throwable2 = null;
                        try {
                            reader2 = new InputStreamReader(in, StandardCharsets.UTF_8);
                            throwable = null;
                            try {
                                this.tips = Arrays.asList(reader2.toString().split("\n"));
                            }
                            catch (Throwable throwable5) {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (reader2 == null) continue;
                                if (throwable != null) {
                                    try {
                                        reader2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                    continue;
                                }
                                reader2.close();
                            }
                        }
                        catch (Throwable reader3) {
                            throwable2 = reader3;
                            throw reader3;
                        }
                        finally {
                            if (in == null) continue;
                            if (throwable2 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable reader3) {
                                    throwable2.addSuppressed(reader3);
                                }
                                continue;
                            }
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!entry.getName().equalsIgnoreCase("worldnames.txt")) continue;
                try {
                    in = zipFile.getInputStream(entry);
                    throwable2 = null;
                    try {
                        reader2 = new InputStreamReader(in, StandardCharsets.UTF_8);
                        throwable = null;
                        try {
                            BufferedReader bufferedReader = new BufferedReader(reader2);
                            Throwable throwable7 = null;
                            try {
                                this.worldNameGenerator = new WorldNameGenerator(bufferedReader.lines().collect(Collectors.toList()));
                            }
                            catch (Throwable throwable8) {
                                throwable7 = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (bufferedReader == null) continue;
                                if (throwable7 != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (Throwable throwable9) {
                                        throwable7.addSuppressed(throwable9);
                                    }
                                    continue;
                                }
                                bufferedReader.close();
                            }
                        }
                        catch (Throwable throwable10) {
                            throwable = throwable10;
                            throw throwable10;
                        }
                        finally {
                            if (reader2 == null) continue;
                            if (throwable != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable throwable11) {
                                    throwable.addSuppressed(throwable11);
                                }
                                continue;
                            }
                            reader2.close();
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable2 = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable13) {
                                throwable2.addSuppressed(throwable13);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String translateKey(String key) {
        if (key == null) {
            return null;
        }
        String ret = this.entries.getProperty(key);
        if (ret == null) {
            if (!this.reportedMissingTranslations.contains(key)) {
                System.err.println("Missing translation: " + key + "\n at " + Thread.currentThread().getStackTrace()[2]);
                this.reportedMissingTranslations.add(key);
            }
            return Default.INSTANCE.translateKey(key);
        }
        return ret;
    }

    public String translateKeyAndFormat(String formatKey, Object ... args) {
        String format = this.entries.getProperty(formatKey, formatKey);
        if (formatKey.equals(format)) {
            format = Default.INSTANCE.entries.getProperty(formatKey, formatKey);
        }
        return String.format(format, args);
    }

    public List<String> getTips() {
        if (this.tips == null) {
            return Default.INSTANCE.getTips();
        }
        return this.tips;
    }

    public String getRandomWorldName() {
        if (this.worldNameGenerator == null) {
            return Default.INSTANCE.getRandomWorldName();
        }
        return this.worldNameGenerator.getRandomWorldName();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCredits() {
        return this.credits;
    }

    public String getRegion() {
        return this.region;
    }

    public int keySize() {
        return this.entries.size();
    }

    void onReload() {
    }

    public boolean isDefault() {
        return false;
    }

    public static final class Default
    extends Language {
        public static final Default INSTANCE = new Default();

        private Default() {
            super("en_US", "English", "US", Arrays.asList("Mojang", "jonkadelic", "skydeckagogo"), null);
            this.entries.clear();
            for (String path : I18n.getFilesInDirectory("/lang/en_US/")) {
                Throwable throwable;
                BufferedReader bufferedReader2;
                Throwable throwable2;
                InputStreamReader reader2;
                Throwable throwable3;
                InputStream stream;
                if (path.endsWith(".lang")) {
                    try {
                        stream = I18n.getResourceAsStream(path);
                        throwable3 = null;
                        try {
                            reader2 = new InputStreamReader(stream, StandardCharsets.UTF_8);
                            throwable2 = null;
                            try {
                                this.entries.load(reader2);
                            }
                            catch (Throwable throwable4) {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (reader2 != null) {
                                    if (throwable2 != null) {
                                        try {
                                            reader2.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable2.addSuppressed(throwable5);
                                        }
                                    } else {
                                        reader2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable reader2) {
                            throwable3 = reader2;
                            throw reader2;
                        }
                        finally {
                            if (stream != null) {
                                if (throwable3 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable reader2) {
                                        throwable3.addSuppressed(reader2);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (this.tips == null && path.endsWith("/tips.txt")) {
                    try {
                        stream = I18n.getResourceAsStream(path);
                        throwable3 = null;
                        try {
                            reader2 = new InputStreamReader(stream, StandardCharsets.UTF_8);
                            throwable2 = null;
                            try {
                                bufferedReader2 = new BufferedReader(reader2);
                                throwable = null;
                                try {
                                    String st;
                                    this.tips = new ArrayList();
                                    while ((st = bufferedReader2.readLine()) != null) {
                                        this.tips.add(st);
                                    }
                                }
                                catch (Throwable throwable6) {
                                    throwable = throwable6;
                                    throw throwable6;
                                }
                                finally {
                                    if (bufferedReader2 != null) {
                                        if (throwable != null) {
                                            try {
                                                bufferedReader2.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            bufferedReader2.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable bufferedReader2) {
                                throwable2 = bufferedReader2;
                                throw bufferedReader2;
                            }
                            finally {
                                if (reader2 != null) {
                                    if (throwable2 != null) {
                                        try {
                                            reader2.close();
                                        }
                                        catch (Throwable bufferedReader2) {
                                            throwable2.addSuppressed(bufferedReader2);
                                        }
                                    } else {
                                        reader2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable reader3) {
                            throwable3 = reader3;
                            throw reader3;
                        }
                        finally {
                            if (stream != null) {
                                if (throwable3 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable reader3) {
                                        throwable3.addSuppressed(reader3);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!path.endsWith("/worldnames.txt")) continue;
                try {
                    stream = I18n.getResourceAsStream(path);
                    throwable3 = null;
                    try {
                        reader2 = new InputStreamReader(stream, StandardCharsets.UTF_8);
                        throwable2 = null;
                        try {
                            bufferedReader2 = new BufferedReader(reader2);
                            throwable = null;
                            try {
                                this.worldNameGenerator = new WorldNameGenerator(bufferedReader2.lines().collect(Collectors.toList()));
                            }
                            catch (Throwable throwable8) {
                                throwable = throwable8;
                                throw throwable8;
                            }
                            finally {
                                if (bufferedReader2 != null) {
                                    if (throwable != null) {
                                        try {
                                            bufferedReader2.close();
                                        }
                                        catch (Throwable throwable9) {
                                            throwable.addSuppressed(throwable9);
                                        }
                                    } else {
                                        bufferedReader2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            throwable2 = throwable10;
                            throw throwable10;
                        }
                        finally {
                            if (reader2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        reader2.close();
                                    }
                                    catch (Throwable throwable11) {
                                        throwable2.addSuppressed(throwable11);
                                    }
                                } else {
                                    reader2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable12) {
                        throwable3 = throwable12;
                        throw throwable12;
                    }
                    finally {
                        if (stream != null) {
                            if (throwable3 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable13) {
                                    throwable3.addSuppressed(throwable13);
                                }
                            } else {
                                stream.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public String translateKey(String key) {
            if (key == null) {
                return null;
            }
            String ret = this.entries.getProperty(key);
            if (ret == null) {
                if (!this.reportedMissingTranslations.contains(key)) {
                    this.reportedMissingTranslations.add(key);
                    System.err.println("Missing translation in default language: " + key + "\n at " + Thread.currentThread().getStackTrace()[3]);
                }
                return key;
            }
            return ret;
        }

        @Override
        public boolean isDefault() {
            return true;
        }
    }
}

