/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.net.handler.NetPingHandler;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet254PingHandshake
extends Packet {
    public int payload;
    public int identifier;
    public String pingHostString;
    public int protocolVersion;
    public String hostname;
    public int port;

    public Packet254PingHandshake() {
    }

    public Packet254PingHandshake(int payload, int identifier, String pingHostString, int protocolVersion, String hostname, int port) {
        this.payload = payload;
        this.identifier = identifier;
        this.pingHostString = pingHostString;
        this.protocolVersion = protocolVersion;
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.payload = dis.readUnsignedByte();
        this.identifier = dis.readUnsignedByte();
        this.pingHostString = Packet254PingHandshake.readUTF16BEString(dis, 255);
        dis.readUnsignedShort();
        this.protocolVersion = dis.readUnsignedByte();
        this.hostname = Packet254PingHandshake.readUTF16BEString(dis, 255);
        this.port = dis.readInt();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.payload);
        dos.writeByte(this.identifier);
        Packet254PingHandshake.writeUTF16BEString(this.pingHostString, dos);
        dos.writeShort(3 + StandardCharsets.UTF_16BE.encode(this.pingHostString).array().length + 4);
        dos.writeByte(this.protocolVersion);
        Packet254PingHandshake.writeUTF16BEString(this.hostname, dos);
        dos.writeInt(this.port);
        NetPingHandler.startTime = System.currentTimeMillis();
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handlePingHandshake(this);
    }

    @Override
    public int getPacketSize() {
        return 0;
    }
}

