/*
 * Decompiled with CFR 0.152.
 */
package net.betterthanadventure.utils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Global;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.tag.ITaggable;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.enums.EnumCreatureType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemFood;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.item.tool.ItemToolPickaxe;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.weather.Weather;

public class DataDumper
implements MinecraftAccessor {
    private static File minecraftDir = null;
    private static I18n translator;
    public static boolean hideUnused;

    public static void main(String[] args) {
        for (String arg : args) {
            int i = arg.indexOf(61);
            if (i == -1) {
                System.out.println("Skipping argument '" + arg + "'");
                continue;
            }
            String key = arg.substring(0, i);
            String value = arg.substring(i + 1);
            if (key.equals("hide-unused")) {
                hideUnused = Boolean.parseBoolean(value);
                continue;
            }
            System.out.println("Skipping argument '" + arg + "'");
        }
        try {
            new DataDumper();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DataDumper() throws IOException {
        String string;
        int i;
        Global.accessor = this;
        I18n.initialize("en_US");
        translator = I18n.getInstance();
        System.out.println(Block.dirt.id);
        System.out.println(Item.stick.id);
        File wikiDumpFile = new File(this.getMinecraftDir(), "infodump");
        wikiDumpFile.mkdirs();
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(wikiDumpFile, "blocks.csv")));
        writer.write("ID,Translation Key,Hardness,Blast Resistance,Mining Level,Stacksize,Name,Description,Tags\n");
        for (i = 0; i < Block.blocksList.length; ++i) {
            Block block = Block.blocksList[i];
            string = DataDumper.blockToCSV(block);
            if (string.isEmpty() && !hideUnused) {
                string = i + "\n";
            }
            writer.write(string);
        }
        writer.close();
        writer = new BufferedWriter(new FileWriter(new File(wikiDumpFile, "items.csv")));
        writer.write("ID,Translation Key,Durability,Restores,Stacksize,Name,Description,Tags\n");
        for (i = Block.blocksList.length; i < Item.itemsList.length; ++i) {
            Item item = Item.itemsList[i];
            string = DataDumper.itemToCSV(item);
            if (string.isEmpty() && !hideUnused) {
                string = i + "\n";
            }
            writer.write(string);
        }
        writer.close();
        writer = new BufferedWriter(new FileWriter(new File(wikiDumpFile, "biomes.csv")));
        writer.write("ID,Translation Key,Color,Top Block,Filler block,Has Surface Snow,Blocked Weather,Monsters,Animals,Water Creatures,Ambient Creatures\n");
        for (i = 0; i < Registries.BIOMES.size(); ++i) {
            Biome biome = Registries.BIOMES.getItemByNumericId(i);
            string = DataDumper.biomeToCSV(biome);
            if (string.isEmpty() && !hideUnused) {
                string = i + "\n";
            }
            writer.write(string);
        }
        writer.close();
    }

    public static String itemToCSV(Item item) {
        if (item == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(item.id).append(",").append(item.getKey()).append(",").append(item.getMaxDamage()).append(",").append(item instanceof ItemFood ? Integer.valueOf(((ItemFood)item).getHealAmount()) : "").append(",").append(item.getItemStackLimit()).append(",").append("\"").append(translator.translateNameKey(item.getKey())).append("\"").append(",").append("\"").append(translator.translateDescKey(item.getKey())).append("\"").append(",");
        builder.append("\"").append(DataDumper.taglistString(ItemTags.TAG_LIST, item)).append("\"");
        builder.append("\n");
        return builder.toString();
    }

    public static String blockToCSV(Block block) {
        if (block == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(block.id).append(",").append(block.getKey()).append(",").append(block.getHardness()).append(",").append(block.getBlastResistance(null)).append(",").append(ItemToolPickaxe.miningLevels.getOrDefault(block, 0)).append(",").append(block.asItem().getItemStackLimit()).append(",").append("\"").append(translator.translateNameKey(block.getKey())).append("\"").append(",").append("\"").append(translator.translateDescKey(block.getKey())).append("\"").append(",");
        builder.append("\"").append(DataDumper.taglistString(BlockTags.TAG_LIST, block)).append("\"");
        builder.append("\n");
        return builder.toString();
    }

    public static String biomeToCSV(Biome biome) {
        if (biome == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(Registries.BIOMES.getNumericIdOfItem(biome)).append(",").append(biome.translationKey).append(",").append(String.format("0x%06X", biome.color)).append(",").append(Block.blocksList[biome.topBlock].getKey()).append(",").append(Block.blocksList[biome.fillerBlock].getKey()).append(",").append(biome.hasSurfaceSnow()).append(",");
        builder.append("\"");
        StringBuilder weatherString = new StringBuilder();
        for (Weather weather : biome.blockedWeathers) {
            weatherString.append(weather.languageKey).append(", ");
        }
        String s = weatherString.toString().trim();
        if (!s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
        }
        builder.append(s).append("\",");
        builder.append("\"").append(DataDumper.spawnableListString(biome.getSpawnableList(EnumCreatureType.monster))).append("\",");
        builder.append("\"").append(DataDumper.spawnableListString(biome.getSpawnableList(EnumCreatureType.creature))).append("\",");
        builder.append("\"").append(DataDumper.spawnableListString(biome.getSpawnableList(EnumCreatureType.waterCreature))).append("\",");
        builder.append("\"").append(DataDumper.spawnableListString(biome.getSpawnableList(EnumCreatureType.ambientCreature))).append("\"");
        builder.append("\n");
        return builder.toString();
    }

    public static <T extends ITaggable<T>> String taglistString(List<Tag<T>> tagList, T item) {
        StringBuilder tags = new StringBuilder();
        for (Tag<T> tag : tagList) {
            if (!tag.appliesTo(item)) continue;
            tags.append(tag.getName()).append(", ");
        }
        String s = tags.toString().trim();
        if (s.isEmpty()) {
            return "";
        }
        s = s.substring(0, s.length() - 1);
        return s;
    }

    public static String spawnableListString(List<SpawnListEntry> spawnListEntries) {
        if (spawnListEntries.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < spawnListEntries.size(); ++i) {
            SpawnListEntry entry = spawnListEntries.get(i);
            builder.append("[").append(entry.entityClass.getSimpleName()).append(", ").append(entry.spawnFrequency).append("]");
            if (i == spawnListEntries.size() - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public File getMinecraftDir() {
        if (!Global.isServer && Minecraft.getMinecraft(Minecraft.class) != null) {
            return Minecraft.getMinecraft(Minecraft.class).getMinecraftDir();
        }
        if (minecraftDir == null) {
            try {
                minecraftDir = Minecraft.getAppDir("minecraft-bta");
            }
            catch (Exception e) {
                minecraftDir = new File(".");
            }
        }
        return minecraftDir;
    }

    @Override
    public IChunkProvider createChunkProvider(World world, IChunkLoader chunkLoader) {
        return null;
    }

    @Override
    public int getAutosaveTimer() {
        return 0;
    }

    @Override
    public SkinVariantList getSkinVariantList() {
        return null;
    }

    @Override
    public String getMinecraftVersion() {
        return null;
    }

    static {
        hideUnused = true;
    }
}

