/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.modelviewer.categories.ModelViewerCategory;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.DispatcherEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityArmoredZombieEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityBoatEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityCreeperEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityFallingSandEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityFireflyEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityItemEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityMinecartEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityPaintingEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntitySheepEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntitySlimeEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityTNTEntry;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityWolfEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerTextField;
import net.minecraft.client.gui.modelviewer.elements.GuiTextCycle;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.monster.EntityHuman;
import net.minecraft.core.entity.monster.EntityZombie;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;

public class EntityCategory
extends ModelViewerCategory {
    public HashMap<Class<? extends Entity>, EntityEntry<?>> entryMap = new HashMap();
    public List<EntityEntry<?>> entryList = new ArrayList();
    public GuiListenerTextField entityName;
    public GuiTextCycle<Integer> entityVariant;
    public EntityEntry<?> currentEntry = EntityEntry.blankEntry;
    public Entity displayEntity;

    public EntityCategory(GuiModelViewer modelViewer) {
        super(modelViewer);
        this.createEntries();
    }

    public void createEntries() {
        for (String s : EntityDispatcher.classToKeyMap.values()) {
            try {
                this.addEntry(new DispatcherEntry(s));
            }
            catch (Exception exception) {}
        }
        this.addEntry(new EntityItemEntry());
        this.addEntry(new EntityFireflyEntry());
        this.addEntry(new EntitySheepEntry());
        this.addEntry(new EntityWolfEntry());
        this.addEntry(new EntityCreeperEntry());
        this.addEntry(new EntityArmoredZombieEntry());
        this.addEntry(new EntitySlimeEntry());
        this.addEntry(new EntityMinecartEntry());
        this.addEntry(new EntityBoatEntry());
        this.addEntry(new EntityFallingSandEntry());
        this.addEntry(new EntityTNTEntry());
        this.addEntry(new EntityPaintingEntry());
    }

    public void addEntry(EntityEntry<?> entry) {
        Object entity = entry.getEntityInstance(this.mc, this.mc.theWorld);
        if (entity == null) {
            return;
        }
        EntityEntry<?> oldEntry = this.entryMap.put(entity.getClass(), entry);
        this.entryList.remove(oldEntry);
        this.entryList.add(entry);
    }

    public <V extends Entity> EntityEntry<V> getEntry(V entity) {
        return this.entryMap.getOrDefault(entity.getClass(), EntityEntry.blankEntry);
    }

    @Override
    public String getCategoryNameKey() {
        return "model.category.entity.name";
    }

    @Override
    public String getCurrentDisplayInfo(I18n translator) {
        String title = "None";
        if (this.displayEntity != null) {
            title = Entity.getNameFromEntity(this.displayEntity, false);
        }
        return translator.translateKeyAndFormat("model.category.entity.info", title);
    }

    @Override
    public void addContextButtons(List<GuiButton> buttonList) {
        GuiButton lastButton = buttonList.get(buttonList.size() - 1);
        boolean isLiving = this.displayEntity instanceof EntityLiving;
        if (isLiving) {
            this.entityVariant = new GuiTextCycle<Integer>((GuiScreen)this.modelViewer, this.mc.fontRenderer, this.modelViewer.width - 120, lastButton.yPosition + 21, 120, 20, Integer.valueOf(0)){

                @Override
                public Integer cycleElement(Integer current, int offset) {
                    return current + offset & 0x7F;
                }

                @Override
                public Integer getElementFromString(String s) {
                    try {
                        int id = Integer.parseInt(s);
                        return MathHelper.clamp(id, 0, 127);
                    }
                    catch (Exception exception) {
                        return EntityCategory.this.displayEntity.getEntityData().getByte(1);
                    }
                }

                @Override
                public String getNameFromElement(Integer element) {
                    return String.valueOf(element);
                }
            };
            this.entityVariant.setOnValueChanged(() -> ((EntityLiving)this.displayEntity).setSkinVariant(this.entityVariant.getCurrentElement()));
            this.entityVariant.textField.setPlaceholder("Variant");
            this.entityVariant.textField.setPrefaceText("Variant: ");
            buttonList.add(this.entityVariant);
            this.entityName = new GuiListenerTextField(this.modelViewer, this.mc.fontRenderer, this.modelViewer.width - 120, this.entityVariant.yPosition + 21, 120, 20, "", "Nickname");
            this.entityName.setTextChangeListener(this.modelViewer);
            buttonList.add(this.entityName);
        }
        lastButton = buttonList.get(buttonList.size() - 1);
        int xPos = this.modelViewer.width;
        int yPos = lastButton.getY() + lastButton.getHeight() + 1;
        List<GuiButton> entryButtons = this.getEntry(this.displayEntity).getEntryButtons(this.mc, this.modelViewer, this.displayEntity);
        if (entryButtons != null) {
            for (GuiButton button : entryButtons) {
                button.setX(button.getX() + xPos);
                button.setY(button.getY() + yPos);
            }
            buttonList.addAll(entryButtons);
        }
    }

    @Override
    public void cycleCategoryEntry(int offset) {
        int id = 0;
        ArrayList _val = new ArrayList(this.entryList);
        if (this.currentEntry != EntityEntry.blankEntry) {
            id = _val.indexOf(this.currentEntry);
        }
        this.currentEntry.onClose();
        this.currentEntry = (EntityEntry)_val.get((id + _val.size() + offset) % _val.size());
        this.currentEntry.onOpen();
        this.setDisplayEntity((Entity)this.currentEntry.getEntityInstance(this.mc, this.mc.theWorld));
    }

    @Override
    public void onOpen() {
        this.currentEntry = this.entryMap.get(EntityZombie.class);
        this.currentEntry.onOpen();
        this.setDisplayEntity((Entity)this.currentEntry.getEntityInstance(this.mc, this.mc.theWorld));
    }

    @Override
    public void onClose() {
        this.currentEntry.onClose();
        this.removeDisplayEntity();
    }

    @Override
    public void onTick() {
        String oldNick;
        if (this.displayEntity != null) {
            ++this.displayEntity.tickCount;
            this.getEntry(this.displayEntity).onTick(this.displayEntity);
        }
        if (!(this.displayEntity instanceof EntityHuman && System.currentTimeMillis() <= this.modelViewer.timeLastKeyPressed + 1000L || this.displayEntity == null || !(this.displayEntity instanceof EntityLiving) || (oldNick = ((EntityLiving)this.displayEntity).nickname).equals(this.entityName.getText()))) {
            ((EntityLiving)this.displayEntity).setNickname(this.entityName.getText());
        }
    }

    public void setDisplayEntity(Entity entity) {
        this.removeDisplayEntity();
        this.displayEntity = entity;
        if (this.displayEntity != null) {
            this.displayEntity.noPhysics = true;
            this.displayEntity.absMoveTo(this.mc.thePlayer.x, this.mc.thePlayer.y - (double)(this.displayEntity.bbHeight / 2.0f), this.mc.thePlayer.z, this.displayEntity.yRot, this.displayEntity.xRot);
            this.displayEntity.lerpMotion(0.0, 0.0, 0.0);
            this.mc.theWorld.entityJoinedWorld(this.displayEntity);
            if (this.displayEntity instanceof EntityLiving) {
                ((EntityLiving)this.displayEntity).setSkinVariant(0);
            }
        }
        this.mc.effectRenderer.clearEffects(this.mc.theWorld);
        this.modelViewer.init();
    }

    public void removeDisplayEntity() {
        if (this.displayEntity != null) {
            this.displayEntity.remove();
            this.mc.theWorld.loadedEntityList.remove(this.displayEntity);
        }
        this.mc.effectRenderer.clearEffects(this.mc.theWorld);
    }
}

