/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.GuiModelViewer;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiTextCycle;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.DisplayChunk;

public class JarEntry
extends BlockEntry {
    public JarEntry() {
        super(Block.jarGlass);
    }

    @Override
    public void onTick(World world, int meta) {
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, World world, int meta) {
        final GuiTextCycle<Integer> jarCycle = new GuiTextCycle<Integer>(parentScreen, mc.fontRenderer, -120, 0, 120, 20, Integer.valueOf(0)){

            @Override
            public Integer cycleElement(Integer current, int offset) {
                return GuiModelViewer.cycleBlockId(current, offset);
            }

            @Override
            public Integer getElementFromString(String s) {
                try {
                    int id = MathHelper.clamp(Integer.parseInt(s), 0, Block.blocksList.length);
                    if (Block.getBlock(id) != null) {
                        return id;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return DisplayChunk.displayBlockId;
            }

            @Override
            public String getNameFromElement(Integer element) {
                return String.valueOf(element);
            }
        };
        jarCycle.textField.setPrefaceText("Jar: ");
        jarCycle.textField.setPlaceholder("Jar ID");
        jarCycle.setOnValueChanged(() -> {
            ((TileEntityFlowerJar)DisplayChunk.displayTileEntity).flowerInPot = (Integer)jarCycle.getCurrentElement();
        });
        return new ArrayList<GuiButton>(){
            {
                this.add(jarCycle);
            }
        };
    }

    @Override
    public void onClose(World world, int meta) {
    }

    @Override
    public void onOpen(World world, int meta) {
    }
}

