/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPhotoMode;
import net.minecraft.client.option.enums.LightmapStyle;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.WorldRenderer;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.util.helper.Buffer;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class LightmapHelper {
    private static LightmapHelper instance = null;
    public final Minecraft mc;
    public final WorldRenderer worldRenderer;
    private int lightmapTexture = 0;
    private int[] lightmapData = new int[256];
    public BufferedImage customLightmap;
    private float prevSkyDarken;
    public float skyDarkenSmooth;

    public static boolean isLightmapEnabled() {
        return instance != null && instance.isEnabled();
    }

    public LightmapHelper(Minecraft mc, WorldRenderer worldRenderer) {
        this.mc = mc;
        this.worldRenderer = worldRenderer;
        instance = this;
    }

    public void setup() {
        World world = this.mc.theWorld;
        if (((Boolean)this.mc.gameSettings.customLightmap.value).booleanValue() && world != null) {
            int dimension = world.dimension.id;
            String path = "/environment/lightmap" + dimension + ".png";
            System.out.println("Loading lightmap '" + path + "'");
            this.customLightmap = this.mc.renderEngine.getImage(path);
            if (this.customLightmap == Textures.missingTexture) {
                this.customLightmap = null;
            }
            if (this.customLightmap != null) {
                System.out.println("Loaded lightmap!");
            } else {
                System.out.println("No lightmap!");
            }
        } else {
            this.customLightmap = null;
        }
    }

    public boolean isEnabled() {
        return this.mc.gameSettings.lightmapStyle.value != LightmapStyle.DISABLED;
    }

    public void tick() {
        World world = this.mc.theWorld;
        if (world == null) {
            return;
        }
        this.prevSkyDarken = this.skyDarkenSmooth;
        float skyDarken = world.skyDarken;
        this.skyDarkenSmooth = Math.abs(this.skyDarkenSmooth - skyDarken) > 1.5f ? (this.prevSkyDarken = skyDarken) : MathHelper.lerp(skyDarken, this.skyDarkenSmooth, 0.99f);
    }

    public void update(float partialTicks) {
        World world = this.mc.theWorld;
        if (!this.isEnabled() || world == null) {
            return;
        }
        if (this.mc.fullbright) {
            for (int i = 0; i < this.lightmapData.length; ++i) {
                this.lightmapData[i] = -1;
            }
        } else if (((Boolean)this.mc.gameSettings.customLightmap.value).booleanValue() && this.customLightmap != null) {
            this.generateCustomLightmap(world);
        } else {
            LightmapStyle lightmapStyle = (LightmapStyle)((Object)this.mc.gameSettings.lightmapStyle.value);
            if (lightmapStyle == LightmapStyle.COLORIZED) {
                this.generateColorizedLightmap(world, partialTicks);
            } else if (lightmapStyle == LightmapStyle.GRAY) {
                this.generateGrayLightmap(world, partialTicks);
            }
        }
        OpenGLHelper.checkError("pre generate lightmap");
        this.setLightmapTextureData(this.lightmapData);
        OpenGLHelper.checkError("generate lightmap");
    }

    public void disableLightmapRendering() {
        GL13.glClientActiveTexture((int)33985);
        GL13.glActiveTexture((int)33985);
        GL11.glDisable((int)3553);
        GL13.glClientActiveTexture((int)33984);
        GL13.glActiveTexture((int)33984);
    }

    public void enableLightmapRendering() {
        if (!this.isEnabled()) {
            return;
        }
        OpenGLHelper.checkError("pre enable lightmap");
        GL13.glClientActiveTexture((int)33985);
        GL13.glActiveTexture((int)33985);
        GL11.glMatrixMode((int)5890);
        GL11.glLoadIdentity();
        float scale = 0.00390625f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)8.0f, (float)8.0f, (float)8.0f);
        GL11.glMatrixMode((int)5888);
        this.mc.renderEngine.bindTexture(this.lightmapTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL13.glClientActiveTexture((int)33984);
        GL13.glActiveTexture((int)33984);
        OpenGLHelper.checkError("enable lightmap");
    }

    public void generateGrayLightmap(World world, float partialTicks) {
        boolean smooth = (Boolean)this.mc.gameSettings.ambientOcclusion.value;
        for (int i = 0; i < 256; ++i) {
            int color;
            float brightness;
            int skyLightLevel = i / 16;
            int blockLightLevel = i & 0xF;
            if (smooth) {
                float skyDarken = this.prevSkyDarken + (this.skyDarkenSmooth - this.prevSkyDarken) * partialTicks;
                if (this.mc.currentScreen instanceof GuiPhotoMode) {
                    skyDarken = world.skyDarken;
                }
                float modifiedSkylight = Math.max(0.0f, (float)skyLightLevel - skyDarken);
                float light = Math.max((float)blockLightLevel, modifiedSkylight);
                brightness = MathHelper.getInterpolate(world.worldType.getBrightnessRamp(), light);
            } else {
                int modifiedSkylight = Math.max(0, skyLightLevel - world.skyDarken);
                int light = Math.max(blockLightLevel, modifiedSkylight);
                brightness = world.worldType.getBrightnessRamp()[light];
            }
            brightness = this.applyGamma(brightness, ((Float)this.mc.gameSettings.brightness.value).floatValue() - 0.5f);
            brightness = MathHelper.clamp(brightness, 0.0f, 1.0f);
            int brightnessI = (int)(brightness * 255.0f);
            this.lightmapData[i] = color = 0xFF000000 | brightnessI << 16 | brightnessI << 8 | brightnessI;
        }
    }

    public void generateColorizedLightmap(World world, float partialTicks) {
        float ambientBrightness = world.getAmbientBrightness(partialTicks);
        float brightness = ((Float)this.mc.gameSettings.brightness.value).floatValue() - 0.5f;
        for (int i = 0; i < 256; ++i) {
            float skyLight = this.getBrightnessRemoveMinLight(world, i / 16) * (ambientBrightness * 0.95f + 0.05f);
            float blockLight = this.getBrightnessRemoveMinLight(world, i % 16) * 1.5f;
            if (world.lightningFlicker > 0) {
                skyLight = this.getBrightnessRemoveMinLight(world, i / 16);
            }
            float skyRed = skyLight * (ambientBrightness * 0.65f + 0.35f);
            float skyGreen = skyLight * (ambientBrightness * 0.65f + 0.35f);
            float skyBlue = skyLight;
            float torchRed = blockLight;
            float torchGreen = blockLight * ((blockLight * 0.6f + 0.4f) * 0.6f + 0.4f);
            float torchBlue = blockLight * (blockLight * blockLight * 0.6f + 0.4f);
            float red = skyRed + torchRed;
            float green = skyGreen + torchGreen;
            float blue = skyBlue + torchBlue;
            red = red * 0.96f + 0.03f;
            green = green * 0.96f + 0.03f;
            blue = blue * 0.96f + 0.03f;
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            red = this.applyGamma(red, brightness) * 0.96f + 0.03f;
            green = this.applyGamma(green, brightness) * 0.96f + 0.03f;
            blue = this.applyGamma(blue, brightness) * 0.96f + 0.03f;
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            this.lightmapData[i] = this.toIntARGB(red, green, blue);
        }
    }

    public void generateCustomLightmap(World world) {
        float ambientBrightness = (world.getAmbientBrightness(1.0f) - 0.2f) / 0.8f;
        float brightness = ((Float)this.mc.gameSettings.brightness.value).floatValue();
        int skylightX = MathHelper.floor_float(ambientBrightness * (float)(this.customLightmap.getWidth() - 2));
        for (int i = 0; i < 256; ++i) {
            int blockLightIndex = i % 16;
            int skyLightIndex = i / 16;
            int torchColor = this.customLightmap.getRGB(0, 16 + blockLightIndex);
            int skyColor = this.customLightmap.getRGB(skylightX, skyLightIndex);
            float torchRed = (float)(torchColor >> 16 & 0xFF) / 255.0f;
            float torchGreen = (float)(torchColor >> 8 & 0xFF) / 255.0f;
            float torchBlue = (float)(torchColor >> 0 & 0xFF) / 255.0f;
            float skyRed = (float)(skyColor >> 16 & 0xFF) / 255.0f;
            float skyGreen = (float)(skyColor >> 8 & 0xFF) / 255.0f;
            float skyBlue = (float)(skyColor >> 0 & 0xFF) / 255.0f;
            float red = skyRed + torchRed;
            float green = skyGreen + torchGreen;
            float blue = skyBlue + torchBlue;
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            red = this.applyGamma(red, brightness);
            green = this.applyGamma(green, brightness);
            blue = this.applyGamma(blue, brightness);
            red = MathHelper.clamp(red, 0.0f, 1.0f);
            green = MathHelper.clamp(green, 0.0f, 1.0f);
            blue = MathHelper.clamp(blue, 0.0f, 1.0f);
            this.lightmapData[i] = this.toIntARGB(red, green, blue);
        }
    }

    public void setLightmapTextureData(int[] data) {
        OpenGLHelper.checkError("pre set lightmap data");
        Buffer.checkBufferSize(1024);
        ByteBuffer buffer = Buffer.buffer;
        buffer.clear();
        for (int i = 0; i < data.length; ++i) {
            int color = data[i];
            int a = color >> 24;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            buffer.put((byte)r);
            buffer.put((byte)g);
            buffer.put((byte)b);
            buffer.put((byte)a);
        }
        buffer.position(0);
        buffer.limit(1024);
        if (this.lightmapTexture == 0) {
            this.lightmapTexture = GLAllocation.generateTexture();
            GL11.glBindTexture((int)3553, (int)this.lightmapTexture);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)16, (int)16, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        }
        GL11.glBindTexture((int)3553, (int)this.lightmapTexture);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)16, (int)16, (int)6408, (int)5121, (ByteBuffer)buffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        OpenGLHelper.checkError("set lightmap data");
    }

    public int toIntARGB(float red, float green, float blue) {
        int a = 255;
        int r = (int)(red * 255.0f);
        int g = (int)(green * 255.0f);
        int b = (int)(blue * 255.0f);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public float applyGamma(float color, float gamma) {
        float color2 = 1.0f - color;
        color2 = 1.0f - color2 * color2 * color2 * color2;
        return color * (1.0f - gamma) + color2 * gamma;
    }

    public float getBrightnessRemoveMinLight(World world, int i) {
        float brightness = world.worldType.getBrightnessRamp()[i];
        float min = 0.05f;
        return (brightness - min) / (1.0f - min);
    }

    public static int getLightmapCoord(int skylight, int blocklight) {
        return skylight << 20 | blocklight << 4;
    }

    public static int getOverbrightLightmapCoord(int skylight) {
        return LightmapHelper.getLightmapCoord(skylight, 15);
    }

    public static int max(int lightmapCoord1, int lightmapCoord2) {
        int sky1 = lightmapCoord1 >> 16;
        int sky2 = lightmapCoord2 >> 16;
        int block1 = lightmapCoord1 & 0xFFFF;
        int block2 = lightmapCoord2 & 0xFFFF;
        return Math.max(sky1, sky2) << 16 | Math.max(block1, block2);
    }

    public static int avg(int lmc0, int lmc1) {
        int sky0 = lmc0 >> 16;
        int sky1 = lmc1 >> 16;
        int block0 = lmc0 & 0xFFFF;
        int block1 = lmc1 & 0xFFFF;
        int sky = sky0 + sky1 >> 1;
        int block = block0 + block1 >> 1;
        return sky << 16 | block;
    }

    public static int avg(int lmc0, int lmc1, int lmc2, int lmc3) {
        return LightmapHelper.avg(LightmapHelper.avg(lmc0, lmc1), LightmapHelper.avg(lmc2, lmc3));
    }

    public static void setLightmapCoord(int skylight, int blocklight) {
        GL13.glMultiTexCoord2f((int)33985, (float)((float)blocklight * 16.0f), (float)((float)skylight * 16.0f));
    }

    public static void setLightmapCoord(int lightmapCoord) {
        int sky = lightmapCoord >> 16;
        int block = lightmapCoord & 0xFFFF;
        GL13.glMultiTexCoord2f((int)33985, (float)block, (float)sky);
    }

    public static int setBlocklightValue(int lightmapCoord, int blocklight) {
        return lightmapCoord & 0xFFFF0000 | blocklight << 4;
    }

    public static int setSkylightValue(int lightmapCoord, int skylight) {
        return lightmapCoord & 0xFFFF | skylight << 20;
    }
}

