/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.net.handler.NetClientHandler;
import net.minecraft.client.world.WorldBlockPositionType;
import net.minecraft.client.world.chunk.provider.ChunkProviderClient;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.packet.Packet255KickDisconnect;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.ChunkCoordinates;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pathfinder.IdHashMap;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveHandlerClientMP;

public class WorldClient
extends World {
    private final Minecraft mc;
    private final LinkedList<WorldBlockPositionType> positionTypesList;
    private final NetClientHandler sendQueue;
    private ChunkProviderClient field_20915_C;
    private final IdHashMap<Entity> entityMap;
    private final Set<Entity> field_20914_E;
    private final Set<Entity> field_1053_F;

    public WorldClient(Minecraft minecraft, NetClientHandler netclienthandler, long seed, int dimensionId, int worldTypeId) {
        super((LevelStorage)new SaveHandlerClientMP(), "MpServer", Dimension.getDimensionList().get(dimensionId), Registries.WORLD_TYPES.getItemByNumericId(worldTypeId), seed);
        this.mc = minecraft;
        this.positionTypesList = new LinkedList();
        this.entityMap = new IdHashMap();
        this.field_20914_E = new HashSet<Entity>();
        this.field_1053_F = new HashSet<Entity>();
        this.sendQueue = netclienthandler;
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
        this.savedDataStorage = netclienthandler.savedDataStorage;
    }

    @Override
    public void tick() {
        if (this.getGameRuleValue(GameRules.DO_DAY_CYCLE).booleanValue()) {
            this.levelData.setWorldTime(this.levelData.getWorldTime() + 1L);
        }
        for (int k = 0; k < 10 && !this.field_1053_F.isEmpty(); ++k) {
            Entity entity = this.field_1053_F.iterator().next();
            if (this.loadedEntityList.contains(entity)) continue;
            this.entityJoinedWorld(entity);
        }
        this.processPackets();
        for (int l = 0; l < this.positionTypesList.size(); ++l) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(l);
            if (--worldblockpositiontype.delayTicks != 0) continue;
            super.setBlockAndMetadata(worldblockpositiontype.x, worldblockpositiontype.y, worldblockpositiontype.z, worldblockpositiontype.blockId, worldblockpositiontype.metadata);
            super.markBlockNeedsUpdate(worldblockpositiontype.x, worldblockpositiontype.y, worldblockpositiontype.z);
            this.positionTypesList.remove(l--);
        }
        this.updateSeasonAndLight();
    }

    public void processPackets() {
        this.sendQueue.processReadPackets();
    }

    public void func_711_c(int i, int j, int k, int l, int i1, int j1) {
        for (int k1 = 0; k1 < this.positionTypesList.size(); ++k1) {
            WorldBlockPositionType worldblockpositiontype = this.positionTypesList.get(k1);
            if (worldblockpositiontype.x < i || worldblockpositiontype.y < j || worldblockpositiontype.z < k || worldblockpositiontype.x > l || worldblockpositiontype.y > i1 || worldblockpositiontype.z > j1) continue;
            this.positionTypesList.remove(k1--);
        }
    }

    @Override
    protected IChunkProvider createChunkProvider() {
        this.field_20915_C = new ChunkProviderClient(this);
        return this.field_20915_C;
    }

    @Override
    public void getRespawnLocation() {
        this.setSpawnPoint(new ChunkCoordinates(8, 64, 8));
    }

    @Override
    protected void updateBlocksAndPlayCaveSounds() {
    }

    @Override
    public void scheduleBlockUpdate(int i, int j, int k, int l, int i1) {
    }

    @Override
    public boolean tickUpdates(boolean flag) {
        return false;
    }

    public void doPreChunk(int i, int j, boolean flag) {
        if (flag) {
            this.field_20915_C.prepareChunk(i, j);
        } else {
            this.field_20915_C.func_539_c(i, j);
        }
        if (!flag) {
            this.markBlocksDirty(i * 16, 0, j * 16, i * 16 + 15, this.getHeightBlocks(), j * 16 + 15);
        }
    }

    @Override
    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        this.field_20914_E.add(entity);
        if (!flag) {
            this.field_1053_F.add(entity);
        }
        return flag;
    }

    @Override
    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        this.field_20914_E.remove(entity);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        this.field_1053_F.remove(entity);
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.field_20914_E.contains(entity)) {
            this.field_1053_F.add(entity);
        }
    }

    public void addEntityToWorld(int i, Entity entity) {
        Entity entity1 = this.getEntityFromId(i);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.field_20914_E.add(entity);
        entity.id = i;
        if (!this.entityJoinedWorld(entity)) {
            this.field_1053_F.add(entity);
        }
        this.entityMap.add(i, entity);
    }

    public Entity getEntityFromId(int i) {
        return this.entityMap.get(i);
    }

    public Entity removeEntityFromWorld(int i) {
        Entity entity = this.entityMap.remove(i);
        if (entity != null) {
            this.field_20914_E.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    @Override
    public boolean setBlockMetadata(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        int j1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockMetadata(i, j, k, l)) {
            this.positionTypesList.add(new WorldBlockPositionType(this, i, j, k, i1, j1));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlockAndMetadata(int i, int j, int k, int l, int i1) {
        int j1 = this.getBlockId(i, j, k);
        int k1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockAndMetadata(i, j, k, l, i1)) {
            this.positionTypesList.add(new WorldBlockPositionType(this, i, j, k, j1, k1));
            return true;
        }
        return false;
    }

    @Override
    public boolean setBlock(int x, int y, int z, int id) {
        int blockId = this.getBlockId(x, y, z);
        int meta = this.getBlockMetadata(x, y, z);
        if (super.setBlock(x, y, z, id)) {
            this.positionTypesList.add(new WorldBlockPositionType(this, x, y, z, blockId, meta));
            return true;
        }
        return false;
    }

    public boolean blockChange(int x, int y, int z, int id, int meta) {
        this.func_711_c(x, y, z, x, y, z);
        if (super.setBlockAndMetadata(x, y, z, id, meta)) {
            this.notifyBlockChange(x, y, z, id);
            return true;
        }
        return false;
    }

    @Override
    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.func_28117_a(new Packet255KickDisconnect("Quitting"));
    }

    @Override
    public void sendGlobalMessage(String message) {
    }
}

