/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import java.io.IOException;
import java.util.Arrays;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;

public class ChunkProviderStatic
implements IChunkProvider {
    private Chunk blankChunk;
    public ChunkGenerator chunkGenerator;
    private IChunkLoader chunkLoader;
    private Chunk[] chunks = new Chunk[1024];
    private World worldObj;
    int lastQueriedChunkXPos = -999999999;
    int lastQueriedChunkZPos = -999999999;
    private Chunk lastQueriedChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderStatic(World world, IChunkLoader ichunkloader, ChunkGenerator chunkGenerator) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public void setCurrentChunkOver(int chunkX, int chunkZ) {
        this.curChunkX = chunkX;
        this.curChunkY = chunkZ;
    }

    public boolean canChunkExist(int chunkX, int chunkZ) {
        int byte0 = 15;
        return chunkX >= this.curChunkX - byte0 && chunkZ >= this.curChunkY - byte0 && chunkX <= this.curChunkX + byte0 && chunkZ <= this.curChunkY + byte0;
    }

    @Override
    public void regenerateChunk(int chunkX, int chunkZ) {
        int k = chunkX & 0x1F;
        int l = chunkZ & 0x1F;
        int i1 = k + l * 32;
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk newChunk = this.chunkGenerator.generate(chunkX, chunkZ);
        newChunk.fixMissingBlocks();
        this.chunks[i1] = newChunk;
        if (!this.chunks[i1].isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
            this.populate(this, chunkX, chunkZ);
        }
        if (this.isChunkLoaded(chunkX - 1, chunkZ) && !this.provideChunk((int)(chunkX - 1), (int)chunkZ).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
            this.populate(this, chunkX - 1, chunkZ);
        }
        if (this.isChunkLoaded(chunkX, chunkZ - 1) && !this.provideChunk((int)chunkX, (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
            this.populate(this, chunkX, chunkZ - 1);
        }
        if (this.isChunkLoaded(chunkX - 1, chunkZ - 1) && !this.provideChunk((int)(chunkX - 1), (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
            this.populate(this, chunkX - 1, chunkZ - 1);
        }
    }

    @Override
    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        if (!this.canChunkExist(chunkX, chunkZ)) {
            return false;
        }
        if (chunkX == this.lastQueriedChunkXPos && chunkZ == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return true;
        }
        int k = chunkX & 0x1F;
        int l = chunkZ & 0x1F;
        int chunkIndex = k + l * 32;
        return this.chunks[chunkIndex] == this.blankChunk || this.chunks[chunkIndex] != null && this.chunks[chunkIndex].isAtLocation(chunkX, chunkZ);
    }

    @Override
    public Chunk prepareChunk(int chunkX, int chunkZ) {
        return this.provideChunk(chunkX, chunkZ);
    }

    @Override
    public Chunk provideChunk(int chunkX, int chunkZ) {
        if (chunkX == this.lastQueriedChunkXPos && chunkZ == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.worldObj.findingSpawnPoint && !this.canChunkExist(chunkX, chunkZ)) {
            return this.blankChunk;
        }
        int k = chunkX & 0x1F;
        int l = chunkZ & 0x1F;
        int i1 = k + l * 32;
        if (!this.isChunkLoaded(chunkX, chunkZ)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.saveChunk(this.chunks[i1]);
                this.chunks[i1].onUnload();
            }
            if ((chunk = this.loadChunk(chunkX, chunkZ)) == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkX, chunkZ);
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.blankChunk;
                }
            }
            this.chunks[i1] = chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].onLoad();
            }
            if (!this.chunks[i1].isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
                this.populate(this, chunkX, chunkZ);
            }
            if (this.isChunkLoaded(chunkX - 1, chunkZ) && !this.provideChunk((int)(chunkX - 1), (int)chunkZ).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ + 1) && this.isChunkLoaded(chunkX, chunkZ + 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
                this.populate(this, chunkX - 1, chunkZ);
            }
            if (this.isChunkLoaded(chunkX, chunkZ - 1) && !this.provideChunk((int)chunkX, (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX + 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX + 1, chunkZ)) {
                this.populate(this, chunkX, chunkZ - 1);
            }
            if (this.isChunkLoaded(chunkX - 1, chunkZ - 1) && !this.provideChunk((int)(chunkX - 1), (int)(chunkZ - 1)).isTerrainPopulated && this.isChunkLoaded(chunkX - 1, chunkZ - 1) && this.isChunkLoaded(chunkX, chunkZ - 1) && this.isChunkLoaded(chunkX - 1, chunkZ)) {
                this.populate(this, chunkX - 1, chunkZ - 1);
            }
            if (this.worldObj.getCurrentWeather() != null) {
                this.worldObj.getCurrentWeather().doChunkLoadEffect(this.worldObj, chunk);
            }
        }
        this.lastQueriedChunkXPos = chunkX;
        this.lastQueriedChunkZPos = chunkZ;
        this.lastQueriedChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk loadChunk(int i, int j) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, i, j);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.blankChunk;
        }
    }

    private void saveChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.chunkLoader.saveChunk(this.worldObj, chunk);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void populate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        Chunk chunk = this.provideChunk(chunkX, chunkZ);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkGenerator != null) {
                this.chunkGenerator.decorate(chunk);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, ProgressListener progressUpdate) {
        int i = 0;
        int j = 0;
        if (progressUpdate != null) {
            for (int k = 0; k < this.chunks.length; ++k) {
                if (this.chunks[k] == null || !this.chunks[k].needsSaving(saveImmediately)) continue;
                ++j;
            }
        }
        int l = 0;
        for (int i1 = 0; i1 < this.chunks.length; ++i1) {
            if (this.chunks[i1] == null || !this.chunks[i1].needsSaving(saveImmediately)) continue;
            this.saveChunk(this.chunks[i1]);
            this.chunks[i1].isModified = false;
            if (++i == 2 && !saveImmediately) {
                return false;
            }
            if (progressUpdate == null || ++l % 10 != 0) continue;
            progressUpdate.progressStagePercentage(l * 100 / j);
        }
        return true;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
        for (Chunk chunk : this.chunks) {
            if (chunk == null) continue;
            chunk.onUnload();
        }
        Arrays.fill(this.chunks, null);
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String getInfoString() {
        return "ChunkCache: " + this.chunks.length;
    }

    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }
}

