/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.entity;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.world.IVehicle;

public class TileEntitySeat
extends TileEntity
implements IVehicle {
    private Entity passenger = null;

    @Override
    public void tick() {
        if (this.passenger != null) {
            this.worldObj.updateEntity(this.passenger);
        }
        if (this.worldObj.getBlock(this.x, this.y, this.z) != Block.seat) {
            this.ejectRider();
        }
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public Entity ejectRider() {
        Entity entity = this.passenger;
        if (entity == null) {
            return null;
        }
        this.passenger = null;
        entity.vehicle = null;
        if (this.isSafe(this.x, this.y + 1, this.z)) {
            entity.moveTo((double)this.x + 0.5, this.y + 1, (double)this.z + 0.5, entity.yRot, entity.xRot);
        } else if (this.isSafe(this.x - 1, this.y, this.z)) {
            entity.moveTo((double)this.x - 0.5, this.y, (double)this.z + 0.5, entity.yRot, entity.xRot);
        } else if (this.isSafe(this.x + 1, this.y, this.z)) {
            entity.moveTo((double)this.x + 1.5, this.y, (double)this.z + 0.5, entity.yRot, entity.xRot);
        } else if (this.isSafe(this.x, this.y, this.z - 1)) {
            entity.moveTo((double)this.x + 0.5, this.y, (double)this.z - 0.5, entity.yRot, entity.xRot);
        } else if (this.isSafe(this.x, this.y, this.z + 1)) {
            entity.moveTo((double)this.x + 0.5, this.y, (double)this.z + 1.5, entity.yRot, entity.xRot);
        } else {
            entity.moveTo((double)this.x + 0.5, this.y + 1, (double)this.z + 0.5, entity.yRot, entity.xRot);
        }
        return entity;
    }

    private boolean isSafe(int x, int y, int z) {
        return !this.worldObj.isBlockNormalCube(x, y, z) && !this.worldObj.isBlockNormalCube(x, y + 1, z);
    }

    @Override
    public void positionRider() {
        this.passenger.setPos((double)this.x + 0.5, (double)this.y + 0.5 + this.passenger.getRidingHeight(), (double)this.z + 0.5);
    }

    @Override
    public void setPassenger(Entity entity) {
        this.passenger = entity;
    }

    @Override
    public Entity getPassenger() {
        return this.passenger;
    }

    @Override
    public void moveExitingEntity(Entity entity) {
        entity.moveTo(this.x, this.y + 2, this.z, entity.yRot, entity.xRot);
    }

    @Override
    public float getYRotDelta() {
        return 0.0f;
    }

    @Override
    public float getXRotDelta() {
        return 0.0f;
    }
}

