/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;

public class ItemFood
extends Item {
    private final int healAmount;
    private final boolean isWolfsFavoriteMeat;
    private final int ticksPerHeal;

    public ItemFood(String name, int id, int healAmount, int ticksPerHeal, boolean favouriteWolfMeat, int maxStackSize) {
        super(name, id);
        this.healAmount = healAmount;
        this.ticksPerHeal = ticksPerHeal;
        this.isWolfsFavoriteMeat = favouriteWolfMeat;
        this.maxStackSize = maxStackSize;
    }

    @Override
    public ItemStack onUseItem(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (entityplayer.getHealth() < entityplayer.getMaxHealth() && entityplayer.getHealth() + entityplayer.getTotalHealingRemaining() < entityplayer.getMaxHealth() && itemstack.consumeItem(entityplayer)) {
            entityplayer.eatFood(this);
        }
        return itemstack;
    }

    public int getHealAmount() {
        return this.healAmount;
    }

    public int getTicksPerHeal() {
        return this.ticksPerHeal;
    }

    public boolean getIsWolfsFavoriteMeat() {
        return this.isWolfsFavoriteMeat;
    }
}

