/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import com.b100.utils.InvalidCharacterException;
import com.b100.utils.StringReader;
import net.minecraft.core.util.helper.Utils;

public class Color {
    public int value;

    public Color setRGBA(int r, int g, int b, int a) {
        this.value = ((a &= 0xFF) << 24) + ((r &= 0xFF) << 16) + ((g &= 0xFF) << 8) + (b &= 0xFF);
        return this;
    }

    public Color setARGB(int value) {
        this.value = value;
        return this;
    }

    public Color setRGB(int r, int g, int b) {
        return this.setRGBA(r, g, b, 255);
    }

    public void parse(String colorString) {
        try {
            int red = 0;
            int green = 0;
            int blue = 0;
            int alpha = 0;
            StringReader reader = new StringReader(colorString);
            while (true) {
                char c = reader.get();
                reader.expectOne("rgba");
                reader.next();
                reader.expectAndSkip('=');
                if (c == 'r') {
                    red = Integer.parseInt(reader.readUntilCharacter(','));
                } else if (c == 'g') {
                    green = Integer.parseInt(reader.readUntilCharacter(','));
                } else if (c == 'b') {
                    blue = Integer.parseInt(reader.readUntilCharacter(','));
                } else if (c == 'a') {
                    alpha = Integer.parseInt(reader.readUntilCharacter(','));
                } else {
                    throw new InvalidCharacterException(reader);
                }
                if (reader.remainingCharacters() == 0) break;
                reader.expectAndSkip(',');
            }
            this.setRGBA(red, green, blue, alpha);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid Color String: \"" + colorString + "\"", e);
        }
    }

    public int getARGB() {
        return this.value;
    }

    public int getAlpha() {
        return this.value >> 24 & 0xFF;
    }

    public int getRed() {
        return this.value >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.value >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.value & 0xFF;
    }

    public String toPropertiesString() {
        return "r=" + this.getRed() + ",g=" + this.getGreen() + ",b=" + this.getBlue() + ",a=" + this.getAlpha();
    }

    public String toHexRGBA() {
        return "0x" + Utils.toHex(this.getRed(), 2) + Utils.toHex(this.getGreen(), 2) + Utils.toHex(this.getBlue(), 2) + Utils.toHex(this.getAlpha(), 2);
    }

    public String toString() {
        return this.toHexRGBA();
    }

    public static int byteToIntARGB(byte a, byte r, byte g, byte b) {
        return ((a & 0xFF) << 24) + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    public static int intToIntARGB(int a, int r, int g, int b) {
        return ((a & 0xFF) << 24) + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }

    public void setRGB(Color newColor) {
        this.setRGBA(newColor.getRed(), newColor.getGreen(), newColor.getBlue(), this.getAlpha());
    }

    public void setARGB(Color newColor) {
        this.value = newColor.value;
    }
}

