/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import java.io.File;
import java.util.List;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkLoaderRegionAsync;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.SaveHandlerBase;

public class SaveHandlerClientSP
extends SaveHandlerBase {
    public SaveHandlerClientSP(ISaveFormat saveFormat, File savesDir, String worldDirName, boolean isMultiplayer) {
        super(saveFormat, savesDir, worldDirName, isMultiplayer);
    }

    @Override
    public IChunkLoader getChunkLoader(Dimension dimension) {
        File dimDir = this.saveFormat.getDimensionRootDir(this.worldDirName, dimension);
        dimDir.mkdirs();
        return new ChunkLoaderRegionAsync(dimDir);
    }

    @Override
    public void saveLevelDataAndPlayerData(LevelData levelData, List<EntityPlayer> playerList) {
        levelData.setSaveVersion(this.saveFormat.getSaveVersion());
        super.saveLevelDataAndPlayerData(levelData, playerList);
    }
}

