/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.helpers.EntitySelector;
import net.minecraft.core.util.helper.LoggedPrintStream;

public class CommandMessage
implements CommandManager.CommandRegistry {
    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode<CommandSource> command = dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("message").then(RequiredArgumentBuilder.argument("targets", ArgumentTypeEntity.players()).then(RequiredArgumentBuilder.argument("message", StringArgumentType.greedyString()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("targets", EntitySelector.class);
            String message = c.getArgument("message", String.class);
            String senderName = source.getName();
            List<? extends Entity> players = entitySelector.get(source);
            for (Entity entity : players) {
                source.sendMessage(TextFormatting.LIGHT_GRAY.toString() + TextFormatting.ITALIC.toString() + I18n.getInstance().translateKeyAndFormat("command.commands.message.outgoing", LoggedPrintStream.removeColorCodes(((Player)entity).getDisplayName()), message));
                source.sendMessage((Player)entity, TextFormatting.LIGHT_GRAY + TextFormatting.ITALIC + I18n.getInstance().translateKeyAndFormat("command.commands.message.incoming", senderName, message));
            }
            return 1;
        }))));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("msg").redirect(command));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("whisper").redirect(command));
        dispatcher.register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("tell").redirect(command));
    }
}

