/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.arguments.ArgumentTypeBlock;
import net.minecraft.core.net.command.arguments.ArgumentTypeIntegerCoordinates;
import net.minecraft.core.net.command.helpers.BlockInput;
import net.minecraft.core.net.command.helpers.IntegerCoordinates;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class CommandSetBlock
implements CommandManager.CommandRegistry {
    private static final SimpleCommandExceptionType FAILURE = new SimpleCommandExceptionType(() -> I18n.getInstance().translateKey("command.commands.setblock.exception_failure"));

    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal("setblock").requires(CommandSource::hasAdmin)).then(RequiredArgumentBuilder.argument("position", ArgumentTypeIntegerCoordinates.intCoordinates()).then(RequiredArgumentBuilder.argument("block", ArgumentTypeBlock.block()).executes(c -> {
            int z;
            int y;
            int x;
            CommandSource source = (CommandSource)c.getSource();
            IntegerCoordinates coordinates = c.getArgument("position", IntegerCoordinates.class);
            BlockInput blockInput = c.getArgument("block", BlockInput.class);
            World world = source.getWorld();
            if (!world.isBlockLoaded(x = coordinates.getX(source), y = coordinates.getY(source, true), z = coordinates.getZ(source))) {
                throw FAILURE.create();
            }
            world.setBlockWithNotify(x, y, z, blockInput.getBlockId());
            world.setBlockMetadataWithNotify(x, y, z, blockInput.getMetadata());
            CommandHelper.setTileEntity((WorldSource)world, x, y, z, blockInput.getTag());
            source.sendTranslatableMessage("command.commands.setblock.success", coordinates.getX(source), coordinates.getY(source, true), coordinates.getZ(source));
            return 1;
        }))));
    }
}

