/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NotNull;

public class NbtIo {
    public static CompoundTag readCompressed(InputStream inputStream) throws IOException {
        try (DataInputStream datainputstream = new DataInputStream(new GZIPInputStream(inputStream));){
            CompoundTag compoundTag = NbtIo.read(datainputstream);
            return compoundTag;
        }
    }

    public static void writeCompressed(@NotNull CompoundTag tag, OutputStream outputStream) throws IOException {
        try (DataOutputStream dataoutputstream = new DataOutputStream(new GZIPOutputStream(outputStream));){
            NbtIo.write(tag, dataoutputstream);
        }
    }

    @NotNull
    public static CompoundTag read(DataInput dataInput) throws IOException {
        Tag<?> tag = Tag.readNamedTag(dataInput);
        if (!(tag instanceof CompoundTag)) {
            throw new IOException("Root tag must be a named compound tag!");
        }
        return (CompoundTag)tag;
    }

    public static void write(@NotNull CompoundTag tag, DataOutput dataOutput) throws IOException {
        Tag.writeNamedTag(tag, dataOutput);
    }
}

