/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.logging.LogUtils;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.TileEntityChest;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.container.ContainerCompound;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class BlockLogicChest
extends BlockLogic
implements IPaintable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int directionBits = 3;
    public static final int directionOffset = 0;
    public static final int typeBits = 12;
    public static final int typeOffset = 2;

    public BlockLogicChest(Block<?> block, Material material) {
        super(block, material);
        block.withEntity(TileEntityChest::new);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, @NotNull Side placeSide, Mob mob, double xPlaced, double yPlaced) {
        Direction direction = mob.getHorizontalPlacementDirection(placeSide).getOpposite();
        Type type = Type.SINGLE;
        if (mob.isSneaking() && placeSide.isHorizontal() && (mob.rotationLockHorizontal == null || mob.rotationLockHorizontal == Direction.NONE)) {
            int placedOnX = x;
            int placedOnZ = z;
            if (placeSide == Side.NORTH) {
                ++placedOnZ;
            }
            if (placeSide == Side.SOUTH) {
                --placedOnZ;
            }
            if (placeSide == Side.EAST) {
                --placedOnX;
            }
            if (placeSide == Side.WEST) {
                ++placedOnX;
            }
            if (BlockLogicChest.isSingleChest(world, placedOnX, y, placedOnZ)) {
                Direction direction2 = BlockLogicChest.getDirectionFromMeta(world.getBlockMetadata(placedOnX, y, placedOnZ));
                if (direction2 == Direction.NORTH) {
                    if (placeSide == Side.EAST) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (placeSide == Side.WEST) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.EAST) {
                    if (placeSide == Side.SOUTH) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                    if (placeSide == Side.NORTH) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.SOUTH) {
                    if (placeSide == Side.EAST) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (placeSide == Side.WEST) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
                if (direction2 == Direction.WEST) {
                    if (placeSide == Side.SOUTH) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.LEFT);
                        type = Type.RIGHT;
                        direction = direction2;
                    }
                    if (placeSide == Side.NORTH) {
                        BlockLogicChest.setType(world, placedOnX, y, placedOnZ, Type.RIGHT);
                        type = Type.LEFT;
                        direction = direction2;
                    }
                }
            }
        } else if (!mob.isSneaking()) {
            if (direction == Direction.NORTH) {
                if (BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, x - 1, y, z, Type.RIGHT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, x + 1, y, z, Type.LEFT);
                }
            }
            if (direction == Direction.EAST) {
                if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, x, y, z - 1, Type.RIGHT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, x, y, z + 1, Type.LEFT);
                }
            }
            if (direction == Direction.SOUTH) {
                if (BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, x - 1, y, z, Type.LEFT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, x + 1, y, z, Type.RIGHT);
                }
            }
            if (direction == Direction.WEST) {
                if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                    type = Type.RIGHT;
                    BlockLogicChest.setType(world, x, y, z - 1, Type.LEFT);
                }
                if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                    type = Type.LEFT;
                    BlockLogicChest.setType(world, x, y, z + 1, Type.RIGHT);
                }
            }
        }
        int meta = world.getBlockMetadata(x, y, z);
        meta = BlockLogicChest.getMetaWithDirection(meta, direction);
        meta = BlockLogicChest.getMetaWithType(meta, type);
        world.setBlockMetadata(x, y, z, meta);
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        Direction direction = side.getDirection();
        Type type = Type.SINGLE;
        if (direction == Direction.NORTH) {
            if (BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, x - 1, y, z, Type.RIGHT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, x + 1, y, z, Type.LEFT);
            }
        }
        if (direction == Direction.EAST) {
            if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, x, y, z - 1, Type.RIGHT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, x, y, z + 1, Type.LEFT);
            }
        }
        if (direction == Direction.SOUTH) {
            if (BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, x - 1, y, z, Type.LEFT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, x + 1, y, z, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x - 1, y, z, direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, x + 1, y, z, Type.RIGHT);
            }
        }
        if (direction == Direction.WEST) {
            if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction)) {
                type = Type.RIGHT;
                BlockLogicChest.setType(world, x, y, z - 1, Type.LEFT);
            }
            if (BlockLogicChest.isSingleChestWithDirection(world, x, y, z + 1, direction) && !BlockLogicChest.isSingleChestWithDirection(world, x, y, z - 1, direction)) {
                type = Type.LEFT;
                BlockLogicChest.setType(world, x, y, z + 1, Type.RIGHT);
            }
        }
        int meta = world.getBlockMetadata(x, y, z);
        meta = BlockLogicChest.getMetaWithDirection(meta, direction);
        meta = BlockLogicChest.getMetaWithType(meta, type);
        world.setBlockMetadata(x, y, z, meta);
    }

    public void checkIfOtherHalfExists(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            Direction direction = BlockLogicChest.getDirectionFromMeta(meta);
            int otherChestX = x;
            int otherChestZ = z;
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChestX;
                }
                if (type == Type.RIGHT) {
                    ++otherChestX;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChestZ;
                }
                if (type == Type.RIGHT) {
                    ++otherChestZ;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChestX;
                }
                if (type == Type.RIGHT) {
                    --otherChestX;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChestZ;
                }
                if (type == Type.RIGHT) {
                    --otherChestZ;
                }
            }
            boolean valid = false;
            if (BlockLogicChest.isChest(world, otherChestX, y, otherChestZ) && BlockLogicChest.getDirectionFromMeta(otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ)) == direction) {
                Type otherType = BlockLogicChest.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT || type == Type.RIGHT && otherType == Type.LEFT) {
                    valid = true;
                }
            }
            if (!valid) {
                BlockLogicChest.setType(world, x, y, z, Type.SINGLE);
                world.markBlocksDirty(x, y, z, x, y, z);
            }
        }
    }

    public static void setDefaultDirection(World world, int x, int y, int z) {
        if (world.isClientSide) {
            return;
        }
        int bN = world.getBlockId(x, y, z - 1);
        int bS = world.getBlockId(x, y, z + 1);
        int bW = world.getBlockId(x - 1, y, z);
        int bE = world.getBlockId(x + 1, y, z);
        Direction direction = Direction.NORTH;
        if (Blocks.solid[bN] && !Blocks.solid[bS]) {
            direction = Direction.SOUTH;
        }
        if (Blocks.solid[bS] && !Blocks.solid[bN]) {
            direction = Direction.NORTH;
        }
        if (Blocks.solid[bW] && !Blocks.solid[bE]) {
            direction = Direction.EAST;
        }
        if (Blocks.solid[bE] && !Blocks.solid[bW]) {
            direction = Direction.WEST;
        }
        world.setBlockMetadataWithNotify(x, y, z, BlockLogicChest.getMetaWithType(BlockLogicChest.getMetaWithDirection(world.getBlockMetadata(x, y, z), direction), Type.SINGLE));
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        super.onNeighborBlockChange(world, x, y, z, blockId);
        this.checkIfOtherHalfExists(world, x, y, z);
    }

    public static boolean isChest(World world, int x, int y, int z) {
        Block<?> b = Blocks.blocksList[world.getBlockId(x, y, z)];
        return b != null && b.getLogic() instanceof BlockLogicChest;
    }

    public static boolean isSingleChest(World world, int x, int y, int z) {
        return BlockLogicChest.isChest(world, x, y, z) && BlockLogicChest.getTypeFromMeta(world.getBlockMetadata(x, y, z)) == Type.SINGLE;
    }

    public static boolean isSingleChestWithDirection(World world, int x, int y, int z, Direction direction) {
        int meta = world.getBlockMetadata(x, y, z);
        return BlockLogicChest.isChest(world, x, y, z) && BlockLogicChest.getTypeFromMeta(meta) == Type.SINGLE && BlockLogicChest.getDirectionFromMeta(meta) == direction;
    }

    public void setDirection(World world, int x, int y, int z, Direction direction) {
        if (BlockLogicChest.isChest(world, x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, BlockLogicChest.getMetaWithDirection(world.getBlockMetadata(x, y, z), direction));
        }
    }

    public static void setType(World world, int x, int y, int z, Type type) {
        if (BlockLogicChest.isChest(world, x, y, z)) {
            world.setBlockMetadataWithNotify(x, y, z, BlockLogicChest.getMetaWithType(world.getBlockMetadata(x, y, z), type));
        }
    }

    public static Direction getDirection(World world, int x, int y, int z) {
        if (BlockLogicChest.isChest(world, x, y, z)) {
            return BlockLogicChest.getDirectionFromMeta(world.getBlockMetadata(x, y, z));
        }
        return null;
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        this.checkIfOtherHalfExists(world, x, y, z);
        player.displayContainerScreen(BlockLogicChest.getInventory(world, x, y, z));
        return true;
    }

    public static Container getInventory(World world, int x, int y, int z) {
        Container inventory = (Container)((Object)world.getTileEntity(x, y, z));
        int meta = world.getBlockMetadata(x, y, z);
        Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (type != Type.SINGLE) {
            int otherMeta;
            Container inv2 = null;
            Direction direction = BlockLogicChest.getDirectionFromMeta(meta);
            int otherChestX = x;
            int otherChestZ = z;
            if (direction == Direction.NORTH) {
                if (type == Type.LEFT) {
                    --otherChestX;
                }
                if (type == Type.RIGHT) {
                    ++otherChestX;
                }
            }
            if (direction == Direction.EAST) {
                if (type == Type.LEFT) {
                    --otherChestZ;
                }
                if (type == Type.RIGHT) {
                    ++otherChestZ;
                }
            }
            if (direction == Direction.SOUTH) {
                if (type == Type.LEFT) {
                    ++otherChestX;
                }
                if (type == Type.RIGHT) {
                    --otherChestX;
                }
            }
            if (direction == Direction.WEST) {
                if (type == Type.LEFT) {
                    ++otherChestZ;
                }
                if (type == Type.RIGHT) {
                    --otherChestZ;
                }
            }
            if (BlockLogicChest.isChest(world, otherChestX, y, otherChestZ) && BlockLogicChest.getDirectionFromMeta(otherMeta = world.getBlockMetadata(otherChestX, y, otherChestZ)) == direction) {
                Type otherType = BlockLogicChest.getTypeFromMeta(otherMeta);
                if (type == Type.LEFT && otherType == Type.RIGHT) {
                    inv2 = (Container)((Object)world.getTileEntity(otherChestX, y, otherChestZ));
                }
                if (type == Type.RIGHT && otherType == Type.LEFT) {
                    inv2 = inventory;
                    inventory = (Container)((Object)world.getTileEntity(otherChestX, y, otherChestZ));
                }
            }
            if (inv2 != null) {
                inventory = new ContainerCompound("container.chest.large.name", inventory, inv2);
            }
        }
        return inventory;
    }

    public static int getMetaWithDirection(int meta, Direction direction) {
        if (direction == null) {
            return meta;
        }
        meta &= 0xFFFFFFFC;
        return meta |= direction.ordinal() << 0 & 3;
    }

    public static int getMetaWithType(int meta, Type type) {
        if (type == null) {
            return meta;
        }
        meta &= 0xFFFFFFF3;
        return meta |= type.ordinal() << 2 & 0xC;
    }

    public static Direction getDirectionFromMeta(int meta) {
        switch (meta &= 3) {
            case 0: {
                return Direction.NORTH;
            }
            case 1: {
                return Direction.EAST;
            }
            case 2: {
                return Direction.SOUTH;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NONE;
    }

    public static Type getTypeFromMeta(int meta) {
        return Type.get(meta >> 2 & 3);
    }

    @Override
    public void setColor(World world, int x, int y, int z, DyeColor color) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockAndMetadata(x, y, z, Blocks.CHEST_PLANKS_OAK_PAINTED.id(), meta);
        Blocks.CHEST_PLANKS_OAK_PAINTED.getLogic().setColor(world, x, y, z, color);
    }

    public static enum Type {
        SINGLE,
        LEFT,
        RIGHT;


        public static Type get(int i) {
            if (i < 0 || i >= Type.values().length) {
                i = 0;
            }
            return Type.values()[i];
        }
    }
}

