/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPaintBrush
extends Item {
    private static final int DAMAGE_PER_DYE = 8;

    public ItemPaintBrush(String translationKey, String namespaceId, int id) {
        super(translationKey, namespaceId, id);
        this.setMaxStackSize(1);
        this.setMaxDamage(64);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        int id = world.getBlockId(blockX, blockY, blockZ);
        Block<?> block = Blocks.getBlock(id);
        if (Block.hasLogicClass(block, IPaintable.class)) {
            IPaintable paintable = (IPaintable)block.getLogic();
            if (!paintable.canBePainted()) {
                return false;
            }
            DyeColor color = ItemPaintBrush.getColor(itemstack);
            if (color != null) {
                if (paintable instanceof IPainted && ((IPainted)paintable).getColor(world, blockX, blockY, blockZ) == color) {
                    return false;
                }
                paintable.setColor(world, blockX, blockY, blockZ, color);
                if (itemstack.getMetadata() >= itemstack.getMaxDamage()) {
                    ItemPaintBrush.setColor(itemstack, null);
                    itemstack.setMetadata(this.getMaxDamage());
                } else {
                    itemstack.damageItem(1, player);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUseByActivator(ItemStack itemStack, TileEntityActivator activatorBlock, World world, Random random, int blockX, int blockY, int blockZ, double offX, double offY, double offZ, Direction direction) {
        int x = blockX + direction.getOffsetX();
        int y = blockY + direction.getOffsetY();
        int z = blockZ + direction.getOffsetZ();
        this.onUseItemOnBlock(itemStack, null, world, x, y, z, direction.getSide(), 0.5, 0.5);
    }

    @Override
    public boolean hasInventoryInteraction() {
        return true;
    }

    @Override
    public ItemStack onInventoryInteract(Player player, Slot slot, ItemStack stackInSlot, boolean isItemGrabbed) {
        if (isItemGrabbed) {
            return stackInSlot;
        }
        DyeColor currentColor = ItemPaintBrush.getColor(stackInSlot);
        int dyeCount = this.getDyeCount(stackInSlot);
        ItemStack grabbedItem = player.inventory.getHeldItemStack();
        if (grabbedItem != null && grabbedItem.getItem() instanceof ItemDye) {
            DyeColor newColor = DyeColor.colorFromItemMeta(grabbedItem.getMetadata());
            if (currentColor != newColor) {
                ItemPaintBrush.setColor(stackInSlot, newColor);
                this.setDyeCount(stackInSlot, 8);
                --grabbedItem.stackSize;
                if (grabbedItem.stackSize <= 0) {
                    player.inventory.setHeldItemStack(null);
                }
            } else if (dyeCount < this.getMaxDamage()) {
                int newDyeCount = Math.min(dyeCount + 8, stackInSlot.getMaxDamage());
                this.setDyeCount(stackInSlot, newDyeCount);
                --grabbedItem.stackSize;
                if (grabbedItem.stackSize <= 0) {
                    player.inventory.setHeldItemStack(null);
                }
            }
        }
        return stackInSlot;
    }

    @Override
    public boolean showFullDurability() {
        return false;
    }

    public int getDyeCount(ItemStack stack) {
        return stack.getMaxDamage() - stack.getMetadata();
    }

    public void setDyeCount(ItemStack stack, int count) {
        stack.setMetadata(stack.getMaxDamage() - count);
    }

    public static DyeColor getColor(@NotNull ItemStack stack) {
        CompoundTag tag = stack.getData();
        if (tag.containsKey("Color")) {
            int color = tag.getInteger("Color");
            if (color < 0) {
                return null;
            }
            return DyeColor.colorFromItemMeta(color & 0xF);
        }
        return null;
    }

    public static void setColor(@NotNull ItemStack stack, @Nullable DyeColor color) {
        CompoundTag tag = stack.getData();
        if (color == null) {
            tag.putInt("Color", -1);
        } else {
            tag.putInt("Color", color.itemMeta);
        }
    }
}

